# Build script for creating the WUDSN IDE zero installation download archives.
# This script builds the Linix 32-bit version and the Mac OS X 32-bit verion.
# It assumes that the latest version of the compilers are present locally.
#
# The installation directory on Windows is "C:\jac\wudsn".
# The installation directory on Linux is "~/jac/wudsn".
# The installation directory on Mac OS X is "~/jac/wudsn".
#
# The following folders are taken from the Windows 32-bit zero installation download archive
# - jac/wudsn/Workspace (i.e. all sources, except .metadata with the platform specific preferences)
# The remaining folders are taken from the local Linux or Mac OS X installation.

set -e
pushd /tmp

export platform="`uname`"
if [[ $platform == Linux* ]]
 then export target=linux
 else if [[ $platform = Darwin* ]]
      then export target=macosx
      else if [[ $platform == CYGWIN_NT* ]]
           then export target=windows
           else echo Unknown OS platform $platform.
                exit
           fi
      fi
fi


export download_url=http://www.wudsn.com/productions/java/ide/downloads/wudsn-ide-win32.zip
export zipfile=wudsn-ide.zip
export sourcedir=/tmp/jac/wudsn
export targetdir=~/jac/wudsn
export targetfile=wudsn-ide-$target.zip

echo Building WUDSN IDE for target "'$target'".
echo Downloading "$download_url".
curl -o $zipfile -z $zipfile $download_url

echo Unzipping archive.
rm -rf $zipfile.log jac
mkdir -p $sourcedir
unzip -o $zipfile -d $sourcedir >$zipfile.log

echo Merging $sourcedir with local installation $targetdir.
rm -f $targetfile
# Keep local workspace .metadata with settings
rm -rf $sourcedir/.metadata
# Remove local workspace examples
rm -rf $targetdir/Workspace/*
# Take over global workspace examples
mv $sourcedir/Workspace/* $targetdir/Workspace

