/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.viewers;

import java.net.URI;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.ui.ProvUIImages;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.model.IRepositoryElement;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositoryElement;
import org.eclipse.equinox.internal.p2.ui.model.ProvElement;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.graphics.Image;

public class RepositoryDetailsLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public static final int COL_NAME = 0;
    public static final int COL_LOCATION = 1;
    public static final int COL_ENABLEMENT = 2;

    public Image getImage(Object obj) {
        if (obj instanceof ProvElement) {
            return ((ProvElement)obj).getImage(obj);
        }
        if (obj instanceof IArtifactRepository) {
            return ProvUIImages.getImage("obj/artifact_repo_obj.gif");
        }
        if (obj instanceof IMetadataRepository) {
            return ProvUIImages.getImage("obj/metadata_repo_obj.gif");
        }
        return null;
    }

    public Image getColumnImage(Object element, int index) {
        if (index == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                String name;
                if (element instanceof IRepositoryElement && (name = ((IRepositoryElement)element).getName()) != null) {
                    return name;
                }
                if (element instanceof IRepository && (name = ((IRepository)element).getName()) != null) {
                    return name;
                }
                return "";
            }
            case 1: {
                if (element instanceof IRepository) {
                    return TextProcessor.process((String)URIUtil.toUnencodedString((URI)((IRepository)element).getLocation()));
                }
                if (!(element instanceof IRepositoryElement)) break;
                return TextProcessor.process((String)URIUtil.toUnencodedString((URI)((IRepositoryElement)element).getLocation()));
            }
            case 2: {
                if (!(element instanceof MetadataRepositoryElement)) break;
                return ((MetadataRepositoryElement)element).isEnabled() ? ProvUIMessages.RepositoryDetailsLabelProvider_Enabled : ProvUIMessages.RepositoryDetailsLabelProvider_Disabled;
            }
        }
        return null;
    }

    public String getClipboardText(Object element, String columnDelimiter) {
        StringBuffer result = new StringBuffer();
        result.append(this.getColumnText(element, 0));
        result.append(columnDelimiter);
        result.append(this.getColumnText(element, 1));
        result.append(columnDelimiter);
        result.append(this.getColumnText(element, 2));
        return result.toString();
    }
}

