/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmError;
import cml.kickass.function.DoubleFunction;
import cml.kickass.function.DoubleX2Function;
import cml.kickass.function.Function;
import cml.kickass.function.IntFunction;
import cml.kickass.function.IntX2Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.BooleanValue;
import cml.kickass.values.ImmutableValue;
import cml.kickass.values.Value;

public class NumberValue
extends ImmutableValue {
    public static final NumberValue zero = new NumberValue(0.0);
    public static final NumberValue one = new NumberValue(1.0);
    public static final NumberValue invalid = new NumberValue();
    protected double value;
    protected static FunctionTable functions = new StdFunctionTable(NumberValue.getStandardFunctions());

    @Override
    public String getType() {
        return "number";
    }

    private NumberValue() {
        this.setInvalid();
    }

    public NumberValue(double d) {
        this.value = d;
    }

    @Override
    public Object getRepresentation(int n) {
        if (n == Value.RP_STRINGVALUE) {
            if (this.isInvalid()) {
                return "<<Invalid Number>>";
            }
            return this.doubleToString(this.value);
        }
        if (this.isInvalid()) {
            throw new AsmError("You cant get a representation from an invalid number value", null);
        }
        if (n == Value.RP_DOUBLEVALUE) {
            return new Double(this.value);
        }
        return null;
    }

    private String doubleToString(double d) {
        int n = (int)d;
        return d == (double)n ? Integer.toString(n) : Double.toString(d);
    }

    @Override
    public boolean hasRepresentation(int n) {
        return n == Value.RP_DOUBLEVALUE || n == Value.RP_STRINGVALUE;
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    static {
        functions.add(new DoubleFunction("-", invalid){

            @Override
            protected Value f(double d) {
                return new NumberValue(-d);
            }
        });
        functions.add(new IntFunction("<", invalid){

            @Override
            protected Value f(int n) {
                return new NumberValue(n & 0xFF);
            }
        });
        functions.add(new IntFunction(">", invalid){

            @Override
            protected Value f(int n) {
                return new NumberValue(n >> 8 & 0xFF);
            }
        });
        functions.add(new DoubleX2Function("+", invalid){

            @Override
            protected Value f(double d, double d2) {
                return new NumberValue(d + d2);
            }
        });
        functions.add(new DoubleX2Function("-", invalid){

            @Override
            protected Value f(double d, double d2) {
                return new NumberValue(d - d2);
            }
        });
        functions.add(new DoubleX2Function("*", invalid){

            @Override
            protected Value f(double d, double d2) {
                return new NumberValue(d * d2);
            }
        });
        functions.add(new DoubleX2Function("/", invalid){

            @Override
            protected Value f(double d, double d2) {
                return new NumberValue(d / d2);
            }
        });
        functions.add(new DoubleX2Function("<=", BooleanValue.invalid){

            @Override
            protected Value f(double d, double d2) {
                return BooleanValue.get(d <= d2);
            }
        });
        functions.add(new DoubleX2Function(">=", BooleanValue.invalid){

            @Override
            protected Value f(double d, double d2) {
                return BooleanValue.get(d >= d2);
            }
        });
        functions.add(new DoubleX2Function("<", BooleanValue.invalid){

            @Override
            protected Value f(double d, double d2) {
                return BooleanValue.get(d < d2);
            }
        });
        functions.add(new DoubleX2Function(">", BooleanValue.invalid){

            @Override
            protected Value f(double d, double d2) {
                return BooleanValue.get(d > d2);
            }
        });
        functions.add(new IntX2Function("&", invalid){

            @Override
            protected Value f(int n, int n2) {
                return new NumberValue(n & n2);
            }
        });
        functions.add(new IntX2Function("|", invalid){

            @Override
            protected Value f(int n, int n2) {
                return new NumberValue(n | n2);
            }
        });
        functions.add(new IntX2Function("^", invalid){

            @Override
            protected Value f(int n, int n2) {
                return new NumberValue(n ^ n2);
            }
        });
        functions.add(new IntX2Function(">>", invalid){

            @Override
            protected Value f(int n, int n2) {
                return new NumberValue(n >> n2);
            }
        });
        functions.add(new IntX2Function("<<", invalid){

            @Override
            protected Value f(int n, int n2) {
                return new NumberValue(n << n2);
            }
        });
        functions.add(new Function("==", 2, BooleanValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
                Double d = (Double)valueArray[1].getRepresentation(Value.RP_DOUBLEVALUE);
                if (d == null) {
                    return BooleanValue.falseValue;
                }
                return BooleanValue.get(valueArray[0].getRepresentation(Value.RP_DOUBLEVALUE).equals(d));
            }
        });
        functions.add(new Function("!=", 2, BooleanValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
                Double d = (Double)valueArray[1].getRepresentation(Value.RP_DOUBLEVALUE);
                if (d == null) {
                    return BooleanValue.trueValue;
                }
                return BooleanValue.get(!valueArray[0].getRepresentation(Value.RP_DOUBLEVALUE).equals(d));
            }
        });
    }
}

