/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.libraries;

import cml.kickass.constant.Constant;
import cml.kickass.function.Function;
import cml.kickass.function.IntOptIntFunction;
import cml.kickass.libraries.Library;
import cml.kickass.values.StringValue;
import cml.kickass.values.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class PrintLibrary
implements Library {
    public List<Constant> getConstants() {
        return new ArrayList<Constant>();
    }

    @Override
    public Collection<Function> getFunctions() {
        ArrayList<Function> arrayList = new ArrayList<Function>();
        arrayList.add(new IntOptIntFunction("toIntString", StringValue.invalid){

            @Override
            protected Value f(int n, Integer n2) {
                return new StringValue(PrintLibrary.padLeft(Integer.toString(n), n2, ' '));
            }
        });
        arrayList.add(new IntOptIntFunction("toHexString", StringValue.invalid){

            @Override
            protected Value f(int n, Integer n2) {
                return new StringValue(PrintLibrary.padLeft(Integer.toHexString(n), n2, '0'));
            }
        });
        arrayList.add(new IntOptIntFunction("toBinaryString", StringValue.invalid){

            @Override
            protected Value f(int n, Integer n2) {
                return new StringValue(PrintLibrary.padLeft(Integer.toBinaryString(n), n2, '0'));
            }
        });
        arrayList.add(new IntOptIntFunction("toOctalString", StringValue.invalid){

            @Override
            protected Value f(int n, Integer n2) {
                return new StringValue(PrintLibrary.padLeft(Integer.toOctalString(n), n2, '0'));
            }
        });
        return arrayList;
    }

    private static String padLeft(String string, Integer n, char c) {
        if (n == null) {
            return string;
        }
        int n2 = n - string.length();
        if (n2 <= 0) {
            return string;
        }
        char[] cArray = new char[n2];
        Arrays.fill(cArray, c);
        String string2 = new String(cArray);
        return string2 + string;
    }
}

