/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.function.table;

import cml.kickass.exceptions.AsmError;
import cml.kickass.function.Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.values.Value;
import java.util.HashMap;
import java.util.Map;

public class StdFunctionTable
extends FunctionTable {
    private static Integer anyNoOfArguments = -1;
    private Map<String, Map<Integer, Function>> functionMap = new HashMap<String, Map<Integer, Function>>();

    public StdFunctionTable() {
    }

    public StdFunctionTable(StdFunctionTable stdFunctionTable) {
        this.functionMap.putAll(stdFunctionTable.functionMap);
    }

    @Override
    public void add(Function function, boolean bl, DebugInfo debugInfo) {
        Integer n;
        String string = function.getName();
        Map<Integer, Function> map = this.functionMap.get(string);
        if (map == null) {
            map = new HashMap<Integer, Function>();
            this.functionMap.put(string, map);
        }
        Integer n2 = n = function.getNoOfArguments() == null ? anyNoOfArguments : function.getNoOfArguments();
        if (map.containsKey(n) && !bl) {
            throw new AsmError("The function '" + string + "' is already defined.", debugInfo);
        }
        map.put(n, function);
    }

    @Override
    public Function get(String string, Value[] valueArray, DebugInfo debugInfo) {
        Function function;
        Map<Integer, Function> map = this.functionMap.get(string);
        if (map == null) {
            throw new AsmError("Unknown function : " + string, debugInfo);
        }
        Function function2 = function = valueArray == null ? null : map.get(valueArray.length);
        if (function == null) {
            function = map.get(anyNoOfArguments);
        }
        if (function == null) {
            throw new AsmError("Invalid number of arguments : " + string, debugInfo);
        }
        return function;
    }

    @Override
    public boolean exist(String string, Value[] valueArray) {
        Map<Integer, Function> map = this.functionMap.get(string);
        if (map == null) {
            return false;
        }
        if (valueArray == null) {
            return true;
        }
        Function function = map.get(valueArray.length);
        return function != null;
    }
}

