/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.function;

import cml.kickass.exceptions.AsmError;
import cml.kickass.function.Function;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;

public abstract class IntOptIntFunction
extends Function {
    public IntOptIntFunction(String string, Value value) {
        super(string, null, value);
    }

    @Override
    public final Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
        if (valueArray.length < 1 || 2 < valueArray.length) {
            throw new AsmError("Invalid number of arguments. This function takes one or two arguments", debugInfo);
        }
        int n = valueArray[0].getInt(debugInfo);
        Integer n2 = null;
        if (valueArray.length > 1) {
            Value value = valueArray[1];
            if (!value.hasRepresentation(Value.RP_DOUBLEVALUE)) {
                throw new AsmError("Can't convert second value to an integer", debugInfo);
            }
            n2 = value.getInt(debugInfo);
        }
        return this.f(n, n2);
    }

    protected abstract Value f(int var1, Integer var2);
}

