/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.AssemblerToolbox;
import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.metanodes.AddDebugToCallStackNode;
import cml.kickass.asmnode.metanodes.PreSideEffectsNode;
import cml.kickass.asmnode.metanodes.SetCurrentDirectoryNode;
import cml.kickass.asmnode.output.ByteOutput;
import cml.kickass.asmnode.output.SideEffectOnlyOutput;
import cml.kickass.directives.Directive;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.NotImplementedException;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.misc.CharToPetsciiConverter;
import cml.kickass.sideeffect.SEIncreaseMemoryPosition;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.FunctionSideOutput;
import cml.kickass.values.Value;
import cml.tools.FileTool;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;

public class ImportDirective
extends AsmDirective {
    private String type;
    private List<ExprNode> argumentExprs;

    public ImportDirective(String string, List<ExprNode> list, DebugInfo debugInfo) {
        super(debugInfo);
        this.type = string;
        this.argumentExprs = list;
    }

    @Override
    public Directive copy() {
        return this;
    }

    @Override
    public AsmNode registerMetaDefinitions(EvaluationState evaluationState) {
        if (this.type.equalsIgnoreCase("source")) {
            evaluationState.clearFunctionSideOutput();
            if (this.argumentExprs.size() != 1) {
                throw new AsmError("Invalid number of arguments. Import source takes exactly one argument", this.debug);
            }
            Value value = this.argumentExprs.get(0).evaluate(evaluationState);
            if (value.isInvalid()) {
                throw new AsmError("Must be able to solve filename during first parse", this.debug);
            }
            String string = value.getString(this.debug);
            return this.importSource(evaluationState, string);
        }
        return this;
    }

    @Override
    public AsmNode preParse(EvaluationState evaluationState) {
        Object object;
        Object object2;
        evaluationState.clearFunctionSideOutput();
        if (this.argumentExprs.size() < 1 || 3 < this.argumentExprs.size()) {
            throw new AsmError("Invalid number of arguments.", this.debug);
        }
        Value value = this.argumentExprs.get(0).evaluate(evaluationState);
        if (value.isInvalid()) {
            throw new AsmError("Must be able to solve filename during first pass", this.debug);
        }
        String string = value.getString(this.debug);
        Integer n = null;
        if (this.argumentExprs.size() >= 2) {
            object2 = this.argumentExprs.get(1).evaluate(evaluationState);
            if (((Value)object2).isInvalid()) {
                throw new AsmError("Must be able to solve offset argument during first pass", this.debug);
            }
            n = ((Value)object2).getInt(this.debug);
            if (n < 0) {
                throw new AsmError("Offset can't be negative", this.debug);
            }
        }
        object2 = null;
        if (this.argumentExprs.size() >= 3) {
            object = this.argumentExprs.get(2).evaluate(evaluationState);
            if (((Value)object).isInvalid()) {
                throw new AsmError("Must be able to solve length argument during first pass", this.debug);
            }
            object2 = ((Value)object).getInt(this.debug);
            if ((Integer)object2 < 0) {
                throw new AsmError("Length can't be negative", this.debug);
            }
        }
        object = null;
        if (this.type.equalsIgnoreCase("binary")) {
            object = this.importBinary(evaluationState, string, false, n, (Integer)object2);
        } else if (this.type.equalsIgnoreCase("c64")) {
            object = this.importBinary(evaluationState, string, true, n, (Integer)object2);
        } else if (this.type.equalsIgnoreCase("text")) {
            object = this.importText(evaluationState, string, n, (Integer)object2);
        } else {
            throw new AsmError("Unknown import type '" + this.type + "'", this.debug);
        }
        return object;
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        throw NotImplementedException.intance;
    }

    private AsmNode importBinary(EvaluationState evaluationState, String string, boolean bl, Integer n, Integer n2) {
        InputStream inputStream = evaluationState.openFile(string, this.debug);
        int n3 = 0;
        int n4 = 65536;
        byte[] byArray = new byte[n4];
        try {
            if (bl) {
                inputStream.read(byArray, 0, 2);
            }
            if (n != null) {
                inputStream.read(byArray, 0, n);
            }
            if (n2 != null) {
                n4 = n2;
            }
            n3 = inputStream.read(byArray, 0, n4);
        }
        catch (Exception exception) {
            throw new AsmError("Can't read file: " + string, this.debug);
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n2 != null && n3 < n2) {
            throw new AsmError("File is too short for the desired length", this.debug);
        }
        byte[] byArray2 = new byte[n3];
        for (int i = 0; i < n3; ++i) {
            byArray2[i] = byArray[i];
        }
        evaluationState.addSideEffect(new SEIncreaseMemoryPosition(byArray2.length));
        return new ByteOutput(byArray2, evaluationState.getFunctionSideOutput());
    }

    private AsmNode importSource(EvaluationState evaluationState, String string) {
        FunctionSideOutput functionSideOutput = evaluationState.getFunctionSideOutput();
        File file = evaluationState.getFile(string, this.debug);
        if (evaluationState.isFileExcludedForImport(FileTool.getCanonicalFilePath(file))) {
            return new SideEffectOnlyOutput(functionSideOutput);
        }
        AsmNode asmNode = AssemblerToolbox.loadAndLex(file, evaluationState, this.debug);
        asmNode = new AddDebugToCallStackNode(this.debug, asmNode);
        File file2 = file.getParentFile();
        asmNode = new SetCurrentDirectoryNode(file2, asmNode);
        AsmNode asmNode2 = asmNode.registerMetaDefinitions(evaluationState);
        return functionSideOutput == null ? asmNode2 : new PreSideEffectsNode(functionSideOutput, asmNode2);
    }

    private AsmNode importText(EvaluationState evaluationState, String string, Integer n, Integer n2) {
        InputStream inputStream = evaluationState.openFile(string, this.debug);
        byte[] byArray = new byte[]{};
        try {
            int n3;
            int n4;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            int n5 = 65536;
            char[] cArray = new char[n5];
            if (n != null) {
                inputStreamReader.read(cArray, 0, n);
            }
            if (n2 != null) {
                n5 = n2;
            }
            if ((n4 = inputStreamReader.read(cArray, 0, n5)) < 0) {
                n4 = 0;
            }
            int n6 = 0;
            for (n3 = 0; n3 < n4; ++n3) {
                if (CharToPetsciiConverter.convert(cArray[n3]) == null) continue;
                ++n6;
            }
            if (n2 != null && n6 < n2) {
                throw new AsmError("File is too short for the desired length", this.debug);
            }
            byArray = new byte[n6];
            n3 = 0;
            for (int i = 0; i < n4; ++i) {
                Byte by = CharToPetsciiConverter.convert(cArray[i]);
                if (by == null) continue;
                byArray[n3++] = by;
            }
        }
        catch (Exception exception) {
            throw new AsmError("Can't read file: " + string, this.debug);
        }
        evaluationState.addSideEffect(new SEIncreaseMemoryPosition(byArray.length));
        return new ByteOutput(byArray, evaluationState.getFunctionSideOutput());
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.addNode("Import", this.debug, this.type, this.argumentExprs);
        return nodeTreeBuilder;
    }
}

