/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass;

import cml.kickass.AssemblerToolbox;
import cml.kickass.KickAssemblerParameters;
import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.metanodes.AsmNodeList;
import cml.kickass.asmnode.output.reciever.MainOutputReciever;
import cml.kickass.constant.Constant;
import cml.kickass.exceptions.AsmError;
import cml.kickass.function.Function;
import cml.kickass.libraries.Library;
import cml.kickass.libraries.MathLibrary;
import cml.kickass.libraries.MiscLibrary;
import cml.kickass.libraries.MnemonicsLibrary;
import cml.kickass.libraries.PrintLibrary;
import cml.kickass.libraries.StdConstructorLibrary;
import cml.kickass.libraries.VectorLibrary;
import cml.kickass.misc.C64File;
import cml.kickass.misc.MemoryBlock;
import cml.kickass.misc.SymbolFile;
import cml.kickass.misc.ViceSymbolFile;
import cml.kickass.state.AssertManager;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.SymbolScope;
import cml.kickass.values.ConstantReferenceValue;
import cml.kickass.values.HashtableValue;
import cml.log.Log;
import cml.tools.Timer;
import cml.tools.tuples.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class KickAssembler {
    private static final String AUTO_INCLUDED_FILE = "/include/autoinclude.asm";
    private static final String CONFIG_FILE = "/KickAss.cfg";
    private static final String PLUGIN_FILE = "/KickAss.plugin";
    private static Log log = new Log("");

    public static void main(String[] stringArray) {
        log.println("//------------------------------------------------------");
        log.println("//------------------------------------------------------");
        log.println("//      Kick Assembler v3.39 - (C)2015 Mads Nielsen     ");
        log.println("//------------------------------------------------------");
        log.println("//------------------------------------------------------");
        File file = new File(".");
        KickAssemblerParameters kickAssemblerParameters = new KickAssemblerParameters();
        kickAssemblerParameters.libPath.add(file);
        OutputStreamWriter outputStreamWriter = null;
        EvaluationState evaluationState = new EvaluationState();
        ArrayList<Library> arrayList = new ArrayList<Library>();
        arrayList.add(new MathLibrary());
        arrayList.add(new PrintLibrary());
        arrayList.add(new VectorLibrary());
        arrayList.add(new StdConstructorLibrary());
        arrayList.add(new MiscLibrary());
        arrayList.add(new MnemonicsLibrary());
        try {
            Object exception;
            Object object;
            AssertManager assertManager;
            KickAssembler.parsePluginFile(evaluationState);
            File file2 = KickAssembler.openConfigFile(CONFIG_FILE);
            String[] stringArray2 = KickAssembler.getExtraArgs(file2);
            KickAssembler.parseArgs(stringArray2, kickAssemblerParameters);
            KickAssembler.parseArgs(stringArray, kickAssemblerParameters);
            if (kickAssemblerParameters.inputFileName == null) {
                log.println("Error: No inputfile supplied.");
                return;
            }
            if (!new File(kickAssemblerParameters.inputFileName).exists()) {
                log.println("Error: Inputfile '" + kickAssemblerParameters.inputFileName + "' doesn't exist.");
                return;
            }
            File file3 = evaluationState.getFile(kickAssemblerParameters.inputFileName, null);
            File file4 = file3.getCanonicalFile().getParentFile();
            evaluationState.setCurrentDirectory(file4);
            String[] stringArray3 = kickAssemblerParameters.extraCfgFilenames.toArray(new String[0]);
            for (String string : stringArray3) {
                File file5 = KickAssembler.getUserSpecifiedConfigFile(string, file4);
                if (file5 == null) {
                    log.println("Warning. Can't find configfile : " + string);
                    continue;
                }
                String[] stringArray4 = KickAssembler.getExtraArgs(file5);
                KickAssembler.parseArgs(stringArray4, kickAssemblerParameters);
            }
            if (kickAssemblerParameters.displayLibraries) {
                KickAssembler.displayLibraries(arrayList);
                return;
            }
            Log.setDebugging(kickAssemblerParameters.debug);
            Log.setWarnings(kickAssemblerParameters.warnings);
            C64File.allowOverlappingMemoryBlocks(kickAssemblerParameters.allowOverlappingMemoryblocks);
            evaluationState.setSourceLibraryPath(kickAssemblerParameters.libPath);
            evaluationState.setDtvMode(kickAssemblerParameters.dtvMode);
            evaluationState.setMaxMemoryAddress(kickAssemblerParameters.maxMemoryAddress);
            HashtableValue hashtableValue = new HashtableValue().addStringValues(kickAssemblerParameters.cmdLineArguments);
            hashtableValue.lock(null);
            evaluationState.getSystemScope().getSymbols().putErrorIfExist("cmdLineVars", new ConstantReferenceValue(hashtableValue), "ERROR!", null);
            for (Library library : arrayList) {
                evaluationState.addLibrary(library);
            }
            Object object5 = kickAssemblerParameters.inputFileName;
            int n = ((String)object5).lastIndexOf(46);
            if (n >= 0) {
                object5 = ((String)object5).substring(0, n);
            }
            if (kickAssemblerParameters.outputfile == null) {
                String string;
                string = kickAssemblerParameters.binFile ? ".bin" : ".prg";
                kickAssemblerParameters.outputfile = (String)object5 + string;
            }
            if (kickAssemblerParameters.displayParseTree) {
                outputStreamWriter = new FileWriter("parsetree_.txt");
            }
            long l = System.nanoTime();
            boolean bl = true;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("User Arguments: ");
            for (Map.Entry<String, String> object42 : kickAssemblerParameters.cmdLineArguments.entrySet()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(object42.getKey() + "=" + object42.getValue());
            }
            if (!bl) {
                log.println(stringBuffer.toString());
            }
            log.println("parsing");
            AsmNodeList asmNodeList = new AsmNodeList();
            InputStream inputStream = new KickAssembler().getClass().getResourceAsStream(AUTO_INCLUDED_FILE);
            asmNodeList.add(AssemblerToolbox.loadAndLex(inputStream, AUTO_INCLUDED_FILE, evaluationState, null));
            asmNodeList.add(AssemblerToolbox.loadAndLex(kickAssemblerParameters.inputFileName, evaluationState, null));
            AsmNodeList asmNodeList2 = asmNodeList;
            if (kickAssemblerParameters.displayParseTree) {
                outputStreamWriter.append("*****  Init tree *****\n");
                outputStreamWriter.append(((AsmNode)asmNodeList2).toNodeTreeString(new NodeTreeBuilder()).toString());
                outputStreamWriter.append("\n");
            }
            do {
                evaluationState.prepareNewParse();
                log.println("flex pass " + evaluationState.getPassNo());
                if (evaluationState.getPassNo() == 1) {
                    ((AsmNode)asmNodeList2).registerMetaDefinitions(evaluationState);
                    ((AsmNode)asmNodeList2).preParse(evaluationState);
                    if (kickAssemblerParameters.displayParseTree) {
                        outputStreamWriter.append("\n*****  Parsetree after preparse *****\n");
                        outputStreamWriter.append(((AsmNode)asmNodeList2).toNodeTreeString(new NodeTreeBuilder()).toString());
                        outputStreamWriter.append("\n");
                    }
                }
                asmNodeList2 = ((AsmNode)asmNodeList2).parse(evaluationState);
                if (kickAssemblerParameters.displayParseTree) {
                    outputStreamWriter.append("\n*****  Parsetree after parse " + evaluationState.getPassNo() + " *****\n");
                    outputStreamWriter.append(((AsmNode)asmNodeList2).toNodeTreeString(new NodeTreeBuilder()).toString());
                    outputStreamWriter.append("\n");
                }
                if (evaluationState.getMadeMetaProgress() || ((AsmNode)asmNodeList2).isFinished()) continue;
                evaluationState.prepareNewParse();
                evaluationState.setFailOnInvalidValue(true);
                asmNodeList2 = ((AsmNode)asmNodeList2).parse(evaluationState);
                throw new AsmError("Made no progress and cant solve the program.. You should have gotten an error. Contact the author!", null);
            } while (!((AsmNode)asmNodeList2).isFinished());
            log.println("Output pass");
            MainOutputReciever mainOutputReciever = new MainOutputReciever(8192, kickAssemblerParameters.allowFileOutput, evaluationState.getMaxMemoryAddress());
            ((AsmNode)asmNodeList2).deliverOutput(mainOutputReciever);
            mainOutputReciever.finish();
            long l2 = System.nanoTime() - l;
            if (kickAssemblerParameters.time) {
                log.println("Assemble time = " + l2 / 1000000L + " ms");
            }
            Timer.printTimers();
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                    outputStreamWriter = null;
                }
                catch (Exception assertManager2) {
                    // empty catch block
                }
            }
            if (kickAssemblerParameters.showMemoryMap) {
                log.println();
                log.println(AssemblerToolbox.printMemoryBlocks(mainOutputReciever.getMemoryBlocks()));
            }
            if ((assertManager = evaluationState.getAssertManager()).getNoOfAsserts() > 0) {
                log.println();
                object = assertManager.getNoOfFailedAsserts() == 0 ? " failed" : " FAILED!";
                log.println("Made " + assertManager.getNoOfAsserts() + " asserts , " + assertManager.getNoOfFailedAsserts() + (String)object);
            }
            if (!kickAssemblerParameters.filesForEachMemBlock) {
                KickAssembler.writeC64File(kickAssemblerParameters.outputfile, mainOutputReciever.getMemoryBlocks(), kickAssemblerParameters.fillByte, kickAssemblerParameters.binFile);
            } else {
                object = new HashMap();
                for (MemoryBlock memoryBlock : mainOutputReciever.getMemoryBlocks()) {
                    if (memoryBlock.isVirtual()) continue;
                    ArrayList<MemoryBlock> arrayList2 = (ArrayList<MemoryBlock>)object.get(memoryBlock.getName());
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<MemoryBlock>();
                        object.put(memoryBlock.getName(), arrayList2);
                    }
                    arrayList2.add(memoryBlock);
                }
                exception = new String[]{".bin", ".prg"};
                Pair<String, String> pair = KickAssembler.findFilenameBaseAndPostfix(kickAssemblerParameters.outputfile, exception);
                for (String string : object.keySet()) {
                    String string2 = pair.getA() + "_" + string + pair.getB();
                    List list = (List)object.get(string);
                    if (list.size() != 1) {
                        log.warn("" + list.size() + " blocks have the name '" + string + "'. They will be merged in the same file.");
                    }
                    KickAssembler.writeC64File(string2, list, kickAssemblerParameters.fillByte, kickAssemblerParameters.binFile);
                }
            }
            if (kickAssemblerParameters.viceSymbols) {
                object = new File((String)object5).getName() + ".vs";
                exception = new File(kickAssemblerParameters.outputfile).getParent();
                String string = (exception == null ? "" : (String)exception + File.separator) + (String)object;
                log.println("Writing Vice symbol file: " + string);
                new ViceSymbolFile(evaluationState.getCurrentScope()).writeFile(string);
            }
            if (kickAssemblerParameters.symbolFile) {
                if (kickAssemblerParameters.symbolFileOutputDir == null) {
                    object = (String)object5 + ".sym";
                } else {
                    exception = new File((String)object5).getName() + ".sym";
                    object = kickAssemblerParameters.symbolFileOutputDir + File.separator + (String)exception;
                }
                log.println("Writing Symbol file: " + (String)object);
                new SymbolFile(evaluationState.getCurrentScope()).writeFile((String)object);
            }
            if (kickAssemblerParameters.executeOnSuccess != null) {
                object = kickAssemblerParameters.executeOnSuccess + " " + kickAssemblerParameters.outputfile;
                try {
                    Runtime.getRuntime().exec((String)object);
                }
                catch (Exception exception2) {
                    log.error("Error while executing external program: " + exception2);
                }
            }
        }
        catch (Exception exception) {
            if (exception instanceof AsmError) {
                ((AsmError)exception).setCallStack(evaluationState.getCallStack());
            }
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            log.error(exception);
            System.exit(1);
        }
    }

    static void parseCommandLineVar(String string, Map<String, String> map) {
        int n = string.indexOf(61);
        if (n < 0) {
            throw new AsmError("Can't parse user command line argument. Missing '='. " + string, null);
        }
        String string2 = string.substring(1, n);
        String string3 = string.substring(n + 1);
        if (string2.length() == 0) {
            throw new AsmError("Can't parse user command line argument. Invalid argument name. " + string, null);
        }
        if (string3.length() != 0 && string3.charAt(0) == '\"') {
            if (string3.charAt(string3.length() - 1) == '\"') {
                throw new AsmError("Unterminated '\"' in command line argument. " + string, null);
            }
            string3 = string3.substring(1, string3.length() - 2);
        }
        map.put(string2, string3);
    }

    private static void ensureArgument(int n, String[] stringArray, String string) {
        if (n >= stringArray.length) {
            log.println("Missing parameter for '" + string + "' option");
            System.exit(1);
        }
    }

    private static File openConfigFile(String string) {
        File file = null;
        try {
            File file2 = new File(KickAssembler.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (!file2.isDirectory()) {
                file2 = file2.getParentFile();
            } else {
                boolean bl = KickAssembler.javaFileExist(file2, KickAssembler.class.getCanonicalName());
                if (bl) {
                    file2 = file2.getParentFile();
                }
            }
            file = new File(file2, string);
            if (!file.exists()) {
                return null;
            }
            return file;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String[] getExtraArgs(File file) {
        String[] stringArray;
        if (file == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string;
            stringArray = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while ((string = stringArray.readLine()) != null) {
                KickAssembler.parseConfigLine(string, arrayList);
            }
        }
        catch (IOException iOException) {
            System.out.println("Error while reading config file (" + file.getName() + "): " + iOException.getMessage());
            System.exit(1);
        }
        stringArray = new String[arrayList.size()];
        int n = 0;
        for (String string : arrayList) {
            stringArray[n++] = string;
        }
        return stringArray;
    }

    private static boolean javaFileExist(File file, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        File file2 = file;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                string2 = string2 + ".class";
            }
            if ((file2 = new File(file2, string2)).exists()) continue;
            return false;
        }
        return true;
    }

    private static void parseConfigLine(String string, List<String> list) {
        int n = string.indexOf(34);
        String string2 = n < 0 ? string : string.substring(0, n);
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            list.add(stringTokenizer.nextToken());
        }
        int n2 = string.indexOf(34, n + 1);
        if (n2 < 0) {
            n2 = string.length();
        }
        if (n >= 0) {
            list.add(string.substring(n + 1, n2));
        }
        if (n2 + 1 < string.length()) {
            KickAssembler.parseConfigLine(string.substring(n2 + 1), list);
        }
    }

    private static void parsePluginFile(EvaluationState evaluationState) {
        File file = KickAssembler.openConfigFile(PLUGIN_FILE);
        if (file == null) {
            return;
        }
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("//")) continue;
                Object object = KickAssembler.createObjectOrNull(string);
                if (object == null) {
                    log.println("Error while parsing /KickAss.cfg. Coundn't find class or create object for pluging: " + string);
                    continue;
                }
                evaluationState.addPlugin(object);
            }
        }
        catch (IOException iOException) {
            System.out.println("Error while reading config file (/KickAss.cfg): " + iOException.getMessage());
            System.exit(1);
        }
    }

    private static Object createObjectOrNull(String string) {
        try {
            return Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void displayLibraries(List<Library> list) {
        log.println("DEFAULT CONSTANTS:");
        for (Library library : list) {
            for (Constant object : library.getConstants()) {
                log.println(object.getName());
            }
        }
        log.println();
        log.println("DEFAULT FUNCTIONS:");
        for (Library library : list) {
            for (Function function : library.getFunctions()) {
                log.println(function.getName());
            }
        }
    }

    private static void writeC64File(String string, List<MemoryBlock> list, byte by, boolean bl) {
        C64File c64File = new C64File(list, by);
        log.println("Writing file: " + string);
        c64File.writeFile(string, bl);
    }

    private static void collectSymbols(SymbolScope symbolScope, List<String> list) {
        for (String string : symbolScope.getLocalDefinedEntities().keySet()) {
            list.add(string);
        }
        if (symbolScope.getParrent() != null) {
            KickAssembler.collectSymbols(symbolScope.getParrent(), list);
        }
    }

    private static Pair<String, String> findFilenameBaseAndPostfix(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            if (!string.endsWith(string2)) continue;
            String string3 = string.substring(0, string.length() - string2.length());
            return new Pair<String, String>(string3, string2);
        }
        return new Pair<String, String>(string, "");
    }

    public static File getUserSpecifiedConfigFile(String string, File file) {
        File file2 = new File(file, string);
        if (file2.exists()) {
            return file2;
        }
        file2 = new File(string);
        if (file2.exists()) {
            return file2;
        }
        return null;
    }

    private static void parseArgs(String[] stringArray, KickAssemblerParameters kickAssemblerParameters) {
        int n = 0;
        while (n < stringArray.length) {
            String string;
            if ((string = stringArray[n++]).equalsIgnoreCase("-cfgfile")) {
                KickAssembler.ensureArgument(n, stringArray, "-configfile");
                kickAssemblerParameters.extraCfgFilenames.add(stringArray[n++]);
                continue;
            }
            if (string.equalsIgnoreCase("-o")) {
                KickAssembler.ensureArgument(n, stringArray, "-o");
                kickAssemblerParameters.outputfile = stringArray[n++];
                continue;
            }
            if (string.equalsIgnoreCase("-libdir")) {
                KickAssembler.ensureArgument(n, stringArray, "-libdir");
                kickAssemblerParameters.libPath.add(new File(stringArray[n++]));
                continue;
            }
            if (string.equalsIgnoreCase("-execute")) {
                KickAssembler.ensureArgument(n, stringArray, "-execute");
                kickAssemblerParameters.executeOnSuccess = stringArray[n++];
                continue;
            }
            if (string.equalsIgnoreCase("-showmem")) {
                kickAssemblerParameters.showMemoryMap = true;
                continue;
            }
            if (string.equalsIgnoreCase("-debug")) {
                kickAssemblerParameters.debug = true;
                continue;
            }
            if (string.equalsIgnoreCase("-binfile")) {
                kickAssemblerParameters.binFile = true;
                continue;
            }
            if (string.equalsIgnoreCase("-dtv")) {
                kickAssemblerParameters.dtvMode = true;
                continue;
            }
            if (string.equalsIgnoreCase("-mbfiles")) {
                kickAssemblerParameters.filesForEachMemBlock = true;
                continue;
            }
            if (string.equalsIgnoreCase("-time")) {
                kickAssemblerParameters.time = true;
                continue;
            }
            if (string.equalsIgnoreCase("-warningsoff")) {
                kickAssemblerParameters.warnings = false;
                continue;
            }
            if (string.equalsIgnoreCase("-fillbyte")) {
                KickAssembler.ensureArgument(n, stringArray, "-fillbyte");
                try {
                    kickAssemblerParameters.fillByte = (byte)Integer.valueOf(stringArray[n++]).intValue();
                }
                catch (Exception exception) {
                    log.println("Invalid arg for -fillbyte: " + stringArray[n - 1]);
                }
                continue;
            }
            if (string.equalsIgnoreCase("-maxaddr")) {
                KickAssembler.ensureArgument(n, stringArray, "-maxaddr");
                try {
                    kickAssemblerParameters.maxMemoryAddress = Integer.valueOf(stringArray[n++]);
                }
                catch (Exception exception) {
                    log.println("Invalid arg for -maxaddr: " + stringArray[n - 1]);
                }
                continue;
            }
            if (string.equalsIgnoreCase("-aom")) {
                kickAssemblerParameters.allowOverlappingMemoryblocks = true;
                continue;
            }
            if (string.equalsIgnoreCase("-vicesymbols")) {
                kickAssemblerParameters.viceSymbols = true;
                continue;
            }
            if (string.equalsIgnoreCase("-symbolfile")) {
                kickAssemblerParameters.symbolFile = true;
                continue;
            }
            if (string.equalsIgnoreCase("-symbolfiledir")) {
                KickAssembler.ensureArgument(n, stringArray, "-symbolfiledir");
                kickAssemblerParameters.symbolFileOutputDir = stringArray[n++];
                continue;
            }
            if (string.equalsIgnoreCase("-afo")) {
                kickAssemblerParameters.allowFileOutput = true;
                continue;
            }
            if (string.equalsIgnoreCase("-parsetree")) {
                kickAssemblerParameters.displayParseTree = true;
                continue;
            }
            if (string.equalsIgnoreCase("-displaylibraries")) {
                kickAssemblerParameters.displayLibraries = true;
                continue;
            }
            if (string.equalsIgnoreCase("-log")) {
                KickAssembler.ensureArgument(n, stringArray, "-log");
                try {
                    log.addPrintStream(new PrintStream(new FileOutputStream(stringArray[n++])));
                }
                catch (Exception exception) {
                    log.println("Couldn't create log : " + exception.getMessage());
                }
                continue;
            }
            if (string.charAt(0) == ':') {
                KickAssembler.parseCommandLineVar(string, kickAssemblerParameters.cmdLineArguments);
                continue;
            }
            if (kickAssemblerParameters.inputFileName == null) {
                kickAssemblerParameters.inputFileName = string;
                continue;
            }
            log.println("Warning. Already have an inputfile. Won't use '" + string + "'");
        }
    }

    static {
        log.addPrintStream(System.out);
    }
}

