/*
 * Decompiled with CFR 0.152.
 */
package sidplay.ini;

import sidplay.ini.IniReader;
import sidplay.ini.IniSection;

public class IniSidplay2Section
extends IniSection {
    protected IniSidplay2Section(IniReader ini) {
        super(ini);
    }

    public final int getVersion() {
        return this.iniReader.getPropertyInt("SIDPlay2", "Version", 18);
    }

    public final boolean isEnableDatabase() {
        return this.iniReader.getPropertyBool("SIDPlay2", "EnableDatabase", true);
    }

    public final void setEnableDatabase(boolean enable) {
        this.iniReader.setProperty("SIDPlay2", "EnableDatabase", enable);
    }

    public final int getPlayLength() {
        return this.iniReader.getPropertyTime("SIDPlay2", "Default Play Length", 210);
    }

    public final void setPlayLength(int playLength) {
        this.iniReader.setProperty("SIDPlay2", "Default Play Length", String.format("%02d:%02d", playLength / 60, playLength % 60));
    }

    public final int getRecordLength() {
        return this.iniReader.getPropertyTime("SIDPlay2", "Default Record Length", 210);
    }

    public final String getHVMEC() {
        return this.iniReader.getPropertyString("SIDPlay2", "HVMEC Dir", null);
    }

    public final void setHVMEC(String hvmec) {
        this.iniReader.setProperty("SIDPlay2", "HVMEC Dir", hvmec);
    }

    public final String getDemos() {
        return this.iniReader.getPropertyString("SIDPlay2", "DEMOS Dir", null);
    }

    public final void setDemos(String demos) {
        this.iniReader.setProperty("SIDPlay2", "DEMOS Dir", demos);
    }

    public final String getMags() {
        return this.iniReader.getPropertyString("SIDPlay2", "MAGS Dir", null);
    }

    public final void setMags(String mags) {
        this.iniReader.setProperty("SIDPlay2", "MAGS Dir", mags);
    }

    public final String getCgsc() {
        return this.iniReader.getPropertyString("SIDPlay2", "CGSC Dir", null);
    }

    public final void setCgsc(String cgsc) {
        this.iniReader.setProperty("SIDPlay2", "CGSC Dir", cgsc);
    }

    public final String getHvsc() {
        return this.iniReader.getPropertyString("SIDPlay2", "HVSC Dir", null);
    }

    public final void setHvsc(String hvsc) {
        this.iniReader.setProperty("SIDPlay2", "HVSC Dir", hvsc);
    }

    public final boolean isSingle() {
        return this.iniReader.getPropertyBool("SIDPlay2", "SingleTrack", false);
    }

    public final void setSingle(boolean singleSong) {
        this.iniReader.setProperty("SIDPlay2", "SingleTrack", singleSong);
    }

    public final String getSoasc6581R2() {
        return this.iniReader.getPropertyString("SIDPlay2", "SOASC_6581R2", null);
    }

    public final void setSoasc6581R2(String soasc6581R2) {
        this.iniReader.setProperty("SIDPlay2", "SOASC_6581R2", soasc6581R2);
    }

    public final String getSoasc6581R4() {
        return this.iniReader.getPropertyString("SIDPlay2", "SOASC_6581R4", null);
    }

    public final void setSoasc6581R4(String soasc6581R4) {
        this.iniReader.setProperty("SIDPlay2", "SOASC_6581R2", soasc6581R4);
    }

    public final String getSoasc8580R5() {
        return this.iniReader.getPropertyString("SIDPlay2", "SOASC_8580R5", null);
    }

    public final void setSoasc8580R5(String soasc8580R5) {
        this.iniReader.setProperty("SIDPlay2", "SOASC_8580R5", soasc8580R5);
    }

    public final boolean isEnableProxy() {
        return this.iniReader.getPropertyBool("SIDPlay2", "EnableProxy", false);
    }

    public final void setEnableProxy(boolean enable) {
        this.iniReader.setProperty("SIDPlay2", "EnableProxy", enable);
    }

    public final String getProxyHostname() {
        return this.iniReader.getPropertyString("SIDPlay2", "ProxyHostname", null);
    }

    public final void setProxyHostname(String hostname) {
        this.iniReader.setProperty("SIDPlay2", "ProxyHostname", hostname);
    }

    public final int getProxyPort() {
        return this.iniReader.getPropertyInt("SIDPlay2", "ProxyPort", 80);
    }

    public final void setProxyPort(int port) {
        this.iniReader.setProperty("SIDPlay2", "ProxyPort", port);
    }

    public final String getLastDirectory() {
        return this.iniReader.getPropertyString("SIDPlay2", "Last Directory", null);
    }

    public final void setLastDirectory(String lastDir) {
        this.iniReader.setProperty("SIDPlay2", "Last Directory", lastDir);
    }

    public final String getTmpDir() {
        return this.iniReader.getPropertyString("SIDPlay2", "Temp Dir", System.getProperty("user.home") + System.getProperty("file.separator") + ".jsidplay2");
    }

    public final void setTmpDir(String path) {
        this.iniReader.setProperty("SIDPlay2", "Temp Dir", path);
    }

    public final int getFrameX() {
        return this.iniReader.getPropertyInt("SIDPlay2", "Frame X", -1);
    }

    public final void setFrameX(int x) {
        this.iniReader.setProperty("SIDPlay2", "Frame X", x);
    }

    public final int getFrameY() {
        return this.iniReader.getPropertyInt("SIDPlay2", "Frame Y", -1);
    }

    public final void setFrameY(int y) {
        this.iniReader.setProperty("SIDPlay2", "Frame Y", y);
    }

    public final int getFrameWidth() {
        return this.iniReader.getPropertyInt("SIDPlay2", "Frame Width", -1);
    }

    public final void setFrameWidth(int width) {
        this.iniReader.setProperty("SIDPlay2", "Frame Width", width);
    }

    public final int getFrameHeight() {
        return this.iniReader.getPropertyInt("SIDPlay2", "Frame Height", -1);
    }

    public final void setFrameHeight(int height) {
        this.iniReader.setProperty("SIDPlay2", "Frame Height", height);
    }
}

