/*
 * Decompiled with CFR 0.152.
 */
package sidplay.ini;

import libsidplay.common.ISID2Types;
import resid_builder.resid.ISIDDefs;
import sidplay.ini.IniReader;
import sidplay.ini.IniSection;

public class IniEmulationSection
extends IniSection {
    protected IniEmulationSection(IniReader iniReader) {
        super(iniReader);
    }

    public final ISID2Types.Clock getDefaultClockSpeed() {
        return this.iniReader.getPropertyEnum("Emulation", "DefaultClockSpeed", ISID2Types.Clock.PAL);
    }

    public final void setDefaultClockSpeed(ISID2Types.Clock speed) {
        this.iniReader.setProperty("Emulation", "DefaultClockSpeed", (Object)speed);
    }

    public final ISID2Types.Clock getUserClockSpeed() {
        return this.iniReader.getPropertyEnum("Emulation", "UserClockSpeed", null, ISID2Types.Clock.class);
    }

    public final void setUserClockSpeed(ISID2Types.Clock speed) {
        this.iniReader.setProperty("Emulation", "UserClockSpeed", (Object)speed);
    }

    public final ISIDDefs.ChipModel getDefaultSidModel() {
        return this.iniReader.getPropertyEnum("Emulation", "DefaultSidModel", ISIDDefs.ChipModel.MOS6581);
    }

    public final void setDefaultSidModel(ISIDDefs.ChipModel model) {
        this.iniReader.setProperty("Emulation", "DefaultSidModel", (Object)model);
    }

    public final ISIDDefs.ChipModel getUserSidModel() {
        return this.iniReader.getPropertyEnum("Emulation", "UserSidModel", null, ISIDDefs.ChipModel.class);
    }

    public final void setUserSidModel(ISIDDefs.ChipModel model) {
        this.iniReader.setProperty("Emulation", "UserSidModel", (Object)model);
    }

    public final int getHardsid6581() {
        return this.iniReader.getPropertyInt("Emulation", "HardSID6581", -1);
    }

    public final void setHardsid6581(int chip) {
        this.iniReader.setProperty("Emulation", "HardSID6581", chip);
    }

    public final int getHardsid8580() {
        return this.iniReader.getPropertyInt("Emulation", "HardSID8580", -1);
    }

    public final void setHardsid8580(int chip) {
        this.iniReader.setProperty("Emulation", "HardSID8580", chip);
    }

    public final boolean isFilter() {
        return this.iniReader.getPropertyBool("Emulation", "UseFilter", true);
    }

    public final void setFilter(boolean enable) {
        this.iniReader.setProperty("Emulation", "UseFilter", enable);
    }

    public final String getFilter6581() {
        return this.iniReader.getPropertyString("Emulation", "Filter6581", null);
    }

    public final void setFilter6581(String filterName) {
        this.iniReader.setProperty("Emulation", "Filter6581", filterName);
    }

    public final String getFilter8580() {
        return this.iniReader.getPropertyString("Emulation", "Filter8580", null);
    }

    public final void setFilter8580(String filterName) {
        this.iniReader.setProperty("Emulation", "Filter8580", filterName);
    }

    public final boolean isDigiBoosted8580() {
        return this.iniReader.getPropertyBool("Emulation", "DigiBoosted8580", false);
    }

    public final void setDigiBoosted8580(boolean boost) {
        this.iniReader.setProperty("Emulation", "DigiBoosted8580", boost);
    }

    public final int getDualSidBase() {
        return this.iniReader.getPropertyInt("Emulation", "dualSidBase", 54304);
    }

    public final void setDualSidBase(int base) {
        this.iniReader.setProperty("Emulation", "dualSidBase", String.format("0x%04x", base));
    }

    public final boolean isForceStereoTune() {
        return this.iniReader.getPropertyBool("Emulation", "forceStereoTune", false);
    }

    public final void setForceStereoTune(boolean force) {
        this.iniReader.setProperty("Emulation", "forceStereoTune", force);
    }

    public final ISIDDefs.ChipModel getStereoSidModel() {
        if (this.iniReader.getPropertyString("Emulation", "StereoSidModel", null) == null) {
            return null;
        }
        return this.iniReader.getPropertyEnum("Emulation", "StereoSidModel", ISIDDefs.ChipModel.MOS6581);
    }

    public final void setStereoSidModel(ISIDDefs.ChipModel model) {
        this.iniReader.setProperty("Emulation", "StereoSidModel", (Object)model);
    }
}

