/*
 * Decompiled with CFR 0.152.
 */
package sidplay.ini;

import sidplay.ini.IniReader;
import sidplay.ini.IniSection;

public class IniConsoleSection
extends IniSection {
    protected IniConsoleSection(IniReader iniReader) {
        super(iniReader);
    }

    private static char getChar(String str, char defaultChar) {
        char c = '\u0000';
        if (str.length() == 0) {
            return defaultChar;
        }
        if (str.charAt(0) == '\'') {
            if (str.charAt(2) != '\'') {
                throw new RuntimeException("Invalid character notation: " + str);
            }
            c = str.charAt(1);
        } else {
            c = (char)Integer.parseInt(str);
        }
        if (c >= ' ') {
            return c;
        }
        return defaultChar;
    }

    public final char getTopLeft() {
        return IniConsoleSection.getChar(this.iniReader.getPropertyString("Console", "Char Top Left", "'+'"), '+');
    }

    public final char getTopRight() {
        return IniConsoleSection.getChar(this.iniReader.getPropertyString("Console", "Char Top Right", "'+'"), '+');
    }

    public final char getBottomLeft() {
        return IniConsoleSection.getChar(this.iniReader.getPropertyString("Console", "Char Bottom Left", "'+'"), '+');
    }

    public final char getBottomRight() {
        return IniConsoleSection.getChar(this.iniReader.getPropertyString("Console", "Char Bottom Right", "'+'"), '+');
    }

    public final char getVertical() {
        return IniConsoleSection.getChar(this.iniReader.getPropertyString("Console", "Char Vertical", "'|'"), '|');
    }

    public final char getHorizontal() {
        return IniConsoleSection.getChar(this.iniReader.getPropertyString("Console", "Char Vertical", "'-'"), '-');
    }

    public final char getJunctionLeft() {
        return IniConsoleSection.getChar(this.iniReader.getPropertyString("Console", "Char Junction Left", "'-'"), '-');
    }

    public final char getJunctionRight() {
        return IniConsoleSection.getChar(this.iniReader.getPropertyString("Console", "Char Junction Right", "'-'"), '-');
    }
}

