/*
 * Decompiled with CFR 0.152.
 */
package sidplay.ini;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import libsidutils.zip.ZipEntryFileProxy;
import resid_builder.resid.ISIDDefs;
import sidplay.ini.IniAudioSection;
import sidplay.ini.IniC1541Section;
import sidplay.ini.IniConsoleSection;
import sidplay.ini.IniEmulationSection;
import sidplay.ini.IniFavoritesSection;
import sidplay.ini.IniFilterSection;
import sidplay.ini.IniJoystickSection;
import sidplay.ini.IniPrinterSection;
import sidplay.ini.IniReader;
import sidplay.ini.IniSidplay2Section;

public class IniConfig {
    protected static final int REQUIRED_CONFIG_VERSION = 18;
    private static final String FILE_NAME = "sidplay2.ini";
    private final File iniPath = this.getINIPath();
    private IniSidplay2Section sidplay2Section;
    private IniC1541Section c1541Section;
    private IniPrinterSection printerSection;
    private IniJoystickSection joystickSection;
    private IniConsoleSection consoleSection;
    private IniAudioSection audioSection;
    private IniEmulationSection emulationSection;
    private IniFavoritesSection favoritesSection;
    protected IniReader iniReader;

    private void clear() {
        this.sidplay2Section = new IniSidplay2Section(this.iniReader);
        this.c1541Section = new IniC1541Section(this.iniReader);
        this.printerSection = new IniPrinterSection(this.iniReader);
        this.joystickSection = new IniJoystickSection(this.iniReader);
        this.consoleSection = new IniConsoleSection(this.iniReader);
        this.audioSection = new IniAudioSection(this.iniReader);
        this.emulationSection = new IniEmulationSection(this.iniReader);
        this.favoritesSection = new IniFavoritesSection(this.iniReader);
    }

    public IniFilterSection getFilter(String filterName) {
        return new IniFilterSection(this.iniReader, filterName);
    }

    public String[] getFilterList(ISIDDefs.ChipModel model) {
        ArrayList<String> filters = new ArrayList<String>();
        for (String heading : this.iniReader.listSections()) {
            if (!heading.matches("Filter.*") || !(this.getFilter(heading).getFilter8580CurvePosition() != 0.0f ^ model == ISIDDefs.ChipModel.MOS6581)) continue;
            filters.add(heading);
        }
        return filters.toArray(new String[0]);
    }

    public IniConfig() {
        this.read();
    }

    private void read() {
        if (this.iniPath != null && this.iniPath.exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(this.iniPath);
                this.iniReader = new IniReader(is);
                this.clear();
                if (this.sidplay2Section.getVersion() == 18) {
                    return;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            this.createINIBackup(this.iniPath);
        }
        this.readInternal();
    }

    private File getINIPath() {
        try {
            File configPlace = null;
            for (String s : new String[]{System.getProperty("user.dir"), System.getProperty("user.home")}) {
                if (s == null || !(configPlace = new File(s, FILE_NAME)).exists()) continue;
                return configPlace;
            }
            return configPlace;
        }
        catch (AccessControlException e) {
            return null;
        }
    }

    private void createINIBackup(File iniFile) {
        iniFile.renameTo(new File(iniFile.getParentFile(), "sidplay2.ini.bak"));
    }

    private void readInternal() {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("sidplay/ini/sidplay2.ini");
        System.out.println("Use internal INI file: sidplay/ini/sidplay2.ini");
        try {
            this.iniReader = new IniReader(is);
            this.clear();
            this.iniReader.setProperty("SIDPlay2", "Version", 18);
            is.close();
        }
        catch (IOException e) {
            return;
        }
    }

    public void write() {
        if (!this.iniReader.isDirty()) {
            return;
        }
        try {
            this.iniReader.save(this.iniPath.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final IniSidplay2Section sidplay2() {
        return this.sidplay2Section;
    }

    public final IniC1541Section c1541() {
        return this.c1541Section;
    }

    public final IniPrinterSection printer() {
        return this.printerSection;
    }

    public final IniJoystickSection joystick() {
        return this.joystickSection;
    }

    public final IniConsoleSection console() {
        return this.consoleSection;
    }

    public final IniAudioSection audio() {
        return this.audioSection;
    }

    public final IniEmulationSection emulation() {
        return this.emulationSection;
    }

    public final IniFavoritesSection favorites() {
        return this.favoritesSection;
    }

    public final IniFilterSection filter(ISIDDefs.ChipModel model) {
        if (model == ISIDDefs.ChipModel.MOS8580) {
            return new IniFilterSection(this.iniReader, this.emulationSection.getFilter8580());
        }
        return new IniFilterSection(this.iniReader, this.emulationSection.getFilter6581());
    }

    public String getHVSCName(File file) {
        String hvsc = this.sidplay2().getHvsc();
        return IniConfig.getCollectionRelName(file, hvsc);
    }

    public String getCGSCName(File file) {
        String cgsc = this.sidplay2().getCgsc();
        return IniConfig.getCollectionRelName(file, cgsc);
    }

    public static String getCollectionRelName(File file, String collectionRoot) {
        try {
            String name;
            String collCanonicalPath;
            if (collectionRoot == null || collectionRoot.length() == 0) {
                return null;
            }
            if (file instanceof ZipEntryFileProxy) {
                int indexOf = file.getPath().indexOf(47);
                if (indexOf == -1) {
                    return null;
                }
                return file.getPath().substring(indexOf);
            }
            String canonicalPath = file.getCanonicalPath();
            if (canonicalPath.startsWith(collCanonicalPath = new File(collectionRoot).getCanonicalPath()) && (name = canonicalPath.substring(collCanonicalPath.length()).replace('\\', '/')).startsWith("/")) {
                return name;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

