/*
 * Decompiled with CFR 0.152.
 */
package sidplay.ini;

import java.io.File;
import resid_builder.resid.ISIDDefs;
import sidplay.audio.AudioConfig;
import sidplay.ini.IniReader;
import sidplay.ini.IniSection;

public class IniAudioSection
extends IniSection {
    protected boolean playOriginal;
    protected String mp3File;

    public IniAudioSection(IniReader iniReader) {
        super(iniReader);
    }

    public final int getFrequency() {
        return this.iniReader.getPropertyInt("Audio", "Frequency", 48000);
    }

    public final void setFrequency(int freq) {
        this.iniReader.setProperty("Audio", "Frequency", freq);
    }

    public final ISIDDefs.SamplingMethod getSampling() {
        return this.iniReader.getPropertyEnum("Audio", "Sampling", ISIDDefs.SamplingMethod.DECIMATE);
    }

    public final void setSampling(ISIDDefs.SamplingMethod method) {
        this.iniReader.setProperty("Audio", "Sampling", (Object)method);
    }

    public final boolean isPlayOriginal() {
        return this.playOriginal;
    }

    public final void setPlayOriginal(boolean original) {
        this.playOriginal = original;
    }

    public final File getMp3File() {
        return new File(this.iniReader.getPropertyString("Audio", "MP3File", null));
    }

    public final void setMp3File(File recording) {
        this.iniReader.setProperty("Audio", "MP3File", recording.getAbsolutePath());
    }

    public final float getLeftVolume() {
        return this.iniReader.getPropertyFloat("Audio", "LeftVolume", 0.0f);
    }

    public final void setLeftVolume(float volume) {
        this.iniReader.setProperty("Audio", "LeftVolume", Float.valueOf(volume));
    }

    public float getRightVolume() {
        return this.iniReader.getPropertyFloat("Audio", "RightVolume", 0.0f);
    }

    public void setRightVolume(float volume) {
        this.iniReader.setProperty("Audio", "RightVolume", Float.valueOf(volume));
    }

    public AudioConfig toAudioConfig(int channels) {
        return new AudioConfig(this.getFrequency(), channels, this.getSampling());
    }
}

