/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import sidplay.audio.AudioConfig;
import sidplay.audio.AudioDriver;

public class WavFile
extends AudioDriver {
    protected static final Charset US_ASCII = Charset.forName("US-ASCII");
    private ByteBuffer sampleBuffer;
    private int byteCount;
    private final WavHeader wavHdr = new WavHeader();
    private RandomAccessFile file;

    @Override
    public void open(AudioConfig cfg) throws IOException {
        int channels = cfg.channels;
        int freq = cfg.frameRate;
        int blockAlign = 2 * channels;
        this.byteCount = 0;
        this.sampleBuffer = ByteBuffer.allocate(cfg.getChunkFrames() * blockAlign);
        this.sampleBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.wavHdr.length = 36;
        this.wavHdr.format = 1;
        this.wavHdr.channels = (short)channels;
        this.wavHdr.sampleFreq = freq;
        this.wavHdr.bytesPerSec = freq * blockAlign;
        this.wavHdr.blockAlign = (short)blockAlign;
        this.wavHdr.bitsPerSample = (short)16;
        this.file = new RandomAccessFile(this.getFilename(cfg), "rw");
        this.file.setLength(0L);
        this.file.write(this.wavHdr.getBytes());
    }

    @Override
    public void write() {
        this.byteCount += this.sampleBuffer.capacity();
        try {
            this.file.write(this.sampleBuffer.array(), 0, this.sampleBuffer.capacity());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void pause() {
    }

    @Override
    public void close() {
        try {
            this.wavHdr.length = this.byteCount + 44 - 8;
            this.wavHdr.dataChunkLen = this.byteCount;
            this.file.seek(0L);
            this.file.write(this.wavHdr.getBytes(), 0, 44);
            this.file.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ByteBuffer buffer() {
        return this.sampleBuffer;
    }

    public String getFilename(AudioConfig cfg) {
        if (cfg.getOutputFilename() != null) {
            return cfg.getOutputFilename();
        }
        if (cfg.getTuneFile() == null) {
            return "jsidplay2.wav";
        }
        String subTune = "";
        if (cfg.getSongCount() > 1) {
            subTune = String.format("-%02d", cfg.getCurrentSong());
        }
        return cfg.getTuneFile().getName().replace(".sid", subTune + ".wav");
    }

    static class WavHeader {
        public static final int HEADER_LENGTH = 44;
        protected int length;
        protected short format;
        protected short channels;
        protected int sampleFreq;
        protected int bytesPerSec;
        protected short blockAlign;
        protected short bitsPerSample;
        protected int dataChunkLen;

        WavHeader() {
        }

        public byte[] getBytes() {
            ByteBuffer b = ByteBuffer.allocate(44);
            b.order(ByteOrder.LITTLE_ENDIAN);
            b.put("RIFF".getBytes(US_ASCII));
            b.putInt(this.length);
            b.put("WAVE".getBytes(US_ASCII));
            b.put("fmt ".getBytes(US_ASCII));
            b.putInt(16);
            b.putShort(this.format);
            b.putShort(this.channels);
            b.putInt(this.sampleFreq);
            b.putInt(this.bytesPerSec);
            b.putShort(this.blockAlign);
            b.putShort(this.bitsPerSample);
            b.put("data".getBytes(US_ASCII));
            b.putInt(this.dataChunkLen);
            return b.array();
        }
    }
}

