/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import sidplay.audio.AudioConfig;
import sidplay.audio.AudioDriver;

public class ProxyDriver
extends AudioDriver {
    private final AudioDriver driverOne;
    private final AudioDriver driverTwo;

    public ProxyDriver(AudioDriver driver1, AudioDriver driver2) {
        this.driverOne = driver1;
        this.driverTwo = driver2;
    }

    @Override
    public void open(AudioConfig cfg) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        this.driverOne.open(cfg);
        this.driverTwo.open(cfg);
    }

    @Override
    public void pause() {
        this.driverOne.pause();
        this.driverTwo.pause();
    }

    @Override
    public void write() throws InterruptedException {
        this.driverOne.write();
        System.arraycopy(this.buffer().array(), 0, this.driverTwo.buffer().array(), 0, this.driverTwo.buffer().capacity());
        this.driverTwo.write();
    }

    @Override
    public void close() {
        this.driverOne.close();
        this.driverTwo.close();
    }

    @Override
    public ByteBuffer buffer() {
        return this.driverOne.buffer();
    }

    @Override
    public void setFastForward(int factor) {
        this.driverOne.setFastForward(factor);
        this.driverTwo.setFastForward(factor);
    }
}

