/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import lowlevel.LameEncoder;
import sidplay.audio.AudioConfig;
import sidplay.audio.AudioDriver;

public class MP3File
extends AudioDriver {
    private ByteBuffer sampleBuffer;
    private OutputStream out;
    private LameEncoder jump3r;

    @Override
    public void open(AudioConfig cfg) throws LineUnavailableException, UnsupportedAudioFileException, IOException {
        int channels = cfg.channels;
        int blockAlign = 2 * channels;
        this.sampleBuffer = ByteBuffer.allocate(cfg.getChunkFrames() * blockAlign);
        this.sampleBuffer.order(ByteOrder.LITTLE_ENDIAN);
        AudioFormat audioFormat = new AudioFormat(cfg.frameRate, 16, cfg.channels, true, false);
        this.jump3r = new LameEncoder(audioFormat);
        this.out = new FileOutputStream(this.getFilename(cfg));
    }

    @Override
    public void write() throws InterruptedException {
        try {
            byte[] encoded = new byte[this.jump3r.getMP3BufferSize()];
            int bytesWritten = this.jump3r.encodeBuffer(this.sampleBuffer.array(), 0, this.sampleBuffer.capacity(), encoded);
            this.out.write(encoded, 0, bytesWritten);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            throw new InterruptedException();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new InterruptedException();
        }
    }

    @Override
    public void pause() {
    }

    @Override
    public void close() {
        if (this.jump3r != null) {
            this.jump3r.close();
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public ByteBuffer buffer() {
        return this.sampleBuffer;
    }

    public String getFilename(AudioConfig cfg) {
        if (cfg.getOutputFilename() != null) {
            return cfg.getOutputFilename();
        }
        if (cfg.getTuneFile() == null) {
            return "jsidplay2.mp3";
        }
        String subTune = "";
        if (cfg.getSongCount() > 1) {
            subTune = String.format("-%02d", cfg.getCurrentSong());
        }
        return cfg.getTuneFile().getName().replace(".sid", subTune + ".mp3");
    }
}

