/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import sidplay.audio.AudioConfig;
import sidplay.audio.AudioDriver;

public class JavaSound
extends AudioDriver {
    private AudioFormat audioFormat;
    private SourceDataLine dataLine;
    protected ByteBuffer sampleBuffer;

    @Override
    public synchronized void open(AudioConfig cfg) throws LineUnavailableException {
        this.audioFormat = new AudioFormat(cfg.frameRate, 16, cfg.channels, true, false);
        this.dataLine = AudioSystem.getSourceDataLine(this.audioFormat);
        this.dataLine.open(this.dataLine.getFormat(), cfg.bufferFrames * 2 * cfg.channels);
        cfg.bufferFrames = this.dataLine.getBufferSize() / 2 / cfg.channels;
        this.sampleBuffer = ByteBuffer.allocate(cfg.getChunkFrames() * 2 * cfg.channels);
        this.sampleBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public synchronized void write() throws InterruptedException {
        int len;
        if (!this.dataLine.isActive()) {
            this.dataLine.start();
        }
        if (this.fastForward > 1) {
            this.sampleBuffer.rewind();
            int newLen = 0;
            int[] val = new int[this.audioFormat.getChannels()];
            int j = 0;
            while (this.sampleBuffer.position() < this.sampleBuffer.capacity()) {
                int c = 0;
                while (c < this.audioFormat.getChannels()) {
                    int n = c++;
                    val[n] = val[n] + this.sampleBuffer.getShort();
                }
                if (++j != this.fastForward) continue;
                j = 0;
                for (c = 0; c < this.audioFormat.getChannels(); ++c) {
                    this.sampleBuffer.putShort(newLen, (short)(val[c] / this.fastForward));
                    newLen += 2;
                }
                Arrays.fill(val, 0);
            }
            len = newLen;
        } else {
            len = this.sampleBuffer.capacity();
        }
        int bytesWritten = this.dataLine.write(this.sampleBuffer.array(), 0, len);
        if (bytesWritten != len) {
            throw new InterruptedException();
        }
    }

    public synchronized int getRemainingPlayTime() {
        int bytesPerFrame = this.dataLine.getFormat().getChannels() * 2;
        int framesPlayed = this.dataLine.available() / bytesPerFrame;
        int framesTotal = this.dataLine.getBufferSize() / bytesPerFrame;
        int framesNotYetPlayed = framesTotal - framesPlayed;
        return framesNotYetPlayed * 1000 / framesTotal;
    }

    @Override
    public synchronized void pause() {
        if (this.dataLine.isActive()) {
            this.dataLine.drain();
            this.dataLine.stop();
        }
    }

    @Override
    public synchronized void close() {
        if (this.dataLine == null) {
            return;
        }
        if (this.dataLine.isActive()) {
            this.dataLine.drain();
            this.dataLine.stop();
        }
        if (this.dataLine.isOpen()) {
            try {
                this.dataLine.close();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    @Override
    public ByteBuffer buffer() {
        return this.sampleBuffer;
    }
}

