/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import java.io.File;
import javax.sound.sampled.LineUnavailableException;
import lowlevel.LameDecoder;
import resid_builder.resid.ISIDDefs;
import sidplay.audio.AudioConfig;
import sidplay.audio.JavaSound;
import sidplay.audio.NaturalFinishedException;

public class CmpMP3File
extends JavaSound {
    private boolean playOriginal;
    private File mp3File;
    protected LameDecoder jump3r;
    protected JavaSound mp3Driver = new JavaSound();

    @Override
    public void open(AudioConfig cfg) throws LineUnavailableException {
        super.open(cfg);
        this.jump3r = new LameDecoder(this.mp3File.getAbsolutePath());
        this.mp3Driver.open(new AudioConfig(this.jump3r.getSampleRate(), this.jump3r.getChannels(), ISIDDefs.SamplingMethod.RESAMPLE){

            @Override
            public int getChunkFrames() {
                return CmpMP3File.this.jump3r.getFrameSize();
            }

            @Override
            public int getFrameRate() {
                return CmpMP3File.this.jump3r.getSampleRate();
            }
        });
    }

    @Override
    public void write() throws InterruptedException {
        if (!this.jump3r.decode(this.mp3Driver.sampleBuffer)) {
            throw new NaturalFinishedException();
        }
        if (this.playOriginal) {
            this.mp3Driver.write();
        } else {
            super.write();
        }
    }

    @Override
    public synchronized void pause() {
        super.pause();
        this.mp3Driver.pause();
    }

    @Override
    public void close() {
        super.close();
        this.mp3Driver.close();
        if (this.jump3r != null) {
            this.jump3r.close();
        }
    }

    public void setPlayOriginal(boolean playOriginal) {
        this.playOriginal = playOriginal;
    }

    public void setMp3File(File mp3File) {
        this.mp3File = mp3File;
    }
}

