/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import java.io.File;
import resid_builder.resid.ISIDDefs;

public class AudioConfig {
    protected int frameRate = 48000;
    protected int channels = 1;
    protected int bufferFrames = 4096;
    private ISIDDefs.SamplingMethod samplingMethod;
    private File tuneFile;
    private int songCount;
    private int currentSong;
    private String outputFilename;

    protected AudioConfig() {
    }

    public AudioConfig(int frameRate, int channels, ISIDDefs.SamplingMethod samplingMethod) {
        this.frameRate = frameRate;
        this.channels = channels;
        this.samplingMethod = samplingMethod;
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public int getChunkFrames() {
        return 1024 < this.bufferFrames ? 1024 : this.bufferFrames;
    }

    public int getBufferFrames() {
        return this.bufferFrames;
    }

    public ISIDDefs.SamplingMethod getSamplingMethod() {
        return this.samplingMethod;
    }

    public final File getTuneFile() {
        return this.tuneFile;
    }

    public final void setTuneFilename(File file) {
        this.tuneFile = file;
    }

    public final int getSongCount() {
        return this.songCount;
    }

    public final void setSongCount(int count) {
        this.songCount = count;
    }

    public final int getCurrentSong() {
        return this.currentSong;
    }

    public final void setCurrentSong(int current) {
        this.currentSong = current;
    }

    public final String getOutputFilename() {
        return this.outputFilename;
    }

    public final void setOutputfilename(String filename) {
        this.outputFilename = filename;
    }
}

