/*
 * Decompiled with CFR 0.152.
 */
package sidplay;

import java.io.File;
import libsidplay.Player;
import libsidplay.common.ISID2Types;
import libsidplay.sidtune.SidTune;
import resid_builder.ReSID;
import resid_builder.ReSIDBuilder;
import resid_builder.resid.ISIDDefs;
import sidplay.audio.AudioConfig;
import sidplay.audio.AudioDriver;
import sidplay.audio.JavaSound;
import sidplay.ini.IniConfig;
import sidplay.ini.IniFilterSection;

public class Test {
    public void playTune(String filename) throws Exception {
        SidTune tune = SidTune.load(new File(filename));
        tune.selectSong(1);
        Player player = new Player();
        player.setTune(tune);
        IniConfig iniCfg = new IniConfig();
        IniFilterSection filter6581 = iniCfg.filter(ISIDDefs.ChipModel.MOS6581);
        IniFilterSection filter8580 = iniCfg.filter(ISIDDefs.ChipModel.MOS8580);
        player.setClock(ISID2Types.Clock.PAL);
        JavaSound driver = new JavaSound();
        AudioConfig config = iniCfg.audio().toAudioConfig(1);
        ((AudioDriver)driver).open(config);
        ReSIDBuilder rs = new ReSIDBuilder(config, player.getC64().getClock().getCpuFrequency());
        rs.setOutput(driver);
        ReSID sid = (ReSID)rs.lock(player.getC64().getEventScheduler(), ISIDDefs.ChipModel.MOS6581);
        sid.setFilter(true);
        sid.filter(filter6581, filter8580);
        sid.sampling(player.getC64().getClock().getCpuFrequency(), iniCfg.audio().getFrequency(), iniCfg.audio().getSampling());
        player.getC64().setSID(0, sid);
        player.reset();
        while (true) {
            player.play(10000);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Missing argument: <filename>");
            System.exit(-1);
        }
        Test tst = new Test();
        tst.playTune(args[0]);
    }
}

