/*
 * Decompiled with CFR 0.152.
 */
package sidplay;

import applet.disassembler.CPUParser;
import hardsid_builder.HardSID;
import hardsid_builder.HardSIDBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import libsidplay.Player;
import libsidplay.common.ISID2Types;
import libsidplay.common.SIDBuilder;
import libsidplay.common.SIDEmu;
import libsidplay.components.c1541.C1541;
import libsidplay.components.mos6510.IMOS6510Disassembler;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneInfo;
import libsidutils.SidDatabase;
import resid_builder.ReSID;
import resid_builder.ReSIDBuilder;
import resid_builder.resid.ISIDDefs;
import sidplay.audio.AudioConfig;
import sidplay.audio.AudioDriver;
import sidplay.audio.AudioNull;
import sidplay.audio.CmpMP3File;
import sidplay.audio.JavaSound;
import sidplay.audio.MP3File;
import sidplay.audio.NaturalFinishedException;
import sidplay.audio.ProxyDriver;
import sidplay.audio.WavFile;
import sidplay.ini.IniAudioSection;
import sidplay.ini.IniConfig;
import sidplay.ini.IniConsoleSection;
import sidplay.ini.IniEmulationSection;

public class ConsolePlayer {
    public static final int SID2_PREV_SONG_TIMEOUT = 4;
    public static final int playerRunning = 1;
    public static final int playerPaused = 2;
    public static final int playerStopped = 3;
    public static final int playerRestart = 4;
    public static final int playerExit = 5;
    public static final int playerFast = 128;
    public static final int playerFastRestart = 132;
    public static final int playerFastExit = 133;
    private final Player player = new Player();
    private SidTune tune;
    private int state = 3;
    private String outputFilename;
    private final IniConfig iniCfg = new IniConfig();
    private final DriverSettings driver = new DriverSettings();
    private final Timer timer = new Timer();
    private final Track track = new Track();
    private final Speed speed = new Speed();
    private int quietLevel;
    private int verboseLevel;
    private boolean v1mute;
    private boolean v2mute;
    private boolean v3mute;
    private boolean filterEnable;
    private IMOS6510Disassembler disassembler;
    private SIDBuilder sidEmuFactory;
    private OUTPUTS lastOutput;
    private SIDEMUS lastSidEmu;
    private boolean lastPlayOriginal;
    private boolean lastTimeMP3;

    public final Player getPlayer() {
        return this.player;
    }

    public final int getState() {
        return this.state;
    }

    public final IniConfig getConfig() {
        return this.iniCfg;
    }

    public final DriverSettings getDriverSettings() {
        return this.driver;
    }

    public final Timer getTimer() {
        return this.timer;
    }

    public final Track getTrack() {
        return this.track;
    }

    public ConsolePlayer() {
        IniEmulationSection emulation = this.iniCfg.emulation();
        this.filterEnable = emulation.isFilter();
        this.track.single = this.iniCfg.sidplay2().isSingle();
    }

    public boolean createSidEmu(SIDEMUS emu, AudioConfig audioConfig, double cpuFrequency) {
        this.sidEmuFactory = null;
        switch (emu) {
            case EMU_RESID: {
                ReSIDBuilder rs = new ReSIDBuilder(audioConfig, cpuFrequency);
                this.sidEmuFactory = rs;
                break;
            }
            case EMU_HARDSID: {
                HardSIDBuilder hs = new HardSIDBuilder();
                if (!hs.bool()) {
                    this.displayError(hs.error());
                    return false;
                }
                hs.setDevicesToUse(this.iniCfg);
                if (!hs.bool()) {
                    this.displayError(hs.error());
                    return false;
                }
                if (!hs.bool()) {
                    this.displayError(hs.error());
                    return false;
                }
                this.sidEmuFactory = hs;
                break;
            }
        }
        return true;
    }

    public boolean open() throws InterruptedException {
        ISID2Types.Clock cpuFreq;
        if ((this.state & 0xFFFFFF7F) == 4) {
            this.state = 3;
        }
        SidTuneInfo tuneInfo = null;
        if (this.tune != null) {
            this.track.selected = this.tune.selectSong(this.track.selected);
            if (this.track.first == 0) {
                this.track.first = this.track.selected;
            }
            tuneInfo = this.tune.getInfo();
        }
        this.player.setTune(this.tune);
        int songs = 1;
        int currentSong = 1;
        File file = null;
        if (tuneInfo != null) {
            this.track.songs = tuneInfo.songs;
            songs = tuneInfo.songs;
            currentSong = tuneInfo.currentSong;
            file = tuneInfo.file;
        }
        if ((cpuFreq = this.iniCfg.emulation().getUserClockSpeed()) == null) {
            cpuFreq = this.iniCfg.emulation().getDefaultClockSpeed();
            if (tuneInfo != null) {
                switch (tuneInfo.clockSpeed) {
                    case UNKNOWN: 
                    case ANY: {
                        cpuFreq = this.iniCfg.emulation().getDefaultClockSpeed();
                        break;
                    }
                    case PAL: 
                    case NTSC: {
                        cpuFreq = ISID2Types.Clock.valueOf(tuneInfo.clockSpeed.toString());
                    }
                }
            }
        }
        this.player.setClock(cpuFreq);
        IniAudioSection audio = this.iniCfg.audio();
        if (this.lastTimeMP3) {
            this.driver.setOutput(this.lastOutput);
            this.driver.setSid(this.lastSidEmu);
            audio.setPlayOriginal(this.lastPlayOriginal);
            this.lastTimeMP3 = false;
        }
        if (file != null && file.getName().toLowerCase().endsWith(".mp3")) {
            this.lastOutput = this.driver.getOutput();
            this.lastSidEmu = this.driver.getSid();
            this.lastPlayOriginal = audio.isPlayOriginal();
            this.lastTimeMP3 = true;
            this.driver.setOutput(OUTPUTS.OUT_COMPARE);
            this.driver.setSid(SIDEMUS.EMU_RESID);
            audio.setPlayOriginal(true);
            audio.setMp3File(file);
        }
        if (this.driver.getDevice() instanceof CmpMP3File) {
            ((CmpMP3File)this.driver.getDevice()).setPlayOriginal(audio.isPlayOriginal());
            ((CmpMP3File)this.driver.getDevice()).setMp3File(audio.getMp3File());
        }
        int secondAddress = 0;
        this.driver.channels = 1;
        if (this.iniCfg.emulation().isForceStereoTune()) {
            secondAddress = this.iniCfg.emulation().getDualSidBase();
        } else if (tuneInfo != null && tuneInfo.sidChipBase2 != 0) {
            secondAddress = tuneInfo.sidChipBase2;
        }
        if (secondAddress != 0) {
            this.driver.channels = 2;
            if (secondAddress != 54272) {
                this.player.getC64().setSecondSIDAddress(secondAddress);
            }
        }
        AudioConfig audioConfig = this.iniCfg.audio().toAudioConfig(this.driver.channels);
        audioConfig.setTuneFilename(file);
        audioConfig.setSongCount(songs);
        audioConfig.setCurrentSong(currentSong);
        audioConfig.setOutputfilename(this.outputFilename);
        try {
            this.driver.getDevice().open(audioConfig);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!this.createSidEmu(this.driver.sid, audioConfig, cpuFreq.getCpuFrequency())) {
            return false;
        }
        if (this.sidEmuFactory instanceof ReSIDBuilder) {
            ((ReSIDBuilder)this.sidEmuFactory).setSIDVolume(0, this.dB2factor(this.iniCfg.audio().getLeftVolume()));
            ((ReSIDBuilder)this.sidEmuFactory).setSIDVolume(1, this.dB2factor(this.iniCfg.audio().getRightVolume()));
            ((ReSIDBuilder)this.sidEmuFactory).setOutput(OUTPUTS.OUT_NULL.getDriver());
        }
        this.updateSidEmulation();
        if (secondAddress == 54272) {
            final SIDEmu s1 = this.player.getC64().getSID(0);
            final SIDEmu s2 = this.player.getC64().getSID(1);
            this.player.getC64().setSID(0, new SIDEmu(this.player.getC64().getEventScheduler()){

                @Override
                public void reset(byte volume) {
                    s1.reset(volume);
                }

                @Override
                public byte read(int addr) {
                    return s1.read(addr);
                }

                @Override
                public void write(int addr, byte data) {
                    s1.write(addr, data);
                    s2.write(addr, data);
                }

                @Override
                public byte readInternalRegister(int addr) {
                    return s1.readInternalRegister(addr);
                }

                @Override
                public void clock() {
                    s1.clock();
                }

                @Override
                public void setEnabled(int num, boolean mute) {
                    s1.setEnabled(num, mute);
                }

                @Override
                public void setFilter(boolean enable) {
                    s1.setFilter(enable);
                }

                @Override
                public ISIDDefs.ChipModel getChipModel() {
                    return s1.getChipModel();
                }
            });
        }
        this.speed.current = (short)this.speed.max;
        this.driver.getDevice().setFastForward(this.speed.current);
        this.v3mute = false;
        this.v2mute = false;
        this.v1mute = false;
        this.player.reset();
        this.player.enableFloppyDiskDrives(this.getConfig().c1541().isDriveOn());
        this.player.connectC64AndC1541WithParallelCable(this.getConfig().c1541().isParallelCable());
        for (int driveNum = 0; driveNum < this.player.getFloppies().length; ++driveNum) {
            C1541 floppy = this.player.getFloppies()[driveNum];
            floppy.setFloppyType(this.getConfig().c1541().getFloppyType());
            floppy.setRamExpansion(0, this.getConfig().c1541().isRamExpansionEnabled(0));
            floppy.setRamExpansion(1, this.getConfig().c1541().isRamExpansionEnabled(1));
            floppy.setRamExpansion(2, this.getConfig().c1541().isRamExpansionEnabled(2));
            floppy.setRamExpansion(3, this.getConfig().c1541().isRamExpansionEnabled(3));
            floppy.setRamExpansion(4, this.getConfig().c1541().isRamExpansionEnabled(4));
        }
        this.player.turnPrinterOnOff(this.getConfig().printer().isPrinterOn());
        if (this.tune != null) {
            int length;
            SidDatabase database = SidDatabase.getInstance(this.iniCfg.sidplay2().getHvsc());
            if (database != null && !this.timer.valid && this.iniCfg.sidplay2().isEnableDatabase() && (length = database.length(this.tune)) >= 0) {
                this.timer.defaultLength = length;
            }
        } else {
            this.timer.defaultLength = 0L;
        }
        this.timer.stop = 0L;
        this.timer.stop += this.timer.defaultLength;
        if (this.timer.valid) {
            this.timer.stop += this.timer.start;
        } else if ((this.timer.stop & (long)(this.timer.start >= this.timer.stop ? 1 : 0)) != 0L) {
            this.displayError("ERROR: Start time exceeds song length!");
            return false;
        }
        this.timer.current = -1L;
        this.state = 1;
        return true;
    }

    private float dB2factor(float volume) {
        return (float)Math.pow(10.0, volume / 20.0f);
    }

    public void close() {
        if (this.state == 5 && this.sidEmuFactory instanceof HardSIDBuilder) {
            ((HardSIDBuilder)this.sidEmuFactory).flush();
            ((HardSIDBuilder)this.sidEmuFactory).reset();
        }
        if (this.sidEmuFactory != null) {
            for (int i = 0; i < 2; ++i) {
                SIDEmu s = this.player.getC64().getSID(i);
                if (s == null) continue;
                this.sidEmuFactory.unlock(s);
                this.player.getC64().setSID(i, null);
            }
        }
        this.sidEmuFactory = null;
        this.driver.getDevice().close();
    }

    public final int getHardSIDCount() {
        SIDBuilder emu = this.sidEmuFactory;
        if (emu instanceof HardSIDBuilder) {
            return ((HardSIDBuilder)emu).devices();
        }
        return 0;
    }

    public void resetTrack() {
        this.track.first = 0;
        this.track.selected = 0;
    }

    public void setSLDb(boolean enableSLDb) {
        if (!this.timer.valid) {
            if (enableSLDb && this.tune != null) {
                SidDatabase database = SidDatabase.getInstance(this.iniCfg.sidplay2().getHvsc());
                int length = database.length(this.tune);
                if (length > 0) {
                    this.timer.stop = this.timer.defaultLength = (long)length;
                }
            } else {
                this.timer.defaultLength = 0L;
                this.timer.stop = 0L;
            }
        }
    }

    public boolean play() throws InterruptedException {
        int seconds = this.player.time();
        if ((long)seconds != this.timer.current) {
            this.timer.current = seconds;
            if ((long)seconds == this.timer.start) {
                this.normalSpeed();
                this.player.setDebug(this.disassembler);
                if (this.sidEmuFactory instanceof ReSIDBuilder) {
                    ((ReSIDBuilder)this.sidEmuFactory).setOutput(this.driver.getDevice());
                }
            }
            if (this.iniCfg.sidplay2().isEnableDatabase() && this.timer.stop != 0L && (long)seconds >= this.timer.stop) {
                if (this.track.single) {
                    this.state = 5;
                } else {
                    this.nextSong();
                    if (this.track.selected == this.track.first && !this.track.loop) {
                        this.state = 5;
                    }
                }
                if (this.state == 5 && this.sidEmuFactory instanceof HardSIDBuilder) {
                    ((HardSIDBuilder)this.sidEmuFactory).flush();
                    ((HardSIDBuilder)this.sidEmuFactory).reset();
                }
            }
        }
        if (this.state == 1) {
            try {
                this.player.play(10000);
            }
            catch (NaturalFinishedException e) {
                this.state = 5;
                throw e;
            }
        }
        return this.state == 1 || this.state == 2;
    }

    private void decodeKeys() {
        try {
            int key = System.in.read();
            switch (key) {
                case 104: {
                    this.state = 132;
                    this.track.selected = 1;
                    break;
                }
                case 101: {
                    this.state = 132;
                    this.track.selected = this.track.songs;
                    break;
                }
                case 62: {
                    this.nextSong();
                    break;
                }
                case 60: {
                    this.previousSong();
                    break;
                }
                case 46: {
                    this.fastForward();
                    break;
                }
                case 44: {
                    this.normalSpeed();
                    break;
                }
                case 112: {
                    this.pause();
                    break;
                }
                case 49: {
                    this.v1mute = !this.v1mute;
                    this.player.mute(0, 0, this.v1mute);
                    break;
                }
                case 50: {
                    this.v2mute = !this.v2mute;
                    this.player.mute(0, 1, this.v2mute);
                    break;
                }
                case 51: {
                    this.v3mute = !this.v3mute;
                    this.player.mute(0, 2, this.v3mute);
                    break;
                }
                case 52: {
                    this.v1mute = !this.v1mute;
                    this.player.mute(1, 0, this.v1mute);
                    break;
                }
                case 53: {
                    this.v2mute = !this.v2mute;
                    this.player.mute(1, 1, this.v2mute);
                    break;
                }
                case 54: {
                    this.v3mute = !this.v3mute;
                    this.player.mute(1, 2, this.v3mute);
                    break;
                }
                case 102: {
                    this.filterEnable ^= true;
                    for (int i = 0; i < 2; ++i) {
                        SIDEmu s = this.player.getC64().getSID(i);
                        if (s == null) continue;
                        s.setFilter(this.filterEnable);
                    }
                    break;
                }
                case 113: {
                    this.quit();
                    break;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void pause() {
        if (this.state == 2) {
            this.state = 1;
        } else {
            this.state = 2;
            this.driver.getDevice().pause();
        }
    }

    public void nextSong() {
        this.state = 132;
        ++this.track.selected;
        if (this.track.selected > this.track.songs) {
            this.track.selected = 1;
        }
    }

    public void previousSong() {
        this.state = 132;
        if (this.player.time() < 4) {
            --this.track.selected;
            if (this.track.selected < 1) {
                this.track.selected = this.track.songs;
            }
        }
    }

    public void restart() {
        this.state = 132;
    }

    public void fastForward() {
        this.speed.current = (short)(this.speed.current * 2);
        if (this.speed.current > this.speed.max) {
            this.speed.current = (short)this.speed.max;
        }
        this.driver.getDevice().setFastForward(this.speed.current);
    }

    public void normalSpeed() {
        this.speed.current = 1;
        this.driver.getDevice().setFastForward(1);
    }

    public void quit() {
        this.state = 133;
    }

    public void displayError(String error) {
        System.err.println(this + ": " + error);
    }

    long parseTime(String str) {
        long _time;
        if (str.length() == 0) {
            return -1L;
        }
        int sep = str.lastIndexOf(58);
        if (sep == -1) {
            _time = Integer.valueOf(str).intValue();
        } else {
            int val = Integer.valueOf(str.substring(0, sep));
            if (val < 0 || val > 99) {
                return -1L;
            }
            _time = (long)val * 60L;
            val = Integer.valueOf(str.substring(sep + 1));
            if (val < 0 || val > 59) {
                return -1L;
            }
            _time += (long)val;
        }
        return _time;
    }

    public int args(String[] argv) {
        int infile = -1;
        boolean err = false;
        if (argv.length == 0) {
            this.displayArgs(null);
            return -1;
        }
        this.driver.output = OUTPUTS.OUT_SOUNDCARD;
        this.driver.sid = SIDEMUS.EMU_RESID;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].charAt(0) == '-' && argv[i].length() > 1) {
                long time;
                if (argv[i].charAt(1) == 'h' || argv[i].equals("--help")) {
                    this.displayArgs(null);
                    return 0;
                }
                if (argv[i].equals("--help-debug")) {
                    this.displayDebugArgs();
                    return 0;
                }
                if (argv[i].charAt(1) == 'b') {
                    time = this.parseTime(argv[i].substring(2));
                    if (time == -1L) {
                        err = true;
                    }
                    this.timer.start = time;
                } else if (argv[i].equals("-fd")) {
                    this.iniCfg.emulation().setForceStereoTune(true);
                } else if (argv[i].startsWith("-f")) {
                    if (argv[i].length() == 2) {
                        err = true;
                    }
                    this.iniCfg.audio().setFrequency(Integer.valueOf(argv[i].substring(2)));
                } else if (argv[i].startsWith("-nf")) {
                    if (argv[i].length() == 3) {
                        this.filterEnable = false;
                    }
                } else if (argv[i].startsWith("-ns")) {
                    switch (argv[i].charAt(3)) {
                        case '1': {
                            this.iniCfg.emulation().setUserSidModel(ISIDDefs.ChipModel.MOS8580);
                            break;
                        }
                        case '0': {
                            this.iniCfg.emulation().setUserSidModel(ISIDDefs.ChipModel.MOS6581);
                            break;
                        }
                        default: {
                            err = true;
                            break;
                        }
                    }
                } else if (argv[i].startsWith("-nols")) {
                    this.track.loop = true;
                    this.track.single = true;
                    this.track.first = Integer.valueOf(argv[i].substring(4));
                } else if (argv[i].startsWith("-ol")) {
                    this.track.loop = true;
                    this.track.first = Integer.valueOf(argv[i].substring(3));
                } else if (argv[i].startsWith("-os")) {
                    this.track.single = true;
                    this.track.first = Integer.valueOf(argv[i].substring(3));
                } else if (argv[i].startsWith("-o")) {
                    if (argv[i].length() == 2) {
                        err = true;
                    }
                    this.track.first = Integer.valueOf(argv[i].substring(2));
                } else if (argv[i].startsWith("-q")) {
                    this.quietLevel = argv[i].length() == 2 ? 1 : Integer.valueOf(argv[i].substring(2));
                } else if (argv[i].startsWith("-t")) {
                    time = this.parseTime(argv[i].substring(2));
                    if (time == -1L) {
                        err = true;
                    }
                    this.timer.defaultLength = time;
                    this.timer.valid = true;
                    this.iniCfg.sidplay2().setEnableDatabase(true);
                } else if (argv[i].equals("-vnf")) {
                    this.iniCfg.emulation().setUserClockSpeed(ISID2Types.Clock.NTSC);
                } else if (argv[i].equals("-vpf")) {
                    this.iniCfg.emulation().setUserClockSpeed(ISID2Types.Clock.PAL);
                } else if (argv[i].equals("-vn")) {
                    this.iniCfg.emulation().setDefaultClockSpeed(ISID2Types.Clock.NTSC);
                } else if (argv[i].equals("-vp")) {
                    this.iniCfg.emulation().setDefaultClockSpeed(ISID2Types.Clock.PAL);
                } else if (argv[i].startsWith("-v")) {
                    this.verboseLevel = argv[i].length() == 2 ? 1 : Integer.valueOf(argv[i].substring(2));
                } else if (argv[i].equals("-m")) {
                    this.driver.output = OUTPUTS.OUT_MP3;
                    this.outputFilename = argv[++i];
                } else if (argv[i].equals("-w") || argv[i].equals("--wav")) {
                    this.driver.output = OUTPUTS.OUT_WAV;
                    this.outputFilename = argv[++i];
                } else if (argv[i].equals("-lm")) {
                    this.driver.output = OUTPUTS.OUT_LIVE_MP3;
                    this.outputFilename = argv[++i];
                } else if (argv[i].equals("-lw") || argv[i].equals("-l")) {
                    this.driver.output = OUTPUTS.OUT_LIVE_WAV;
                    this.outputFilename = argv[++i];
                } else if (argv[i].equals("--hardsid")) {
                    this.driver.sid = SIDEMUS.EMU_HARDSID;
                    this.driver.output = OUTPUTS.OUT_NULL;
                } else if (argv[i].equals("--none")) {
                    this.driver.sid = SIDEMUS.EMU_NONE;
                    this.driver.output = OUTPUTS.OUT_NULL;
                } else if (argv[i].equals("--nosid")) {
                    this.driver.sid = SIDEMUS.EMU_NONE;
                } else if (argv[i].equals("--cpu-debug")) {
                    this.disassembler = CPUParser.getInstance();
                } else {
                    err = true;
                }
            } else if (infile == -1) {
                infile = i;
            } else {
                err = true;
            }
            if (!err) continue;
            this.displayArgs(argv[i]);
            return -1;
        }
        if (this.driver.output.isFileBased()) {
            this.track.loop = false;
        }
        if (this.driver.output.isFileBased() && this.driver.sid == SIDEMUS.EMU_HARDSID) {
            this.displayError("ERROR: Cannot generate audio files using hardware emulations");
            return -1;
        }
        if (infile == -1) {
            return -1;
        }
        try {
            this.tune = new URL(argv[infile]).getProtocol().equals("file") ? this.loadTune(new File(argv[infile])) : this.loadTune(new URL(argv[infile]));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return -1;
        }
        if (this.tune == null) {
            return -1;
        }
        this.track.selected = this.track.first = this.tune.selectSong(this.track.first);
        if (this.track.single) {
            this.track.songs = 1;
        }
        if (this.driver.output.isFileBased() && this.timer.valid && this.timer.defaultLength == 0L) {
            this.displayError("ERROR: -t0 invalid in record mode");
            return -1;
        }
        if (!this.timer.valid) {
            this.timer.defaultLength = this.iniCfg.sidplay2().getPlayLength();
            if (this.driver.output.isFileBased()) {
                this.timer.defaultLength = this.iniCfg.sidplay2().getRecordLength();
            }
        }
        return 1;
    }

    public SidTune loadTune(final URL url) {
        try {
            InputStream stream = null;
            try {
                stream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                    @Override
                    public InputStream run() throws IOException {
                        return url.openConnection().getInputStream();
                    }
                });
                this.tune = SidTune.load(stream);
                this.tune.getInfo().file = null;
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.tune = null;
            return null;
        }
        return this.tune;
    }

    public SidTune loadTune(File f) {
        this.resetTrack();
        if (f == null) {
            this.tune = null;
            this.track.first = 1;
            this.track.songs = 0;
            return this.tune;
        }
        try {
            this.tune = SidTune.load(f);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.tune = null;
            return null;
        }
        return this.tune;
    }

    void displayArgs(String arg) {
        PrintStream out;
        PrintStream printStream = out = arg != null ? System.err : System.out;
        if (arg != null) {
            out.println("Option Error: " + arg);
        } else {
            out.println("Syntax: java -jar jsidplay2_console.jar [-<option>...] <datafile>");
        }
        out.println("Options:\n --help|-h    display this screen\n --help-debug debug help menu\n -b<num>      set start time in [m:]s format (default 0)\n -f<num>      set frequency in Hz (default: " + this.iniCfg.audio().getFrequency() + ")" + "\n" + " -fd          force dual sid environment" + "\n" + " -nf[filter]  no/new SID filter emulation" + "\n" + " -ns[0|1]     (no) MOS 8580 waveforms (default: from tune or cfg)" + "\n" + " -o<l|s>      looping and/or single track" + "\n" + " -o<num>      start track (default: preset)" + "\n" + " -t<num>      set play length in [m:]s format (0 is endless)" + "\n" + " -<v[level]|q>       verbose (level=0,1,2) or quiet (no time display) output" + "\n" + " -v[p|n][f]   set VIC PAL/NTSC clock speed (default: defined by song)" + "\n" + "              Use 'f' to force the clock by preventing speed fixing" + "\n" + " -w name     create wav file" + "\n -m name     create mp3 file" + "\n -lm name    create mp3 file and Java Sound" + "\n -lw name    create wav file and Java Sound");
        out.println(" --hardsid enable hardsid support\n");
        out.println("\nHome Page: http://jsidplay2.sourceforge.net/\n");
        System.out.println("<press return>");
        try {
            System.in.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void displayDebugArgs() {
        PrintStream out = System.out;
        out.println("Debug Options:\n --cpu-debug   display cpu register and assembly dumps\n --delay=<num> simulate c64 power on delay\n --wav<file>   wav file output device\n --none        no audio output device\n --nosid       no sid emulation\n");
        System.out.println("<press return>");
        try {
            System.in.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void menu() {
        int i;
        SidTuneInfo tuneInfo = this.tune.getInfo();
        if (this.quietLevel > 1) {
            return;
        }
        IniConsoleSection console = this.iniCfg.console();
        System.out.println(String.format("%c%s%c", Character.valueOf(console.getTopLeft()), this.setfill(console.getHorizontal(), 54), Character.valueOf(console.getTopRight())));
        System.out.println(String.format("%c%54s%c", Character.valueOf(console.getVertical()), " Java SIDPLAY - Music Player & C64 SID Chip Emulator  ", Character.valueOf(console.getVertical())));
        System.out.println(String.format("%c%s%c", Character.valueOf(console.getJunctionLeft()), this.setfill(console.getHorizontal(), 54), Character.valueOf(console.getJunctionRight())));
        if (tuneInfo.numberOfInfoStrings > 0) {
            if (tuneInfo.numberOfInfoStrings == 3) {
                System.out.println(String.format("%c Title        : %37s %c", Character.valueOf(console.getVertical()), tuneInfo.infoString[0], Character.valueOf(console.getVertical())));
                System.out.println(String.format("%c Author       : %37s %c", Character.valueOf(console.getVertical()), tuneInfo.infoString[1], Character.valueOf(console.getVertical())));
                System.out.println(String.format("%c Released     : %37s %c", Character.valueOf(console.getVertical()), tuneInfo.infoString[2], Character.valueOf(console.getVertical())));
            } else {
                for (i = 0; i < tuneInfo.numberOfInfoStrings; ++i) {
                    System.out.println(String.format("%c Description  : %37s %c", Character.valueOf(console.getVertical()), tuneInfo.infoString[i], Character.valueOf(console.getVertical())));
                }
            }
            System.out.println(String.format("%c%s%c", Character.valueOf(console.getJunctionLeft()), this.setfill(console.getHorizontal(), 54), Character.valueOf(console.getJunctionRight())));
        }
        if (this.verboseLevel != 0) {
            System.out.println(String.format("%c File format  : %37s %c", Character.valueOf(console.getVertical()), tuneInfo.getClass().getSimpleName(), Character.valueOf(console.getVertical())));
            System.out.println(String.format("%c Filename(s)  : %37s %c", Character.valueOf(console.getVertical()), tuneInfo.file.getName(), Character.valueOf(console.getVertical())));
        }
        System.out.print(String.format("%c Playlist     : ", Character.valueOf(console.getVertical())));
        i = 1;
        if (!this.track.single) {
            i = this.track.selected;
            if ((i -= this.track.first - 1) < 1) {
                i += this.track.songs;
            }
        }
        System.out.println(String.format("%37s %c", i + "/" + this.track.songs + " (tune " + tuneInfo.currentSong + "/" + tuneInfo.songs + "[" + tuneInfo.startSong + "])" + (this.track.loop ? " [LOOPING]" : ""), Character.valueOf(console.getVertical())));
        if (this.verboseLevel > 0) {
            System.out.println(String.format("%c%s%c", Character.valueOf(console.getBottomLeft()), this.setfill(console.getHorizontal(), 54), Character.valueOf(console.getBottomRight())));
            System.out.println(String.format("%c Song Speed   : %37s %c", new Object[]{Character.valueOf(console.getVertical()), this.tune.getSongSpeed(this.track.selected), Character.valueOf(console.getVertical())}));
        }
        System.out.print(String.format("%c Song Length  : ", Character.valueOf(console.getVertical())));
        if (this.timer.stop != 0L) {
            String time = String.format("%02d:%02d", this.timer.stop / 60L % 100L, this.timer.stop % 60L);
            System.out.print(String.format("%37s %c", "" + time, Character.valueOf(console.getVertical())));
        } else if (this.timer.valid) {
            System.out.print(String.format("%37s %c", "FOREVER", Character.valueOf(console.getVertical())));
        } else {
            System.out.print(String.format("%37s %c", "UNKNOWN", Character.valueOf(console.getVertical())));
        }
        System.out.println();
        if (this.verboseLevel > 0) {
            System.out.println(String.format("%c%s%c", Character.valueOf(console.getBottomLeft()), this.setfill(console.getHorizontal(), 54), Character.valueOf(console.getBottomRight())));
            StringBuffer line = new StringBuffer();
            line.append("DRIVER = ");
            if (tuneInfo.determinedDriverAddr == 0) {
                line.append("NOT PRESENT");
            } else {
                line.append(String.format("$%04x", tuneInfo.determinedDriverAddr));
                line.append(String.format("-$%04x", tuneInfo.determinedDriverAddr + tuneInfo.determinedDriverLength - 1));
            }
            if (tuneInfo.playAddr == 65535) {
                line.append(String.format(", SYS = $%04x", tuneInfo.initAddr));
            } else {
                line.append(String.format(", INIT = $%04x", tuneInfo.initAddr));
            }
            System.out.println(String.format("%c Addresses    : %37s %c", Character.valueOf(console.getVertical()), line.toString(), Character.valueOf(console.getVertical())));
            line = new StringBuffer();
            line.append(String.format("LOAD   = $%04x", tuneInfo.loadAddr));
            line.append(String.format("-$%04x", tuneInfo.loadAddr + tuneInfo.c64dataLen - 1));
            if (tuneInfo.playAddr != 65535) {
                line.append(String.format(", PLAY = $%04x", tuneInfo.playAddr));
            }
            System.out.println(String.format("%c              : %37s %c", Character.valueOf(console.getVertical()), line.toString(), Character.valueOf(console.getVertical())));
            line = new StringBuffer();
            line.append(String.format("Filter = %s", this.filterEnable ? "Yes" : "No"));
            line.append(String.format(", Model = %s", tuneInfo.sid1Model == SidTune.Model.MOS8580 ? "8580" : "6581"));
            System.out.println(String.format("%c SID Details  : %37s %c", Character.valueOf(console.getVertical()), line.toString(), Character.valueOf(console.getVertical())));
            if (this.verboseLevel > 1) {
                line = new StringBuffer();
                System.out.println(String.format("%c Delay        : %37s %c", Character.valueOf(console.getVertical()), line.toString(), Character.valueOf(console.getVertical())));
            }
        }
        System.out.println(String.format("%c%s%c", Character.valueOf(console.getBottomLeft()), this.setfill(console.getHorizontal(), 54), Character.valueOf(console.getBottomRight())));
        System.out.println("keyboard control (press enter after command):");
        System.out.println("< > - play previous/next tune");
        System.out.println(", . - normal/faster speed");
        System.out.println("p   - pause/continue player");
        System.out.println("h e - play first/last tune");
        System.out.println("1   - mute voice 1");
        System.out.println("2   - mute voice 2");
        System.out.println("3   - mute voice 3");
        System.out.println("4   - mute voice 1 (stereo)");
        System.out.println("5   - mute voice 2 (stereo)");
        System.out.println("6   - mute voice 3 (stereo)");
        System.out.println("f   - enable/disable filter");
        System.out.println("q   - quit player");
    }

    private String setfill(char ch, int length) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            ret.append(ch);
        }
        return ret.toString();
    }

    public static void main(String[] args) throws InterruptedException {
        ConsolePlayer player = new ConsolePlayer();
        if (player.args(args) < 0) {
            System.exit(1);
        }
        if (player.tune == null) {
            System.exit(0);
        }
        player.menu();
        do {
            if (!player.open()) {
                player.close();
                System.exit(0);
            }
            while (player.play()) {
                try {
                    if (player.quietLevel >= 2 || player.getState() != 2 && System.in.available() == 0) continue;
                    player.decodeKeys();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            player.close();
        } while ((player.getState() & 0xFFFFFF7F) == 4);
    }

    public void updateSidEmulation() {
        if (this.sidEmuFactory != null) {
            ISIDDefs.ChipModel chipModel = ConsolePlayer.determineSIDModel(this.iniCfg.emulation().getUserSidModel(), this.iniCfg.emulation().getDefaultSidModel(), this.tune != null ? this.tune.getInfo().sid1Model : null);
            this.updateSIDEmu(0, chipModel);
            if (this.driver.channels == 2) {
                ISIDDefs.ChipModel stereoChipModel = ConsolePlayer.determineSIDModel(this.iniCfg.emulation().getStereoSidModel(), chipModel, SidTune.Model.valueOf(chipModel.toString()));
                this.updateSIDEmu(1, stereoChipModel);
            }
        }
    }

    public static ISIDDefs.ChipModel determineSIDModel(ISIDDefs.ChipModel userForcedChoice, ISIDDefs.ChipModel defaultChoice, SidTune.Model model) {
        ISIDDefs.ChipModel chipModel = userForcedChoice;
        if (chipModel == null) {
            chipModel = defaultChoice;
            if (model != null) {
                switch (model) {
                    case MOS6581: 
                    case MOS8580: {
                        chipModel = ISIDDefs.ChipModel.valueOf(model.toString());
                        break;
                    }
                }
            }
        }
        return chipModel;
    }

    private void updateSIDEmu(int chipNum, ISIDDefs.ChipModel model) {
        SIDEmu s = this.player.getC64().getSID(chipNum);
        if (s == null) {
            s = this.sidEmuFactory.lock(this.player.getC64().getEventScheduler(), model);
        }
        if (s instanceof HardSID) {
            ((HardSID)s).write(24, (byte)0);
            ((HardSID)s).flush();
            s.reset((byte)0);
            this.sidEmuFactory.unlock(s);
            s = this.sidEmuFactory.lock(this.player.getC64().getEventScheduler(), model);
        }
        if (s instanceof ReSID) {
            ((ReSID)s).model(model);
            ((ReSID)s).filter(this.iniCfg.filter(ISIDDefs.ChipModel.MOS6581), this.iniCfg.filter(ISIDDefs.ChipModel.MOS8580));
        }
        this.player.getC64().setSID(chipNum, s);
    }

    public void setSIDVolume(int i, float volume) {
        if (this.sidEmuFactory instanceof ReSIDBuilder) {
            ((ReSIDBuilder)this.sidEmuFactory).setSIDVolume(i, volume);
        }
    }

    protected static class Speed {
        protected short current = 1;
        protected final short max = (short)32;

        protected Speed() {
        }
    }

    public static class Track {
        protected int first;
        protected int selected;
        protected int songs;
        protected boolean loop;
        protected boolean single;

        public int getCurrentSong() {
            return this.selected;
        }

        public int getCurrentSongCount() {
            return this.songs;
        }

        public void setCurrentSingle(boolean s) {
            this.single = s;
        }
    }

    public static class Timer {
        protected long start;
        protected long current;
        protected long stop;
        protected long defaultLength;
        protected boolean valid;

        public void setDefaultLength(long length) {
            this.defaultLength = length;
        }
    }

    public static class DriverSettings {
        protected SIDEMUS sid = SIDEMUS.EMU_RESID;
        protected OUTPUTS output = OUTPUTS.OUT_SOUNDCARD;
        protected int channels;

        public final SIDEMUS getSid() {
            return this.sid;
        }

        public final void setSid(SIDEMUS sid) {
            this.sid = sid;
        }

        public final OUTPUTS getOutput() {
            return this.output;
        }

        public final void setOutput(OUTPUTS output) {
            this.output = output;
        }

        public final AudioDriver getDevice() {
            return this.output.getDriver();
        }
    }

    public static enum OUTPUTS {
        OUT_NULL(false, new AudioNull()),
        OUT_SOUNDCARD(false, new JavaSound()),
        OUT_WAV(true, new WavFile()),
        OUT_MP3(true, new MP3File()),
        OUT_LIVE_WAV(true, new ProxyDriver(new JavaSound(), new WavFile())),
        OUT_LIVE_MP3(true, new ProxyDriver(new JavaSound(), new MP3File())),
        OUT_COMPARE(false, new CmpMP3File());

        private final boolean fileBased;
        private final AudioDriver drv;

        private OUTPUTS(boolean fileBased, AudioDriver drv) {
            this.fileBased = fileBased;
            this.drv = drv;
        }

        public boolean isFileBased() {
            return this.fileBased;
        }

        public AudioDriver getDriver() {
            return this.drv;
        }
    }

    public static enum SIDEMUS {
        EMU_NONE,
        EMU_RESID,
        EMU_HARDSID;

    }
}

