/*
 * Decompiled with CFR 0.152.
 */
package resid_builder.resid.resample;

import resid_builder.resid.resample.Resampler;

public class ZeroOrderResampler
implements Resampler {
    private int cachedSample;
    private final int cyclesPerSample;
    private int sampleOffset;
    private int output;

    public ZeroOrderResampler(double clockFrequency, double samplingFrequency) {
        this.cyclesPerSample = (int)(clockFrequency / samplingFrequency * 1024.0);
    }

    @Override
    public boolean input(int sample) {
        boolean ready = false;
        if (this.sampleOffset < 1024) {
            this.output = this.cachedSample + (this.sampleOffset * (sample - this.cachedSample) >> 10);
            ready = true;
            this.sampleOffset += this.cyclesPerSample;
        }
        this.sampleOffset -= 1024;
        this.cachedSample = sample;
        return ready;
    }

    @Override
    public int output() {
        return this.output;
    }

    @Override
    public void reset() {
        this.sampleOffset = 0;
        this.cachedSample = 0;
    }
}

