/*
 * Decompiled with CFR 0.152.
 */
package resid_builder.resid;

import java.util.HashMap;
import java.util.Map;
import resid_builder.resid.ISIDDefs;

public final class WaveformCalculator {
    private static Map<CombinedWaveformConfig[], short[][]> CACHE = new HashMap<CombinedWaveformConfig[], short[][]>();
    private static final CombinedWaveformConfig[][] config = new CombinedWaveformConfig[][]{{new CombinedWaveformConfig(0.880815f, 0.0f, 0.0f, 0.3279614f, 0.5999545f), new CombinedWaveformConfig(0.8924618f, 2.014781f, 1.003332f, 0.02992322f, 0.0f), new CombinedWaveformConfig(0.8646501f, 1.712586f, 1.137704f, 0.02845423f, 0.0f), new CombinedWaveformConfig(0.9527834f, 1.794777f, 0.0f, 0.09806272f, 0.7752482f)}, {new CombinedWaveformConfig(0.9781665f, 0.0f, 0.9899469f, 8.087667f, 0.8226412f), new CombinedWaveformConfig(0.9097769f, 2.039997f, 0.9584096f, 0.1765447f, 0.0f), new CombinedWaveformConfig(0.9231212f, 2.084788f, 0.9493895f, 0.1712518f, 0.0f), new CombinedWaveformConfig(0.9845552f, 1.415612f, 0.9703883f, 3.68829f, 0.8265008f)}};

    protected static short[][] buildTable(ISIDDefs.ChipModel model) {
        CombinedWaveformConfig[] cfgArray = config[model == ISIDDefs.ChipModel.MOS6581 ? 0 : 1];
        if (!CACHE.containsKey(cfgArray)) {
            short[][] wftable = new short[8][4096];
            for (int accumulator = 0; accumulator < 0x1000000; accumulator += 4096) {
                int idx = accumulator >> 12;
                wftable[0][idx] = 4095;
                wftable[1][idx] = (short)((accumulator & 0x800000) == 0 ? idx << 1 : (idx ^ 0xFFF) << 1);
                wftable[2][idx] = (short)idx;
                wftable[3][idx] = WaveformCalculator.calculateCombinedWaveform(cfgArray[0], 3, accumulator);
                wftable[4][idx] = 4095;
                wftable[5][idx] = WaveformCalculator.calculateCombinedWaveform(cfgArray[1], 5, accumulator);
                wftable[6][idx] = WaveformCalculator.calculateCombinedWaveform(cfgArray[2], 6, accumulator);
                wftable[7][idx] = WaveformCalculator.calculateCombinedWaveform(cfgArray[3], 7, accumulator);
            }
            CACHE.put(cfgArray, wftable);
        }
        return CACHE.get(cfgArray);
    }

    private static short calculateCombinedWaveform(CombinedWaveformConfig config, int waveform, int accumulator) {
        int i;
        int i2;
        float[] o = new float[12];
        for (i2 = 0; i2 < 12; ++i2) {
            o[i2] = (accumulator >> 12 & 1 << i2) != 0 ? 1.0f : 0.0f;
        }
        if ((waveform & 3) == 1) {
            boolean top = (accumulator & 0x800000) != 0;
            for (i = 11; i > 0; --i) {
                o[i] = top ? 1.0f - o[i - 1] : o[i - 1];
            }
            o[0] = 0.0f;
        }
        if ((waveform & 3) == 3) {
            o[0] = o[0] * config.stmix;
            for (i2 = 1; i2 < 12; ++i2) {
                o[i2] = o[i2 - 1] * (1.0f - config.stmix) + o[i2] * config.stmix;
            }
        }
        o[11] = o[11] * config.topbit;
        if (waveform == 3 || waveform > 4) {
            int i3;
            float[] distancetable = new float[25];
            for (i = 0; i <= 12; ++i) {
                float f = 1.0f / (1.0f + (float)(i * i) * config.distance);
                distancetable[12 - i] = f;
                distancetable[12 + i] = f;
            }
            float[] tmp = new float[12];
            for (i3 = 0; i3 < 12; ++i3) {
                float avg = 0.0f;
                float n = 0.0f;
                for (int j = 0; j < 12; ++j) {
                    float weight = distancetable[i3 - j + 12];
                    avg += o[j] * weight;
                    n += weight;
                }
                if (waveform > 4) {
                    float weight = distancetable[i3 - 12 + 12];
                    avg += config.pulsestrength * weight;
                    n += weight;
                }
                tmp[i3] = (o[i3] + avg / n) * 0.5f;
            }
            for (i3 = 0; i3 < 12; ++i3) {
                o[i3] = tmp[i3];
            }
        }
        short value = 0;
        for (i = 0; i < 12; ++i) {
            if (!(o[i] - config.bias > 0.0f)) continue;
            value = (short)(value | 1 << i);
        }
        return value;
    }

    protected static class CombinedWaveformConfig {
        protected float bias;
        protected float pulsestrength;
        protected float topbit;
        protected float distance;
        protected float stmix;

        protected CombinedWaveformConfig(float f, float g, float h, float i, float j) {
            this.bias = f;
            this.pulsestrength = g;
            this.topbit = h;
            this.distance = i;
            this.stmix = j;
        }
    }
}

