/*
 * Decompiled with CFR 0.152.
 */
package resid_builder.resid;

import resid_builder.resid.ExternalFilter;
import resid_builder.resid.Filter;
import resid_builder.resid.Filter6581;
import resid_builder.resid.Filter8580;
import resid_builder.resid.ISIDDefs;
import resid_builder.resid.Potentiometer;
import resid_builder.resid.Voice;
import resid_builder.resid.WaveformCalculator;
import resid_builder.resid.resample.Resampler;
import resid_builder.resid.resample.TwoPassSincResampler;
import resid_builder.resid.resample.ZeroOrderResampler;

public final class SID {
    private static final int BUS_TTL = 36864;
    public final Voice[] voice = new Voice[]{new Voice(), new Voice(), new Voice()};
    private Filter filter;
    private final Filter6581 filter6581 = new Filter6581();
    private final Filter8580 filter8580 = new Filter8580();
    private final ExternalFilter externalFilter = new ExternalFilter();
    private final Potentiometer potX = new Potentiometer();
    private final Potentiometer potY = new Potentiometer();
    private byte busValue;
    private int busValueTtl;
    private ISIDDefs.ChipModel model;
    private int nextVoiceSync;
    private Resampler resampler;
    private int delayedOffset;
    private byte delayedValue;
    private final boolean[] muted = new boolean[3];

    public static void kinkedDac(double[] dac, double _2R_div_R, boolean term) {
        int i;
        double INFINITY = 1000000.0;
        for (int set_bit = 0; set_bit < dac.length; ++set_bit) {
            int bit;
            double Vn = 1.0;
            double R = 1.0;
            double _2R = _2R_div_R * R;
            double Rn = term ? _2R : 1000000.0;
            for (bit = 0; bit < set_bit; ++bit) {
                Rn = Rn == 1000000.0 ? R + _2R : R + _2R * Rn / (_2R + Rn);
            }
            if (Rn == 1000000.0) {
                Rn = _2R;
            } else {
                Rn = _2R * Rn / (_2R + Rn);
                Vn = Vn * Rn / _2R;
            }
            ++bit;
            while (bit < dac.length) {
                double I = Vn / (Rn += R);
                Rn = _2R * Rn / (_2R + Rn);
                Vn = Rn * I;
                ++bit;
            }
            dac[set_bit] = Vn;
        }
        double Vsum = 0.0;
        for (i = 0; i < dac.length; ++i) {
            Vsum += dac[i];
        }
        Vsum /= (double)(1 << dac.length);
        i = 0;
        while (i < dac.length) {
            int n = i++;
            dac[n] = dac[n] / Vsum;
        }
    }

    public SID() {
        this.reset();
        this.setChipModel(ISIDDefs.ChipModel.MOS8580);
    }

    public void setChipModel(ISIDDefs.ChipModel model) {
        this.model = model;
        if (model == ISIDDefs.ChipModel.MOS6581) {
            this.filter = this.filter6581;
        } else if (model == ISIDDefs.ChipModel.MOS8580) {
            this.filter = this.filter8580;
        } else {
            throw new RuntimeException("Don't know how to handle chip type " + (Object)((Object)model));
        }
        short[][] tables = WaveformCalculator.buildTable(model);
        for (int i = 0; i < 3; ++i) {
            this.voice[i].envelope.setChipModel(model);
            this.voice[i].wave.setChipModel(model);
            this.voice[i].wave.setWaveformModels(tables);
        }
    }

    public ISIDDefs.ChipModel getChipModel() {
        return this.model;
    }

    public void reset() {
        for (int i = 0; i < 3; ++i) {
            this.voice[i].reset();
        }
        this.filter6581.reset();
        this.filter8580.reset();
        this.externalFilter.reset();
        if (this.resampler != null) {
            this.resampler.reset();
        }
        this.busValue = 0;
        this.busValueTtl = 0;
        this.delayedOffset = -1;
        this.voiceSync(false);
    }

    public void input(int value) {
        this.filter6581.input(value);
        this.filter8580.input(value);
    }

    public byte read(int offset) {
        byte value;
        switch (offset) {
            case 25: {
                value = this.potX.readPOT();
                this.busValueTtl = 36864;
                break;
            }
            case 26: {
                value = this.potY.readPOT();
                this.busValueTtl = 36864;
                break;
            }
            case 27: {
                value = this.voice[2].wave.readOSC();
                break;
            }
            case 28: {
                value = this.voice[2].envelope.readENV();
                this.busValueTtl = 36864;
                break;
            }
            default: {
                value = this.busValue;
                this.busValueTtl /= 2;
            }
        }
        this.busValue = value;
        return value;
    }

    public void write(int offset, byte value) {
        this.busValue = value;
        this.busValueTtl = 36864;
        if (this.model == ISIDDefs.ChipModel.MOS8580) {
            this.delayedOffset = offset;
            this.delayedValue = value;
        } else {
            this.writeImmediate(offset, value);
        }
    }

    private void writeImmediate(int offset, byte value) {
        switch (offset) {
            case 0: {
                this.voice[0].wave.writeFREQ_LO(value);
                break;
            }
            case 1: {
                this.voice[0].wave.writeFREQ_HI(value);
                break;
            }
            case 2: {
                this.voice[0].wave.writePW_LO(value);
                break;
            }
            case 3: {
                this.voice[0].wave.writePW_HI(value);
                break;
            }
            case 4: {
                this.voice[0].writeCONTROL_REG(this.muted[0] ? (byte)0 : value);
                break;
            }
            case 5: {
                this.voice[0].envelope.writeATTACK_DECAY(value);
                break;
            }
            case 6: {
                this.voice[0].envelope.writeSUSTAIN_RELEASE(value);
                break;
            }
            case 7: {
                this.voice[1].wave.writeFREQ_LO(value);
                break;
            }
            case 8: {
                this.voice[1].wave.writeFREQ_HI(value);
                break;
            }
            case 9: {
                this.voice[1].wave.writePW_LO(value);
                break;
            }
            case 10: {
                this.voice[1].wave.writePW_HI(value);
                break;
            }
            case 11: {
                this.voice[1].writeCONTROL_REG(this.muted[1] ? (byte)0 : value);
                break;
            }
            case 12: {
                this.voice[1].envelope.writeATTACK_DECAY(value);
                break;
            }
            case 13: {
                this.voice[1].envelope.writeSUSTAIN_RELEASE(value);
                break;
            }
            case 14: {
                this.voice[2].wave.writeFREQ_LO(value);
                break;
            }
            case 15: {
                this.voice[2].wave.writeFREQ_HI(value);
                break;
            }
            case 16: {
                this.voice[2].wave.writePW_LO(value);
                break;
            }
            case 17: {
                this.voice[2].wave.writePW_HI(value);
                break;
            }
            case 18: {
                this.voice[2].writeCONTROL_REG(this.muted[2] ? (byte)0 : value);
                break;
            }
            case 19: {
                this.voice[2].envelope.writeATTACK_DECAY(value);
                break;
            }
            case 20: {
                this.voice[2].envelope.writeSUSTAIN_RELEASE(value);
                break;
            }
            case 21: {
                this.filter6581.writeFC_LO(value);
                this.filter8580.writeFC_LO(value);
                break;
            }
            case 22: {
                this.filter6581.writeFC_HI(value);
                this.filter8580.writeFC_HI(value);
                break;
            }
            case 23: {
                this.filter6581.writeRES_FILT(value);
                this.filter8580.writeRES_FILT(value);
                break;
            }
            case 24: {
                this.filter6581.writeMODE_VOL(value);
                this.filter8580.writeMODE_VOL(value);
                break;
            }
        }
        this.voiceSync(false);
    }

    public void mute(int channel, boolean enable) {
        this.muted[channel] = enable;
    }

    public void setSamplingParameters(double clockFrequency, ISIDDefs.SamplingMethod method, double samplingFrequency, double highestAccurateFrequency) {
        this.filter6581.setClockFrequency(clockFrequency);
        this.filter8580.setClockFrequency(clockFrequency);
        this.externalFilter.setClockFrequency(clockFrequency);
        switch (method) {
            case DECIMATE: {
                this.resampler = new ZeroOrderResampler(clockFrequency, samplingFrequency);
                break;
            }
            case RESAMPLE: {
                this.resampler = new TwoPassSincResampler(clockFrequency, samplingFrequency, highestAccurateFrequency);
                break;
            }
            default: {
                throw new RuntimeException("Unknown samplingmethod: " + (Object)((Object)method));
            }
        }
    }

    private void ageBusValue(int n) {
        if (this.busValueTtl != 0) {
            this.busValueTtl -= n;
            if (this.busValueTtl <= 0) {
                this.busValue = 0;
                this.busValueTtl = 0;
            }
        }
    }

    private int output() {
        return this.externalFilter.clock(this.filter.clock(this.voice[0].output(this.voice[2].wave), this.voice[1].output(this.voice[0].wave), this.voice[2].output(this.voice[1].wave)));
    }

    public final int clock(int cycles, int[] buf, int pos) {
        this.ageBusValue(cycles);
        int s = 0;
        while (cycles != 0) {
            int delta_t = Math.min(this.nextVoiceSync, cycles);
            if (delta_t > 0) {
                if (this.delayedOffset != -1) {
                    delta_t = 1;
                }
                for (int i = 0; i < delta_t; ++i) {
                    if (this.resampler.input(this.output())) {
                        buf[pos + s] = this.resampler.output();
                        ++s;
                    }
                    this.voice[0].wave.clock();
                    this.voice[1].wave.clock();
                    this.voice[2].wave.clock();
                    this.voice[0].envelope.clock();
                    this.voice[1].envelope.clock();
                    this.voice[2].envelope.clock();
                }
                if (this.delayedOffset != -1) {
                    this.writeImmediate(this.delayedOffset, this.delayedValue);
                    this.delayedOffset = -1;
                }
                cycles -= delta_t;
                this.nextVoiceSync -= delta_t;
            }
            if (this.nextVoiceSync != 0) continue;
            this.voiceSync(true);
        }
        return s;
    }

    public void clockSilent(int cycles) {
        this.ageBusValue(cycles);
        while (cycles != 0) {
            int delta_t = Math.min(this.nextVoiceSync, cycles);
            if (delta_t > 0) {
                if (this.delayedOffset != -1) {
                    delta_t = 1;
                }
                for (int i = 0; i < delta_t; ++i) {
                    this.voice[0].wave.clock();
                    this.voice[1].wave.clock();
                    this.voice[2].wave.clock();
                    this.voice[2].envelope.clock();
                }
                if (this.delayedOffset != -1) {
                    this.writeImmediate(this.delayedOffset, this.delayedValue);
                    this.delayedOffset = -1;
                }
                cycles -= delta_t;
                this.nextVoiceSync -= delta_t;
            }
            if (this.nextVoiceSync != 0) continue;
            this.voiceSync(true);
        }
    }

    private void voiceSync(boolean sync) {
        int i;
        if (sync) {
            for (i = 0; i < 3; ++i) {
                this.voice[i].wave.synchronize(this.voice[(i + 1) % 3].wave, this.voice[(i + 2) % 3].wave);
            }
        }
        this.nextVoiceSync = Integer.MAX_VALUE;
        for (i = 0; i < 3; ++i) {
            int thisVoiceSync;
            int accumulator = this.voice[i].wave.accumulator;
            int freq = this.voice[i].wave.freq;
            if (this.voice[i].wave.test || freq == 0 || !this.voice[(i + 1) % 3].wave.sync || (thisVoiceSync = (0x7FFFFF - accumulator & 0xFFFFFF) / freq + 1) >= this.nextVoiceSync) continue;
            this.nextVoiceSync = thisVoiceSync;
        }
    }

    public Filter6581 getFilter6581() {
        return this.filter6581;
    }

    public Filter8580 getFilter8580() {
        return this.filter8580;
    }
}

