/*
 * Decompiled with CFR 0.152.
 */
package resid_builder.resid;

public abstract class Filter {
    private boolean enabled = true;
    protected int fc;
    protected int res;
    private byte filt;
    protected boolean filt1;
    protected boolean filt2;
    protected boolean filt3;
    protected boolean filtE;
    protected boolean voice3off;
    protected boolean hp;
    protected boolean bp;
    protected boolean lp;
    protected int vol;
    protected double clockFrequency;

    protected abstract int clock(int var1, int var2, int var3);

    public void enable(boolean enable) {
        this.enabled = enable;
        if (this.enabled) {
            this.writeRES_FILT(this.filt);
        } else {
            this.filtE = false;
            this.filt3 = false;
            this.filt2 = false;
            this.filt1 = false;
            this.hp = false;
            this.bp = false;
            this.lp = false;
        }
    }

    protected void setClockFrequency(double clock) {
        this.clockFrequency = clock;
        this.updatedCenterFrequency();
    }

    protected final void reset() {
        this.writeFC_LO((byte)0);
        this.writeFC_HI((byte)0);
        this.writeMODE_VOL((byte)0);
        this.writeRES_FILT((byte)0);
    }

    protected final void writeFC_LO(byte fc_lo) {
        this.fc = this.fc & 0x7F8 | fc_lo & 7;
        this.updatedCenterFrequency();
    }

    protected final void writeFC_HI(byte fc_hi) {
        this.fc = fc_hi << 3 & 0x7F8 | this.fc & 7;
        this.updatedCenterFrequency();
    }

    protected final void writeRES_FILT(byte res_filt) {
        this.filt = res_filt;
        this.res = res_filt >> 4 & 0xF;
        this.updatedResonance();
        if (this.enabled) {
            this.filt1 = (this.filt & 1) != 0;
            this.filt2 = (this.filt & 2) != 0;
            this.filt3 = (this.filt & 4) != 0;
            this.filtE = (this.filt & 8) != 0;
        }
        this.updatedMixing();
    }

    protected final void writeMODE_VOL(byte mode_vol) {
        this.vol = mode_vol & 0xF;
        this.lp = (mode_vol & 0x10) != 0;
        this.bp = (mode_vol & 0x20) != 0;
        this.hp = (mode_vol & 0x40) != 0;
        this.voice3off = (mode_vol & 0x80) != 0;
        this.updatedMixing();
    }

    protected abstract void updatedCenterFrequency();

    protected abstract void updatedResonance();

    protected abstract void updatedMixing();

    protected abstract void input(int var1);
}

