/*
 * Decompiled with CFR 0.152.
 */
package resid_builder.resid;

import resid_builder.resid.ISIDDefs;
import resid_builder.resid.SID;

public final class EnvelopeGenerator {
    private boolean hold_zero;
    private boolean envelope_pipeline;
    private int rate_counter;
    private int rate_period;
    private int exponential_counter;
    private int exponential_counter_period;
    private byte envelope_counter;
    private int attack;
    private int decay;
    private int sustain;
    private int release;
    private boolean gate;
    private State state;
    private static final int[] ENVELOPE_PERIOD = new int[]{9, 32, 63, 95, 149, 220, 267, 313, 392, 977, 1954, 3126, 3907, 11720, 19532, 31251};
    private final short[] dac = new short[256];

    protected void setChipModel(ISIDDefs.ChipModel chipModel) {
        double[] dacBits = new double[8];
        SID.kinkedDac(dacBits, chipModel == ISIDDefs.ChipModel.MOS6581 ? 2.3 : 2.0, chipModel == ISIDDefs.ChipModel.MOS8580);
        for (int i = 0; i < 256; ++i) {
            double dacValue = 0.0;
            for (int j = 0; j < 8; ++j) {
                if ((i & 1 << j) == 0) continue;
                dacValue += dacBits[j];
            }
            this.dac[i] = (short)(dacValue + 0.5);
        }
    }

    protected void clock() {
        if (this.envelope_pipeline) {
            this.envelope_counter = (byte)(this.envelope_counter - 1);
            this.envelope_pipeline = false;
            this.set_exponential_counter();
        }
        if ((++this.rate_counter & 0x8000) != 0) {
            this.rate_counter = this.rate_counter + 1 & Short.MAX_VALUE;
        }
        if (this.rate_counter != this.rate_period) {
            return;
        }
        this.rate_counter = 0;
        if (this.state == State.ATTACK || ++this.exponential_counter == this.exponential_counter_period) {
            this.exponential_counter = 0;
            if (this.hold_zero) {
                return;
            }
            switch (this.state) {
                case ATTACK: {
                    this.envelope_counter = (byte)(this.envelope_counter + 1);
                    if (this.envelope_counter != -1) break;
                    this.state = State.DECAY_SUSTAIN;
                    this.rate_period = ENVELOPE_PERIOD[this.decay];
                    break;
                }
                case DECAY_SUSTAIN: {
                    if (this.envelope_counter == (byte)(this.sustain << 4 | this.sustain)) {
                        return;
                    }
                    if (this.exponential_counter_period != 1) {
                        this.envelope_pipeline = true;
                        return;
                    }
                    this.envelope_counter = (byte)(this.envelope_counter - 1);
                    break;
                }
                case RELEASE: {
                    if (this.exponential_counter_period != 1) {
                        this.envelope_pipeline = true;
                        return;
                    }
                    this.envelope_counter = (byte)(this.envelope_counter - 1);
                }
            }
            this.set_exponential_counter();
        }
    }

    protected int output() {
        return this.dac[this.envelope_counter & 0xFF];
    }

    private void set_exponential_counter() {
        switch (this.envelope_counter) {
            case -1: {
                this.exponential_counter_period = 1;
                break;
            }
            case 93: {
                this.exponential_counter_period = 2;
                break;
            }
            case 54: {
                this.exponential_counter_period = 4;
                break;
            }
            case 26: {
                this.exponential_counter_period = 8;
                break;
            }
            case 14: {
                this.exponential_counter_period = 16;
                break;
            }
            case 6: {
                this.exponential_counter_period = 30;
                break;
            }
            case 0: {
                this.exponential_counter_period = 1;
                this.hold_zero = true;
            }
        }
    }

    protected EnvelopeGenerator() {
    }

    protected void reset() {
        this.envelope_counter = 0;
        this.envelope_pipeline = false;
        this.attack = 0;
        this.decay = 0;
        this.sustain = 0;
        this.release = 0;
        this.gate = false;
        this.rate_counter = 0;
        this.exponential_counter = 0;
        this.exponential_counter_period = 1;
        this.state = State.RELEASE;
        this.rate_period = ENVELOPE_PERIOD[this.release];
        this.hold_zero = true;
    }

    protected void writeCONTROL_REG(byte control) {
        boolean gate_next;
        boolean bl = gate_next = (control & 1) != 0;
        if (!this.gate && gate_next) {
            this.state = State.ATTACK;
            this.rate_period = ENVELOPE_PERIOD[this.attack];
            this.hold_zero = false;
            this.envelope_pipeline = false;
        } else if (this.gate && !gate_next) {
            this.state = State.RELEASE;
            this.rate_period = ENVELOPE_PERIOD[this.release];
        }
        this.gate = gate_next;
    }

    protected void writeATTACK_DECAY(byte attack_decay) {
        this.attack = attack_decay >> 4 & 0xF;
        this.decay = attack_decay & 0xF;
        if (this.state == State.ATTACK) {
            this.rate_period = ENVELOPE_PERIOD[this.attack];
        } else if (this.state == State.DECAY_SUSTAIN) {
            this.rate_period = ENVELOPE_PERIOD[this.decay];
        }
    }

    protected void writeSUSTAIN_RELEASE(byte sustain_release) {
        this.sustain = sustain_release >> 4 & 0xF;
        this.release = sustain_release & 0xF;
        if (this.state == State.RELEASE) {
            this.rate_period = ENVELOPE_PERIOD[this.release];
        }
    }

    public byte readENV() {
        return this.envelope_counter;
    }

    private static enum State {
        ATTACK,
        DECAY_SUSTAIN,
        RELEASE;

    }
}

