/*
 * Decompiled with CFR 0.152.
 */
package resid_builder;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.common.SIDBuilder;
import libsidplay.common.SIDEmu;
import resid_builder.ReSID;
import resid_builder.resid.ISIDDefs;
import sidplay.audio.AudioConfig;
import sidplay.audio.AudioDriver;

public class ReSIDBuilder
extends SIDBuilder {
    final AudioConfig audioConfig;
    protected AudioDriver output;
    protected List<ReSID> sids = new ArrayList<ReSID>();
    private final MixerEvent mixerEvent = new MixerEvent();
    private final double systemFrequency;

    public ReSIDBuilder(AudioConfig audioConfig, double systemFrequency) {
        this.audioConfig = audioConfig;
        this.systemFrequency = systemFrequency;
    }

    @Override
    public SIDEmu lock(EventScheduler env, ISIDDefs.ChipModel model) {
        ReSID sid = new ReSID(env, this.mixerEvent);
        sid.model(model);
        sid.sampling(this.systemFrequency, this.audioConfig.getFrameRate(), this.audioConfig.getSamplingMethod());
        this.sids.add(sid);
        return sid;
    }

    @Override
    public void unlock(SIDEmu sid) {
        this.sids.remove(sid);
    }

    public void setSIDVolume(int i, float volume) {
        this.mixerEvent.setVolume(i, volume);
    }

    public void setOutput(AudioDriver driver) {
        this.output = driver;
    }

    protected class MixerEvent
    extends Event {
        private final Random RANDOM;
        private int oldRandomValue;
        private final int[] volume;
        private EventScheduler context;

        protected void setVolume(int i, float v) {
            this.volume[i] = (int)(v * 1024.0f);
        }

        private int triangularDithering() {
            int prevValue = this.oldRandomValue;
            this.oldRandomValue = this.RANDOM.nextInt() & 0x3FF;
            return this.oldRandomValue - prevValue;
        }

        protected MixerEvent() {
            super("Mixer");
            this.RANDOM = new Random();
            this.volume = new int[]{1024, 1024};
        }

        @Override
        public void event() throws InterruptedException {
            ReSID chip1 = ReSIDBuilder.this.sids.get(0);
            ReSID chip2 = ReSIDBuilder.this.sids.size() >= 2 ? ReSIDBuilder.this.sids.get(1) : null;
            chip1.clock();
            int[] buf1 = chip1.getBuffer();
            int[] buf2 = null;
            if (chip2 != null) {
                chip2.clock();
                buf2 = chip2.getBuffer();
            }
            int samples = chip1.getPosition();
            ByteBuffer soundBuffer = ReSIDBuilder.this.output.buffer();
            for (int i = 0; i < samples; ++i) {
                int dither = this.triangularDithering();
                int value = buf1[i] * this.volume[0] + dither >> 10;
                if (value > Short.MAX_VALUE) {
                    value = Short.MAX_VALUE;
                }
                if (value < Short.MIN_VALUE) {
                    value = Short.MIN_VALUE;
                }
                soundBuffer.putShort((short)value);
                if (buf2 != null) {
                    value = buf2[i] * this.volume[1] + dither >> 10;
                    if (value > Short.MAX_VALUE) {
                        value = Short.MAX_VALUE;
                    }
                    if (value < Short.MIN_VALUE) {
                        value = Short.MIN_VALUE;
                    }
                    soundBuffer.putShort((short)value);
                }
                if (soundBuffer.remaining() != 0) continue;
                ReSIDBuilder.this.output.write();
                soundBuffer.clear();
            }
            chip1.setPosition(0);
            if (chip2 != null) {
                chip2.setPosition(0);
            }
            this.context.schedule(this, 10000L);
        }

        public void setContext(EventScheduler env) {
            this.context = env;
        }
    }
}

