/*
 * Decompiled with CFR 0.152.
 */
package resid_builder;

import java.util.logging.Level;
import java.util.logging.Logger;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.common.SIDEmu;
import resid_builder.ReSIDBuilder;
import resid_builder.resid.ISIDDefs;
import resid_builder.resid.SID;
import sidplay.ini.IniFilterSection;

public class ReSID
extends SIDEmu {
    private static final Logger RESID = Logger.getLogger(ReSID.class.getName());
    private static final String VERSION = "0.0.2";
    private static final int OUTPUTBUFFERSIZE = 5000;
    private final SID sid = new SID();
    protected int position;
    protected int[] buffer;
    private final ReSIDBuilder.MixerEvent mixerEvent;

    public ReSID(EventScheduler context, ReSIDBuilder.MixerEvent mixerEvent) {
        super(context);
        this.mixerEvent = mixerEvent;
        this.buffer = new int[5000];
        this.position = 0;
        this.reset((byte)0);
    }

    @Override
    public void reset(byte volume) {
        this.clocksSinceLastAccess();
        this.sid.reset();
        this.sid.write(24, volume);
        this.context.cancel(this.mixerEvent);
        this.mixerEvent.setContext(this.context);
        this.context.schedule(this.mixerEvent, 0L, Event.Phase.PHI2);
    }

    @Override
    public byte read(int addr) {
        --this.lastTime;
        this.clock();
        return this.sid.read(addr &= 0x1F);
    }

    @Override
    public void write(int addr, byte data) {
        super.write(addr &= 0x1F, data);
        if (RESID.isLoggable(Level.FINE)) {
            RESID.fine(String.format("write 0x%02x=0x%02x", addr, data));
        }
        this.clock();
        this.sid.write(addr, data);
    }

    @Override
    public void clock() {
        int cycles = this.clocksSinceLastAccess();
        this.position += this.sid.clock(cycles, this.buffer, this.position);
    }

    @Override
    public void setFilter(boolean enable) {
        this.sid.getFilter6581().enable(enable);
        this.sid.getFilter8580().enable(enable);
    }

    public void filter(IniFilterSection filter6581, IniFilterSection filter8580) {
        if (filter6581 != null) {
            this.sid.getFilter6581().setFilterCurve(filter6581.getFilter6581CurvePosition());
        }
        if (filter8580 != null) {
            this.sid.getFilter8580().setFilterCurve(filter8580.getFilter8580CurvePosition());
        }
    }

    @Override
    public void setEnabled(int num, boolean mute) {
        this.sid.mute(num, mute);
    }

    public void sampling(double systemclock, float freq, ISIDDefs.SamplingMethod method) {
        this.sid.setSamplingParameters(systemclock, method, freq, 20000.0);
    }

    public void model(ISIDDefs.ChipModel model) {
        this.sid.setChipModel(model);
    }

    public static final String credits() {
        String m_credit = "ReSID V0.0.2 Engine:\n";
        m_credit = m_credit + "\tCopyright (C) 1999-2002 Simon White <sidplay2@yahoo.com>\n";
        m_credit = m_credit + "MOS6581/8580 (SID) Emulation:\n";
        m_credit = m_credit + "\tCopyright (C) 1999-2004 Dag Lem <resid@nimrod.no>\n";
        m_credit = m_credit + "\tCopyright (C) 2005-2011 Antti S. Lankila <alankila@bel.fi>\n";
        return m_credit;
    }

    public SID sid() {
        return this.sid;
    }

    @Override
    public ISIDDefs.ChipModel getChipModel() {
        return this.sid.getChipModel();
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int[] getBuffer() {
        return this.buffer;
    }
}

