/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.zip;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import libsidutils.zip.ZipEntryFileProxy;

public class ZipFileProxy
extends File {
    protected Map<String, HashMap<String, String>> hash;
    private ZipFile zipfile;

    public ZipFileProxy(File file) {
        super(file.getAbsolutePath());
        try {
            this.hash = new HashMap<String, HashMap<String, String>>();
            this.zipfile = new ZipFile(file, 1);
            this.hash.put("", new HashMap());
            Enumeration<? extends ZipEntry> en = this.zipfile.entries();
            this.parse(en);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public File[] listFiles() {
        return this.listFiles((FileFilter)null);
    }

    @Override
    public File[] listFiles(FileFilter filter) {
        return this.getFileChildren("");
    }

    private void parse(Enumeration en) {
        while (en.hasMoreElements()) {
            try {
                Map parentChildren;
                ZipEntry ze = (ZipEntry)en.nextElement();
                String fullName = ze.getName();
                String parent = "";
                File f = new File(fullName);
                if (f.getParent() != null) {
                    parent = f.getParent().replace('\\', '/') + "/";
                }
                if (ze.isDirectory() && this.hash.get(fullName) == null) {
                    HashMap children = new HashMap();
                    this.hash.put(fullName, children);
                }
                if ((parentChildren = (Map)this.hash.get(parent)) == null) {
                    HashMap<String, String> children = new HashMap<String, String>();
                    children.put(fullName, "");
                    this.hash.put(parent, children);
                    continue;
                }
                parentChildren.put(fullName, "");
            }
            catch (IllegalArgumentException e) {
                System.err.println(e.getMessage());
            }
        }
    }

    public final File[] getFileChildren(String parentPath) {
        Map children = this.hash.get(parentPath);
        if (children == null) {
            return new File[0];
        }
        File[] files = new File[children.size()];
        Iterator it = children.keySet().iterator();
        int count = 0;
        while (it.hasNext()) {
            String name = (String)it.next();
            files[count] = new ZipEntryFileProxy(this, this.zipfile, name, this);
            ++count;
        }
        return files;
    }
}

