/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.zip;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import libsidutils.zip.ZipFileProxy;

public class ZipEntryFileProxy
extends File {
    ZipFileProxy zip;
    ZipFile zipfile;
    String name;
    String path;
    File parent;
    ZipEntry entry;

    public ZipEntryFileProxy(ZipEntryFileProxy zipEntry, String path, File parent) {
        this(zipEntry.zip, zipEntry.zipfile, path, parent);
    }

    public ZipEntryFileProxy(ZipFileProxy zip, ZipFile zipfile, String path, File parent) {
        super("");
        this.zip = zip;
        this.zipfile = zipfile;
        this.path = path;
        this.parent = parent;
        this.entry = zipfile.getEntry(path);
        String tmp = path;
        if (this.entry.isDirectory()) {
            tmp = path.substring(0, path.length() - 1);
        }
        int brk = tmp.lastIndexOf("/");
        this.name = path;
        if (brk != -1) {
            this.name = tmp.substring(brk + 1);
        }
    }

    @Override
    public long length() {
        return this.entry.getSize();
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode() ^ 0x12D591;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public boolean isDirectory() {
        return this.entry.isDirectory();
    }

    @Override
    public boolean isFile() {
        return !this.entry.isDirectory();
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    @Override
    public String getAbsolutePath() {
        return this.path;
    }

    @Override
    public File getAbsoluteFile() {
        return this;
    }

    @Override
    public File getCanonicalFile() {
        return this;
    }

    @Override
    public File getParentFile() {
        return this.parent;
    }

    @Override
    public boolean equals(Object obj) {
        ZipEntryFileProxy zo;
        return obj instanceof ZipEntryFileProxy && (zo = (ZipEntryFileProxy)obj).getAbsolutePath().equals(this.getAbsolutePath());
    }

    @Override
    public File[] listFiles() {
        return this.listFiles((FileFilter)null);
    }

    @Override
    public File[] listFiles(FileFilter filter) {
        if (this.zip.hash.get(this.path) == null) {
            return new File[0];
        }
        Map children = this.zip.hash.get(this.path);
        ArrayList<ZipEntryFileProxy> files = new ArrayList<ZipEntryFileProxy>();
        for (final String name : children.keySet()) {
            if (filter != null && !filter.accept(new File(name){

                @Override
                public boolean isDirectory() {
                    return name.endsWith("/");
                }

                @Override
                public String getName() {
                    return name;
                }
            })) continue;
            files.add(new ZipEntryFileProxy(this.zip, this.zipfile, name, this));
        }
        return files.toArray(new File[files.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final File extractFromZip(ZipEntryFileProxy zipEntry) throws IOException {
        String newName = zipEntry.getName();
        File tmpFile = null;
        InputStream is = null;
        OutputStream os = null;
        try {
            tmpFile = new File(System.getProperty("jsidplay2.tmpdir"), newName);
            tmpFile.deleteOnExit();
            is = zipEntry.getInputStream();
            os = new FileOutputStream(tmpFile);
            byte[] b = new byte[1024];
            while (is.available() > 0) {
                int len = is.read(b);
                if (len <= 0) continue;
                os.write(b, 0, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
        return tmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final File extractFromGZ(File file) throws IOException {
        String newName = file.getName().substring(0, file.getName().length() - 3);
        File tmpFile = null;
        InputStream is = null;
        OutputStream os = null;
        try {
            tmpFile = new File(System.getProperty("jsidplay2.tmpdir"), newName);
            tmpFile.deleteOnExit();
            is = new GZIPInputStream(new FileInputStream(file));
            os = new FileOutputStream(tmpFile);
            byte[] b = new byte[1024];
            while (is.available() > 0) {
                int len = is.read(b);
                if (len <= 0) continue;
                os.write(b, 0, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
        return tmpFile;
    }

    public InputStream getInputStream() throws IOException {
        return this.zipfile.getInputStream(this.entry);
    }

    public ZipFileProxy getZip() {
        return this.zip;
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

