/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.pucrunch;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import libsidutils.pucrunch.FixStruct;
import libsidutils.pucrunch.FixType;
import libsidutils.pucrunch.IHeader;

public class PUCrunch
implements IHeader {
    private static final boolean DELTA = true;
    private boolean BIG = false;
    private static final boolean ENABLE_VERBOSE = true;
    private static final boolean HASH_STAT = true;
    private static final boolean BACKSKIP_FULL = true;
    private static final boolean RESCAN = true;
    private static final boolean HASH_COMPARE = true;
    public static final String version = "\u0000$VER: pucrunch 1.14 22-Nov-2008\n";
    private int maxGamma = 7;
    private int reservedBytes = 2;
    private int escBits = 2;
    private int escMask = 192;
    private int extraLZPosBits = 0;
    private int rleUsed = 15;
    int memConfig = 55;
    int intConfig = 88;
    private static final int F_VERBOSE = 1;
    private static final int F_STATS = 2;
    private static final int F_AUTO = 4;
    private static final int F_NOOPT = 8;
    private static final int F_AUTOEX = 16;
    private static final int F_SKIP = 32;
    private static final int F_2MHZ = 64;
    private static final int F_AVOID = 128;
    private static final int F_NORLE = 512;
    private static final int F_UNPACK = 16384;
    private static final int F_ERROR = 32768;
    private int LRANGE = ((2 << this.maxGamma) - 3) * 256;
    private int MAXLZLEN = 2 << this.maxGamma;
    private final int MAXRLELEN = ((2 << this.maxGamma) - 2) * 256;
    private final int DEFAULT_LZLEN = this.LRANGE;
    int lrange;
    int maxlzlen;
    int maxrlelen;
    private static final int OUT_SIZE = 2000000;
    byte[] outBuffer = new byte[2000000];
    int outPointer = 0;
    int bitMask = 128;
    int[] lenValue = new int[256];
    int gainedEscaped = 0;
    int gainedRle = 0;
    int gainedSRle = 0;
    int gainedLRle = 0;
    int gainedLz = 0;
    int gainedRlecode = 0;
    int gainedDLz = 0;
    int timesDLz = 0;
    int timesEscaped = 0;
    int timesNormal = 0;
    int timesRle = 0;
    int timesSRle = 0;
    int timesLRle = 0;
    int timesLz = 0;
    int[][] lenStat = new int[8][4];
    byte[] rleValues = new byte[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    int[] rleHist = new int[256];
    int[] rleLen = new int[256];
    int[] rle;
    int[] elr;
    int[] lzlen;
    int[] lzpos;
    int[] lzmlen;
    int[] lzmpos;
    int[] lzlen2;
    int[] lzpos2;
    int[] length;
    int inlen;
    byte[] indata;
    byte[] newesc;
    int[] mode;
    int[] backSkip;
    private static final int LITERAL = 0;
    private static final int LZ77 = 1;
    private static final int RLE = 2;
    private static final int DLZ = 3;
    private static final int MMARK = 4;
    int lzopt = 0;
    byte[] up_Data;
    int up_DataPos;
    int up_Mask;
    int up_Byte;
    private static final int MAXCODES = 20;

    void ListDecompressors(PrintStream fp) {
        for (int dc = 0; dc < fixStruct.length; ++dc) {
            fp.printf("%s\n", PUCrunch.fixStruct[dc].name);
        }
    }

    FixStruct BestMatch(int type) {
        FixStruct best = null;
        for (int dc = 0; dc < fixStruct.length; ++dc) {
            if ((PUCrunch.fixStruct[dc].flags & 0xFF) != (type & 0xFF) || (PUCrunch.fixStruct[dc].flags & type & 0x700) != (type & 0x700)) continue;
            if (null == best || (type & 0x100) == (PUCrunch.fixStruct[dc].flags & 0x100) && (0 == (type & 0x1800) || (PUCrunch.fixStruct[dc].flags & type & 0x1800) != 0)) {
                best = fixStruct[dc];
            }
            if ((type & 0x1800) != (PUCrunch.fixStruct[dc].flags & 0x1800)) continue;
            return fixStruct[dc];
        }
        return best;
    }

    int GetHeaderSize(int type, IntContainer deCall) {
        if (deCall != null) {
            deCall.intVal = 0;
        }
        if ((type & 0xFF) == 0) {
            return 47;
        }
        FixStruct best = this.BestMatch(type);
        if (best != null && deCall != null) {
            int i = 0;
            while (best.fixes[i].type != FixType.ftEnd) {
                if (best.fixes[i].type == FixType.ftDeCall) {
                    deCall.intVal = best.fixes[i].offset;
                    break;
                }
                ++i;
            }
        }
        return best != null ? best.codeSize : 0;
    }

    int SavePack(int type, byte[] data, int size, String target, int start, int exec, int escape, byte[] rleValues, int endAddr, int progEnd, int extraLZPosBits, int enable2MHz, int memStart, int memEnd) {
        PrintStream fp = null;
        int overlap = 0;
        int stackUsed = 0;
        int ibufferUsed = 0;
        if (null == data) {
            return 10;
        }
        if (null == target) {
            fp = System.out;
        }
        if ((type & 0xFF) == 0) {
            try {
                if (null == fp) {
                    fp = new PrintStream(target);
                    byte[] head = new byte[64];
                    int cnt = 0;
                    head[cnt++] = (byte)(endAddr + overlap - size & 0xFF);
                    head[cnt++] = (byte)(endAddr + overlap - size >> 8);
                    head[cnt++] = 112;
                    head[cnt++] = 117;
                    head[cnt++] = (byte)(endAddr - 256 & 0xFF);
                    head[cnt++] = (byte)(endAddr - 256 >> 8);
                    head[cnt++] = (byte)(escape >> 8 - this.escBits);
                    head[cnt++] = (byte)(start & 0xFF);
                    head[cnt++] = (byte)(start >> 8);
                    head[cnt++] = (byte)this.escBits;
                    head[cnt++] = (byte)(this.maxGamma + 1);
                    head[cnt++] = (byte)(1 << this.maxGamma);
                    head[cnt++] = (byte)extraLZPosBits;
                    head[cnt++] = (byte)(exec & 0xFF);
                    head[cnt++] = (byte)(exec >> 8);
                    head[cnt++] = (byte)this.rleUsed;
                    for (int i = 1; i <= this.rleUsed; ++i) {
                        head[cnt++] = rleValues[i];
                    }
                    fp.write(head, 0, cnt);
                    fp.write(data, 0, cnt);
                    if (fp != System.out) {
                        fp.close();
                    }
                    return 0;
                }
            }
            catch (IOException e) {
                System.err.printf("Could not open %s for writing\n", target);
                return 10;
            }
        }
        if ((memStart & 0xFF) != 1) {
            System.err.printf("Misaligned basic start 0x%04x\n", memStart);
            return 10;
        }
        if (memStart > 9999) {
            System.err.printf("Too high basic start 0x%04x\n", memStart);
            return 10;
        }
        if (endAddr > memEnd) {
            overlap = endAddr - memEnd;
            endAddr = memEnd;
            if (overlap > 22) {
                System.err.printf("Warning: data overlap is %d, but only 22 is totally safe!\n", overlap);
                System.err.printf("The data from $61 to $%02x is overwritten.\n", 75 + overlap);
            }
        }
        type = overlap != 0 ? (type |= 0x100) : (type &= 0xFFFFFEFF);
        FixStruct dc = this.BestMatch(type);
        if (null == dc) {
            System.err.printf("No matching decompressor found\n", new Object[0]);
            return 10;
        }
        byte[] header = dc.code;
        if (0 == memStart) {
            memStart = 2049;
        }
        if (this.BIG && memStart + dc.codeSize - 2 + size > 65024) {
            System.err.printf("Packed file's max size is 0x%04x (0x%04x)!\n", 65024 - memStart - (dc.codeSize - 2), size);
            return 10;
        }
        int i = 0;
        while (dc.fixes[i].type != FixType.ftEnd) {
            switch (dc.fixes[i].type) {
                case ftFastDisable: {
                    if (0 != enable2MHz) break;
                    header[dc.fixes[i].offset] = 44;
                    break;
                }
                case ftOverlap: {
                    header[dc.fixes[i].offset] = (byte)(overlap != 0 ? overlap - 1 : 0);
                    break;
                }
                case ftOverlapLo: {
                    header[dc.fixes[i].offset] = (byte)(memStart + dc.codeSize - 2 + this.rleUsed - 15 + size - overlap & 0xFF);
                    break;
                }
                case ftOverlapHi: {
                    header[dc.fixes[i].offset] = (byte)(memStart + dc.codeSize - 2 + this.rleUsed - 15 + size - overlap >> 8);
                    break;
                }
                case ftWrapCount: {
                    header[dc.fixes[i].offset] = (byte)((memEnd >> 8) - (endAddr + overlap - size >> 8));
                    break;
                }
                case ftSizePages: {
                    header[dc.fixes[i].offset] = (byte)((size >> 8) + 1);
                    break;
                }
                case ftSizeLo: {
                    header[dc.fixes[i].offset] = (byte)(memStart + dc.codeSize - 2 + this.rleUsed - 15 + size - 256 - overlap & 0xFF);
                    break;
                }
                case ftSizeHi: {
                    header[dc.fixes[i].offset] = (byte)(memStart + dc.codeSize - 2 + this.rleUsed - 15 + size - 256 - overlap >> 8);
                    break;
                }
                case ftEndLo: {
                    header[dc.fixes[i].offset] = (byte)(endAddr - 256 & 0xFF);
                    break;
                }
                case ftEndHi: {
                    header[dc.fixes[i].offset] = (byte)(endAddr - 256 >> 8);
                    break;
                }
                case ftEscValue: {
                    header[dc.fixes[i].offset] = (byte)(escape >> 8 - this.escBits);
                    break;
                }
                case ftOutposLo: {
                    header[dc.fixes[i].offset] = (byte)(start & 0xFF);
                    break;
                }
                case ftOutposHi: {
                    header[dc.fixes[i].offset] = (byte)(start >> 8);
                    break;
                }
                case ftEscBits: {
                    header[dc.fixes[i].offset] = (byte)this.escBits;
                    break;
                }
                case ftEsc8Bits: {
                    header[dc.fixes[i].offset] = (byte)(8 - this.escBits);
                    break;
                }
                case ft1MaxGamma: {
                    header[dc.fixes[i].offset] = (byte)(1 << this.maxGamma);
                    break;
                }
                case ft8MaxGamma: {
                    header[dc.fixes[i].offset] = (byte)(8 - this.maxGamma);
                    break;
                }
                case ft2MaxGamma: {
                    header[dc.fixes[i].offset] = (byte)((2 << this.maxGamma) - 1);
                    break;
                }
                case ftExtraBits: {
                    header[dc.fixes[i].offset] = (byte)extraLZPosBits;
                    break;
                }
                case ftMemConfig: {
                    header[dc.fixes[i].offset] = (byte)this.memConfig;
                    break;
                }
                case ftCli: {
                    header[dc.fixes[i].offset] = (byte)this.intConfig;
                    break;
                }
                case ftExecLo: {
                    header[dc.fixes[i].offset] = (byte)(exec & 0xFF);
                    break;
                }
                case ftExecHi: {
                    header[dc.fixes[i].offset] = (byte)(exec >> 8);
                    break;
                }
                case ftInposLo: {
                    header[dc.fixes[i].offset] = (byte)(endAddr + overlap - size & 0xFF);
                    break;
                }
                case ftInposHi: {
                    header[dc.fixes[i].offset] = (byte)(endAddr + overlap - size >> 8);
                    break;
                }
                case ftMaxGamma: {
                    header[dc.fixes[i].offset] = (byte)(this.maxGamma + 1);
                    break;
                }
                case ftReloc: {
                    if (header[1] == memStart >> 8) break;
                    int n = dc.fixes[i].offset;
                    header[n] = (byte)(header[n] - ((header[1] & 0xFF) - (memStart >> 8)));
                    break;
                }
                case ftBEndLo: {
                    header[dc.fixes[i].offset] = (byte)(progEnd & 0xFF);
                    break;
                }
                case ftBEndHi: {
                    header[dc.fixes[i].offset] = (byte)(progEnd >> 8);
                    break;
                }
                case ftStackSize: {
                    stackUsed = header[dc.fixes[i].offset] & 0xFF;
                    break;
                }
                case ftIBufferSize: {
                    ibufferUsed = header[dc.fixes[i].offset] & 0xFF;
                    break;
                }
            }
            ++i;
        }
        for (i = 1; i <= 15; ++i) {
            header[dc.codeSize - 15 + i - 1] = rleValues[i];
        }
        if ((header[1] & 0xFF) != memStart >> 8) {
            header[1] = (byte)(memStart >> 8);
            header[3] = (byte)(memStart >> 8);
            header[7] = (byte)(48 + (memStart + 12) / 1000);
            header[8] = (byte)(48 + (memStart + 12) / 100 % 10);
            header[9] = (byte)(48 + (memStart + 12) / 10 % 10);
            header[10] = (byte)(48 + (memStart + 12) % 10);
        }
        System.err.printf("Saving %s\n", dc.name);
        try {
            if (null == fp) {
                fp = new PrintStream(target);
                fp.write(header, 0, dc.codeSize + this.rleUsed - 15);
                fp.write(data, 0, size);
                if (fp != System.out) {
                    fp.close();
                }
            }
        }
        catch (IOException e) {
            System.err.printf("Could not open %s for writing\n", target);
            return 10;
        }
        if ((dc.flags & 0x1000) != 0) {
            System.err.printf("%s uses the memory $2d-$30, ", target != null ? target : "");
        } else {
            System.err.printf("%s uses the memory $2d/$2e, ", target != null ? target : "");
        }
        if (overlap != 0) {
            System.err.printf("$4b-$%02x, ", 75 + overlap);
        } else if ((dc.flags & 0x100) != 0) {
            System.err.printf("$4b, ", new Object[0]);
        }
        if (stackUsed != 0) {
            System.err.printf("$f7-$%x, ", 247 + stackUsed);
        }
        if (ibufferUsed != 0) {
            System.err.printf("$200-$%x, ", 512 + ibufferUsed);
        }
        System.err.printf("and $%04x-$%04x.\n", start < memStart + 1 ? start : memStart + 1, endAddr - 1);
        return 0;
    }

    void FlushBits() {
        if (this.bitMask != 128) {
            ++this.outPointer;
        }
    }

    void PutBit(int bit) {
        if (bit != 0 && this.outPointer < 2000000) {
            int n = this.outPointer;
            this.outBuffer[n] = (byte)(this.outBuffer[n] | this.bitMask);
        }
        this.bitMask >>= 1;
        if (0 == this.bitMask) {
            this.bitMask = 128;
            ++this.outPointer;
        }
    }

    void PutValue(int value) {
        int bits = 0;
        int count = 0;
        while (value > 1) {
            bits = bits << 1 | value & 1;
            value >>= 1;
            ++count;
            this.PutBit(1);
        }
        if (count < this.maxGamma) {
            this.PutBit(0);
        }
        while (count-- != 0) {
            this.PutBit(bits & 1);
            bits >>= 1;
        }
    }

    int RealLenValue(int value) {
        int count = 0;
        if (value < 2) {
            count = 0;
        } else if (value < 4) {
            count = 1;
        } else if (value < 8) {
            count = 2;
        } else if (value < 16) {
            count = 3;
        } else if (value < 32) {
            count = 4;
        } else if (value < 64) {
            count = 5;
        } else if (value < 128) {
            count = 6;
        } else if (value < 256) {
            count = 7;
        }
        if (count < this.maxGamma) {
            return 2 * count + 1;
        }
        return 2 * count;
    }

    void InitValueLen() {
        for (int i = 1; i < 256; ++i) {
            this.lenValue[i] = this.RealLenValue(i);
        }
    }

    void PutNBits(int b, int bits) {
        while (bits-- != 0) {
            this.PutBit(b & 1 << bits);
        }
    }

    int OutputNormal(IntContainer esc, byte[] data, int dataPos, int newesc) {
        ++this.timesNormal;
        if ((data[dataPos + 0] & this.escMask) == esc.intVal) {
            this.PutNBits(esc.intVal >> 8 - this.escBits, this.escBits);
            this.PutValue(1);
            this.PutBit(1);
            this.PutBit(0);
            esc.intVal = newesc;
            this.PutNBits(esc.intVal >> 8 - this.escBits, this.escBits);
            this.PutNBits(data[dataPos + 0] & 0xFF, 8 - this.escBits);
            this.gainedEscaped += this.escBits + 3;
            ++this.timesEscaped;
            return 1;
        }
        this.PutNBits(data[dataPos + 0] & 0xFF, 8);
        return 0;
    }

    void OutputEof(IntContainer esc) {
        this.PutNBits(esc.intVal >> 8 - this.escBits, this.escBits);
        this.PutValue(2);
        this.PutValue((2 << this.maxGamma) - 1);
        this.FlushBits();
    }

    void PutRleByte(int data) {
        for (int index = 1; index < 16; ++index) {
            if (data != (this.rleValues[index] & 0xFF)) continue;
            if (index == 1) {
                int[] nArray = this.lenStat[0];
                nArray[3] = nArray[3] + 1;
            } else if (index <= 3) {
                int[] nArray = this.lenStat[1];
                nArray[3] = nArray[3] + 1;
            } else if (index <= 7) {
                int[] nArray = this.lenStat[2];
                nArray[3] = nArray[3] + 1;
            } else if (index <= 15) {
                int[] nArray = this.lenStat[3];
                nArray[3] = nArray[3] + 1;
            }
            this.gainedRlecode += 8 - this.lenValue[index];
            this.PutValue(index);
            return;
        }
        this.PutValue(16 + (data >> 4));
        this.gainedRlecode -= this.lenValue[16 + (data >> 4)] + 4;
        this.PutNBits(data, 4);
        int[] nArray = this.lenStat[4];
        nArray[3] = nArray[3] + 1;
    }

    void InitRleLen() {
        int i;
        for (i = 0; i < 256; ++i) {
            this.rleLen[i] = this.lenValue[16] + 4;
        }
        for (i = 1; i < 16; ++i) {
            this.rleLen[this.rleValues[i] & 0xFF] = this.lenValue[i];
        }
    }

    int LenRle(int len, int data) {
        int out = 0;
        do {
            if (len == 1) {
                out += this.escBits + 3 + 8;
                len = 0;
                continue;
            }
            if (len <= 1 << this.maxGamma) {
                out += this.escBits + 3 + this.lenValue[len - 1] + this.rleLen[data];
                len = 0;
                continue;
            }
            int tmp = Math.min(len, this.maxrlelen);
            out += this.escBits + 3 + this.maxGamma + 8 + this.lenValue[(tmp - 1 >> 8) + 1] + this.rleLen[data];
            len -= tmp;
        } while (len != 0);
        return out;
    }

    int OutputRle(IntContainer esc, byte[] data, int dataPos, int rlelen) {
        int len = rlelen;
        while (len != 0) {
            int tmp;
            if (len >= 2 && len <= 1 << this.maxGamma) {
                if (len == 2) {
                    int[] nArray = this.lenStat[0];
                    nArray[2] = nArray[2] + 1;
                } else if (len <= 4) {
                    int[] nArray = this.lenStat[1];
                    nArray[2] = nArray[2] + 1;
                } else if (len <= 8) {
                    int[] nArray = this.lenStat[2];
                    nArray[2] = nArray[2] + 1;
                } else if (len <= 16) {
                    int[] nArray = this.lenStat[3];
                    nArray[2] = nArray[2] + 1;
                } else if (len <= 32) {
                    int[] nArray = this.lenStat[4];
                    nArray[2] = nArray[2] + 1;
                } else if (len <= 64) {
                    int[] nArray = this.lenStat[5];
                    nArray[2] = nArray[2] + 1;
                } else if (len <= 128) {
                    int[] nArray = this.lenStat[6];
                    nArray[2] = nArray[2] + 1;
                } else if (len <= 256) {
                    int[] nArray = this.lenStat[6];
                    nArray[2] = nArray[2] + 1;
                }
                this.PutNBits(esc.intVal >> 8 - this.escBits, this.escBits);
                this.PutValue(1);
                this.PutBit(1);
                this.PutBit(1);
                this.PutValue(len - 1);
                this.PutRleByte(data[dataPos] & 0xFF);
                tmp = 8 * len - this.escBits - 3 - this.lenValue[len - 1] - this.rleLen[data[dataPos] & 0xFF];
                this.gainedRle += tmp;
                this.gainedSRle += tmp;
                ++this.timesRle;
                ++this.timesSRle;
                return 0;
            }
            if (len < 3) {
                while (len-- != 0) {
                    this.OutputNormal(esc, data, dataPos, esc.intVal);
                }
                return 0;
            }
            if (len <= this.maxrlelen) {
                this.PutNBits(esc.intVal >> 8 - this.escBits, this.escBits);
                this.PutValue(1);
                this.PutBit(1);
                this.PutBit(1);
                this.PutValue((1 << this.maxGamma) + ((len - 1 & 0xFF) >> 8 - this.maxGamma));
                this.PutNBits(len - 1, 8 - this.maxGamma);
                this.PutValue((len - 1 >> 8) + 1);
                this.PutRleByte(data[dataPos] & 0xFF);
                tmp = 8 * len - this.escBits - 3 - this.maxGamma - 8 - this.lenValue[(len - 1 >> 8) + 1] - this.rleLen[data[dataPos] & 0xFF];
                this.gainedRle += tmp;
                this.gainedLRle += tmp;
                ++this.timesRle;
                ++this.timesLRle;
                return 0;
            }
            this.PutNBits(esc.intVal >> 8 - this.escBits, this.escBits);
            this.PutValue(1);
            this.PutBit(1);
            this.PutBit(1);
            this.PutValue((1 << this.maxGamma) + ((this.maxrlelen - 1 & 0xFF) >> 8 - this.maxGamma));
            this.PutNBits(this.maxrlelen - 1 & 0xFF, 8 - this.maxGamma);
            this.PutValue((this.maxrlelen - 1 >> 8) + 1);
            this.PutRleByte(data[dataPos]);
            tmp = 8 * this.maxrlelen - this.escBits - 3 - this.maxGamma - 8 - this.lenValue[(this.maxrlelen - 1 >> 8) + 1] - this.rleLen[data[dataPos]];
            this.gainedRle += tmp;
            this.gainedLRle += tmp;
            ++this.timesRle;
            ++this.timesLRle;
            len -= this.maxrlelen;
            dataPos += this.maxrlelen;
        }
        return 0;
    }

    int LenDLz(int lzlen, int lzpos) {
        return this.escBits + 2 * this.maxGamma + 8 + 8 + this.lenValue[lzlen - 1];
    }

    int OutputDLz(IntContainer esc, int lzlen, int lzpos, int add) {
        this.PutNBits(esc.intVal >> 8 - this.escBits, this.escBits);
        this.PutValue(lzlen - 1);
        this.PutValue((2 << this.maxGamma) - 1);
        this.PutNBits(add, 8);
        this.PutNBits(lzpos - 1 & 0xFF ^ 0xFF, 8);
        this.gainedDLz += 8 * lzlen - (this.escBits + this.lenValue[lzlen - 1] + 2 * this.maxGamma + 16);
        ++this.timesDLz;
        return 4;
    }

    int LenLz(int lzlen, int lzpos) {
        if (lzlen == 2) {
            if (lzpos <= 256) {
                return this.escBits + 2 + 8;
            }
            return 100000;
        }
        return this.escBits + 8 + this.extraLZPosBits + this.lenValue[(lzpos - 1 >> 8 + this.extraLZPosBits) + 1] + lzlen < 257 ? this.lenValue[lzlen - 1] : 50;
    }

    int OutputLz(IntContainer esc, int lzlen, int lzpos, byte[] data, int dataPos, int curpos) {
        if (lzlen == 2) {
            int[] nArray = this.lenStat[0];
            nArray[1] = nArray[1] + 1;
        } else if (lzlen <= 4) {
            int[] nArray = this.lenStat[1];
            nArray[1] = nArray[1] + 1;
        } else if (lzlen <= 8) {
            int[] nArray = this.lenStat[2];
            nArray[1] = nArray[1] + 1;
        } else if (lzlen <= 16) {
            int[] nArray = this.lenStat[3];
            nArray[1] = nArray[1] + 1;
        } else if (lzlen <= 32) {
            int[] nArray = this.lenStat[4];
            nArray[1] = nArray[1] + 1;
        } else if (lzlen <= 64) {
            int[] nArray = this.lenStat[5];
            nArray[1] = nArray[1] + 1;
        } else if (lzlen <= 128) {
            int[] nArray = this.lenStat[6];
            nArray[1] = nArray[1] + 1;
        } else if (lzlen <= 256) {
            int[] nArray = this.lenStat[7];
            nArray[1] = nArray[1] + 1;
        }
        if (lzlen >= 2 && lzlen <= this.maxlzlen) {
            this.PutNBits(esc.intVal >> 8 - this.escBits, this.escBits);
            int tmp = (lzpos - 1 >> 8 + this.extraLZPosBits) + 2;
            if (tmp == 2) {
                int[] nArray = this.lenStat[0];
                nArray[0] = nArray[0] + 1;
            } else if (tmp <= 4) {
                int[] nArray = this.lenStat[1];
                nArray[0] = nArray[0] + 1;
            } else if (tmp <= 8) {
                int[] nArray = this.lenStat[2];
                nArray[0] = nArray[0] + 1;
            } else if (tmp <= 16) {
                int[] nArray = this.lenStat[3];
                nArray[0] = nArray[0] + 1;
            } else if (tmp <= 32) {
                int[] nArray = this.lenStat[4];
                nArray[0] = nArray[0] + 1;
            } else if (tmp <= 64) {
                int[] nArray = this.lenStat[5];
                nArray[0] = nArray[0] + 1;
            } else if (tmp <= 128) {
                int[] nArray = this.lenStat[6];
                nArray[0] = nArray[0] + 1;
            } else if (tmp <= 256) {
                int[] nArray = this.lenStat[6];
                nArray[0] = nArray[0] + 1;
            }
            if (lzlen == 2) {
                this.PutValue(lzlen - 1);
                this.PutBit(0);
                if (lzpos > 256) {
                    System.err.printf("Error at %d: lzpos too long (%d) for lzlen==2\n", curpos, lzpos);
                }
                this.PutNBits(lzpos - 1 & 0xFF ^ 0xFF, 8);
            } else {
                this.PutValue(lzlen - 1);
                this.PutValue((lzpos - 1 >> 8 + this.extraLZPosBits) + 1);
                this.PutNBits(lzpos - 1 >> 8, this.extraLZPosBits);
                this.PutNBits(lzpos - 1 & 0xFF ^ 0xFF, 8);
            }
            this.gainedLz += 8 * lzlen - this.LenLz(lzlen, lzpos);
            ++this.timesLz;
            return 3;
        }
        System.err.printf("Error: lzlen too short/long (%d)\n", lzlen);
        return lzlen;
    }

    int OptimizeLength(int optimize) {
        this.length[this.inlen] = 0;
        for (int i = this.inlen - 1; i >= 0; --i) {
            int ii;
            int minv;
            int mini;
            int v;
            int r2;
            int r1 = 8 + this.length[i + 1];
            if (0 == this.lzlen[i] && 0 == this.rle[i] && (null == this.lzlen2 || 0 == this.lzlen2[i])) {
                this.length[i] = r1;
                this.mode[i] = 0;
                continue;
            }
            if (this.rle[i] > this.maxlzlen && this.elr[i] > 1) {
                int z = this.elr[i];
                i -= this.elr[i];
                r2 = this.LenRle(this.rle[i], this.indata[i] & 0xFF) + this.length[i + this.rle[i]];
                if (optimize != 0) {
                    int mini2 = this.rle[i];
                    int minv2 = r2;
                    int bot = this.rle[i] - (1 << this.maxGamma);
                    if (bot < 2) {
                        bot = 2;
                    }
                    for (int ii2 = mini2 - 1; ii2 >= bot; --ii2) {
                        v = this.LenRle(ii2, this.indata[i] & 0xFF) + this.length[i + ii2];
                        if (v >= minv2) continue;
                        minv2 = v;
                        mini2 = ii2;
                    }
                    if (minv2 != r2) {
                        this.lzopt += r2 - minv2;
                        this.rle[i] = mini2;
                        r2 = minv2;
                    }
                }
                this.length[i] = r2;
                this.mode[i] = 2;
                while (z >= 0) {
                    this.length[i + z] = r2;
                    this.mode[i + z] = 2;
                    --z;
                }
                continue;
            }
            int r3 = r2 = r1 + 1000;
            if (this.rle[i] != 0) {
                r2 = this.LenRle(this.rle[i], this.indata[i] & 0xFF) + this.length[i + this.rle[i]];
                if (optimize != 0) {
                    mini = this.rle[i];
                    minv = r2;
                    for (ii = 2; this.rle[i] > ii; ii <<= 1) {
                        int v2 = this.LenRle(ii, this.indata[i] & 0xFF) + this.length[i + ii];
                        if (v2 >= minv) continue;
                        minv = v2;
                        mini = ii;
                    }
                    if (minv != r2) {
                        this.lzopt += r2 - minv;
                        this.rle[i] = mini;
                        r2 = minv;
                    }
                }
            }
            if (this.lzlen[i] != 0) {
                r3 = this.LenLz(this.lzlen[i], this.lzpos[i]) + this.length[i + this.lzlen[i]];
                if (optimize != 0 && this.lzlen[i] > 2) {
                    mini = this.lzlen[i];
                    minv = r3;
                    int mino = this.lzpos[i];
                    int topLen = this.LenLz(this.lzlen[i], this.lzpos[i]) - this.lenValue[this.lzlen[i] - 1];
                    for (ii = 4; this.lzlen[i] > ii; ii <<= 1) {
                        v = topLen + this.lenValue[ii - 1] + this.length[i + ii];
                        if (v >= minv) continue;
                        minv = v;
                        mini = ii;
                    }
                    for (ii = 3; this.lzmlen[i] >= ii; ++ii) {
                        v = this.LenLz(ii, this.lzmpos[i]) + this.length[i + ii];
                        if (v >= minv) continue;
                        minv = v;
                        mini = ii;
                        mino = this.lzmpos[i];
                    }
                    if (this.backSkip[i] != 0 && this.backSkip[i] <= 256 && (v = this.LenLz(2, this.backSkip[i]) + this.length[i + 2]) < minv) {
                        minv = v;
                        this.lzlen[i] = mini = 2;
                        r3 = minv;
                        this.lzpos[i] = this.backSkip[i];
                    }
                    if (minv != r3 && minv < r2) {
                        this.lzopt += r3 - minv;
                        this.lzlen[i] = mini;
                        this.lzpos[i] = mino;
                        r3 = minv;
                    }
                }
            }
            if (r2 <= r1) {
                if (r2 <= r3) {
                    this.length[i] = r2;
                    this.mode[i] = 2;
                } else {
                    this.length[i] = r3;
                    this.mode[i] = 1;
                }
            } else if (r3 <= r1) {
                this.length[i] = r3;
                this.mode[i] = 1;
            } else {
                this.length[i] = r1;
                this.mode[i] = 0;
            }
            if (this.lzlen2 == null || this.lzlen2[i] <= 3 || (r3 = this.LenDLz(this.lzlen2[i], this.lzpos2[i]) + this.length[i + this.lzlen2[i]]) >= this.length[i]) continue;
            this.length[i] = r3;
            this.mode[i] = 3;
        }
        return this.length[0];
    }

    int OptimizeEscape(IntContainer startEscape, IntContainer nonNormal) {
        int i;
        int states = 1 << this.escBits;
        int minp = 0;
        int minv = 0;
        int other = 0;
        int[] a = new int[256];
        int[] b = new int[256];
        int esc8 = 8 - this.escBits;
        for (i = 0; i < 256; ++i) {
            a[i] = -1;
            b[i] = -1;
        }
        if (states > 256) {
            System.err.printf("Escape optimize: only 256 states (%d)!\n", states);
            return 0;
        }
        i = 0;
        block6: while (i < this.inlen) {
            switch (this.mode[i]) {
                case 3: {
                    ++other;
                    i += this.lzlen2[i];
                    continue block6;
                }
                case 1: {
                    ++other;
                    i += this.lzlen[i];
                    continue block6;
                }
                case 2: {
                    ++other;
                    i += this.rle[i];
                    continue block6;
                }
            }
            this.mode[i++] = 4;
        }
        block7: for (i = this.inlen - 1; i >= 0; --i) {
            if (this.mode[i] != 4) continue;
            int k = (this.indata[i] & 0xFF) >> esc8;
            this.mode[i] = 0;
            this.newesc[i] = (byte)(minp << esc8);
            a[k] = minv + 1;
            b[k] = b[minp] + 1;
            if (k != minp) continue;
            ++minv;
            for (k = states - 1; k >= 0; --k) {
                if (a[k] >= minv) continue;
                minv = a[k];
                minp = k;
                continue block7;
            }
        }
        if (startEscape != null) {
            i = this.inlen;
            for (int j = states - 1; j >= 0; --j) {
                if (a[j] > i) continue;
                startEscape.intVal = j << esc8;
                i = a[j];
            }
        }
        if (nonNormal != null) {
            nonNormal.intVal = other;
        }
        return b[startEscape != null ? startEscape.intVal >> esc8 : 0];
    }

    void InitRle(int flags) {
        for (int i = 1; i < 16; ++i) {
            int mr = -1;
            int mv = 0;
            for (int p = 0; p < 256; ++p) {
                if (this.rleHist[p] <= mv) continue;
                mv = this.rleHist[p];
                mr = p;
            }
            if (mv <= 0) break;
            this.rleValues[i] = (byte)mr;
            this.rleHist[mr] = -1;
        }
        this.InitRleLen();
    }

    void OptimizeRle(int flags) {
        int i;
        int p;
        if ((flags & 0x200) != 0) {
            this.rleUsed = 0;
            return;
        }
        if ((flags & 2) != 0) {
            System.err.printf("RLE Byte Code Re-Tune, RLE Ranks:\n", new Object[0]);
        }
        for (p = 0; p < 256; ++p) {
            this.rleHist[p] = 0;
        }
        p = 0;
        block6: while (p < this.inlen) {
            switch (this.mode[p]) {
                case 3: {
                    p += this.lzlen2[p];
                    continue block6;
                }
                case 1: {
                    p += this.lzlen[p];
                    continue block6;
                }
                case 2: {
                    int n = this.indata[p] & 0xFF;
                    this.rleHist[n] = this.rleHist[n] + 1;
                    p += this.rle[p];
                    continue block6;
                }
            }
            ++p;
        }
        for (i = 1; i < 16; ++i) {
            int mr = -1;
            int mv = 0;
            for (p = 0; p < 256; ++p) {
                if (this.rleHist[p] <= mv) continue;
                mv = this.rleHist[p];
                mr = p;
            }
            if (mv <= 0) break;
            this.rleValues[i] = (byte)mr;
            if ((flags & 2) != 0) {
                System.err.printf(" %2d.0x%02x %-3d ", i, mr, mv);
                if (0 == (i - 1) % 6) {
                    System.err.printf("\n", new Object[0]);
                }
            }
            this.rleHist[mr] = -1;
        }
        this.rleUsed = i - 1;
        if ((flags & 2) != 0 && (i - 1) % 6 != 1) {
            System.err.printf("\n", new Object[0]);
        }
        this.InitRleLen();
    }

    void up_SetInput(byte[] data, int dataPos) {
        this.up_Data = data;
        this.up_DataPos = dataPos;
        this.up_Mask = 128;
        this.up_Byte = 0;
    }

    int up_GetBits(int bits) {
        int val = 0;
        while (bits-- != 0) {
            val <<= 1;
            if ((this.up_Data[this.up_DataPos] & this.up_Mask) != 0) {
                val |= 1;
            }
            this.up_Mask >>= 1;
            if (0 != this.up_Mask) continue;
            this.up_Mask = 128;
            ++this.up_DataPos;
            ++this.up_Byte;
        }
        return val;
    }

    int up_GetValue() {
        int i;
        for (i = 0; i < this.maxGamma && 0 != this.up_GetBits(1); ++i) {
        }
        return 1 << i | this.up_GetBits(i);
    }

    int UnPack(int loadAddr, byte[] data, String file, int flags) {
        int i;
        int headerSize;
        int size;
        int overlap;
        byte[] byteCodeVec;
        int execAddr;
        int startAddr;
        int startEsc;
        int endAddr;
        int error = 0;
        long timeused = System.currentTimeMillis();
        int byteCodeVecPos = 0;
        int[] mismatch = new int[20];
        int[] collect = new int[FixType.ftEnd.ordinal()];
        if (data[0] == 112 && data[1] == 117) {
            int cnt = 2;
            endAddr = (data[cnt] & 0xFF | (data[cnt + 1] & 0xFF) << 8) + 256;
            cnt += 2;
            startEsc = data[cnt++] & 0xFF;
            startAddr = data[cnt] & 0xFF | (data[cnt + 1] & 0xFF) << 8;
            cnt += 2;
            this.escBits = data[cnt++] & 0xFF;
            if (this.escBits < 0 || this.escBits > 8) {
                System.err.printf("Error: Broken archive, escBits %d.\n", this.escBits);
                return 20;
            }
            this.maxGamma = (data[cnt++] & 0xFF) - 1;
            if ((data[cnt++] & 0xFF) != 1 << this.maxGamma || this.maxGamma < 5 || this.maxGamma > 7) {
                System.err.printf("Error: Broken archive, maxGamma %d.\n", this.maxGamma);
                return 20;
            }
            this.lrange = this.LRANGE;
            this.maxlzlen = this.MAXLZLEN;
            this.maxrlelen = this.MAXRLELEN;
            this.extraLZPosBits = data[cnt++] & 0xFF;
            if (this.extraLZPosBits < 0 || this.extraLZPosBits > 4) {
                System.err.printf("Error: Broken archive, extraLZPosBits %d.\n", this.extraLZPosBits);
                return 20;
            }
            execAddr = data[cnt] & 0xFF | (data[cnt + 1] & 0xFF) << 8;
            cnt += 2;
            this.rleUsed = data[cnt++] & 0xFF;
            byteCodeVec = data;
            byteCodeVecPos = cnt - 1;
            overlap = 0;
            size = endAddr - startAddr;
            headerSize = cnt + this.rleUsed;
            endAddr = loadAddr + size;
        } else {
            int dc;
            for (i = 0; i < fixStruct.length && i < 20; ++i) {
                int maxDiff = 0;
                if (PUCrunch.fixStruct[i].code[1] != loadAddr >> 8) {
                    maxDiff = 5;
                }
                int j = 0;
                while (PUCrunch.fixStruct[i].fixes[j].type != FixType.ftEnd) {
                    ++maxDiff;
                    ++j;
                }
                mismatch[i] = 0;
                for (j = 2; j < PUCrunch.fixStruct[i].codeSize - 15; ++j) {
                    if (PUCrunch.fixStruct[i].code[j] == data[j - 2]) continue;
                    int n = i;
                    mismatch[n] = mismatch[n] + 1;
                }
                if (mismatch[i] <= maxDiff) {
                    System.err.printf("Detected %s (%d <= %d)\n", PUCrunch.fixStruct[i].name, mismatch[i], maxDiff);
                    break;
                }
                System.err.printf("Not %s (%d > %d)\n", PUCrunch.fixStruct[i].name, mismatch[i], maxDiff);
            }
            if ((dc = i) == fixStruct.length) {
                System.err.printf("Error: The file is not compressed with this program.\n", new Object[0]);
                return 20;
            }
            if ((loadAddr & 0xFF) != 1) {
                System.err.printf("Error: Misaligned basic start address 0x%04x\n", loadAddr);
                return 20;
            }
            error = 0;
            for (i = 0; i < fixStruct.length; ++i) {
                collect[i] = 0;
            }
            collect[FixType.ftMemConfig.ordinal()] = this.memConfig;
            collect[FixType.ftCli.ordinal()] = this.intConfig;
            i = 0;
            while (PUCrunch.fixStruct[dc].fixes[i].type != FixType.ftEnd) {
                collect[PUCrunch.fixStruct[dc].fixes[i].type.ordinal()] = data[PUCrunch.fixStruct[dc].fixes[i].offset - 2] & 0xFF;
                ++i;
            }
            overlap = collect[FixType.ftOverlap.ordinal()];
            this.maxGamma = collect[FixType.ftMaxGamma.ordinal()] - 1;
            if (this.maxGamma < 5 || this.maxGamma > 7) {
                System.err.printf("Error: Broken archive, maxGamma %d.\n", this.maxGamma);
                return 20;
            }
            this.lrange = this.LRANGE;
            this.maxlzlen = this.MAXLZLEN;
            this.maxrlelen = this.MAXRLELEN;
            if (collect[FixType.ft1MaxGamma.ordinal()] != 1 << this.maxGamma || collect[FixType.ft8MaxGamma.ordinal()] != 8 - this.maxGamma || collect[FixType.ft2MaxGamma.ordinal()] != (2 << this.maxGamma) - 1) {
                System.err.printf("Error: Broken archive, maxGamma (%d) mismatch.\n", this.maxGamma);
                return 20;
            }
            startEsc = collect[FixType.ftEscValue.ordinal()];
            startAddr = collect[FixType.ftOutposLo.ordinal()] | collect[FixType.ftOutposHi.ordinal()] << 8;
            this.escBits = collect[FixType.ftEscBits.ordinal()];
            if (this.escBits < 0 || this.escBits > 8) {
                System.err.printf("Error: Broken archive, escBits %d.\n", this.escBits);
                return 20;
            }
            if (collect[FixType.ftEsc8Bits.ordinal()] != 8 - this.escBits) {
                System.err.printf("Error: Broken archive, escBits (%d) mismatch.\n", this.escBits);
                return 20;
            }
            this.extraLZPosBits = collect[FixType.ftExtraBits.ordinal()];
            if (this.extraLZPosBits < 0 || this.extraLZPosBits > 4) {
                System.err.printf("Error: Broken archive, extraLZPosBits %d.\n", this.extraLZPosBits);
                return 20;
            }
            endAddr = 256 + (collect[FixType.ftEndLo.ordinal()] | collect[FixType.ftEndHi.ordinal()] << 8);
            size = endAddr - (collect[FixType.ftInposLo.ordinal()] | collect[FixType.ftInposHi.ordinal()] << 8);
            headerSize = (collect[FixType.ftSizeLo.ordinal()] | collect[FixType.ftSizeHi.ordinal()] << 8) + 256 - size - loadAddr & 0xFFFF;
            execAddr = collect[FixType.ftExecLo.ordinal()] | collect[FixType.ftExecHi.ordinal()] << 8;
            this.memConfig = collect[FixType.ftMemConfig.ordinal()];
            this.intConfig = collect[FixType.ftCli.ordinal()];
            byteCodeVec = data;
            byteCodeVecPos = PUCrunch.fixStruct[dc].codeSize - 32 - 2;
            this.rleUsed = 15 - PUCrunch.fixStruct[dc].codeSize + 2 + headerSize;
        }
        if ((flags & 2) != 0) {
            System.err.printf("Load 0x%04x, Start 0x%04lx, exec 0x%04lx, %s%s$01=$%02x\n", loadAddr, startAddr, execAddr, this.intConfig == 88 ? "cli, " : "", this.intConfig == 120 ? "sei, " : "", this.memConfig);
            System.err.printf("Escape bits %d, starting escape 0x%02lx\n", this.escBits, startEsc << 8 - this.escBits);
            System.err.printf("Decompressor size %d, max length %d, LZPOS LO bits %d\n", headerSize + 2, 2 << this.maxGamma, this.extraLZPosBits + 8);
            System.err.printf("rleUsed: %d\n", this.rleUsed);
        }
        if (this.rleUsed > 15) {
            System.err.printf("Error: Old archive, rleUsed %d > 15.\n", this.rleUsed);
            return 20;
        }
        this.outPointer = 0;
        this.up_SetInput(data, headerSize);
        while (0 == error) {
            int sel = startEsc;
            if (!this.BIG) {
                if (startAddr + this.outPointer >= this.up_Byte + endAddr - size) {
                    if (0 == error) {
                        System.err.printf("Error: Target %5ld exceeds source %5ld..\n", startAddr + this.outPointer, this.up_Byte + endAddr - size);
                    }
                    ++error;
                }
                if (this.up_Byte > size + overlap) {
                    System.err.printf("Error: No EOF symbol found (%d > %d).\n", this.up_Byte, size + overlap);
                    ++error;
                }
            }
            if (this.escBits != 0) {
                sel = this.up_GetBits(this.escBits);
            }
            if (sel == startEsc) {
                int lzPos;
                int lzLen = this.up_GetValue();
                int add = 0;
                if (lzLen != 1) {
                    int lzPosHi = this.up_GetValue() - 1;
                    if (lzPosHi == (2 << this.maxGamma) - 2) {
                        if (lzLen <= 2) break;
                        add = this.up_GetBits(8);
                        lzPos = this.up_GetBits(8) ^ 0xFF;
                    } else {
                        if (this.extraLZPosBits != 0) {
                            lzPosHi = lzPosHi << this.extraLZPosBits | this.up_GetBits(this.extraLZPosBits);
                        }
                        int lzPosLo = this.up_GetBits(8) ^ 0xFF;
                        lzPos = lzPosHi << 8 | lzPosLo;
                    }
                } else {
                    if (this.up_GetBits(1) != 0) {
                        int byteCode;
                        if (0 == this.up_GetBits(1)) {
                            int newEsc = this.up_GetBits(this.escBits);
                            this.outBuffer[this.outPointer++] = (byte)(startEsc << 8 - this.escBits | this.up_GetBits(8 - this.escBits));
                            startEsc = newEsc;
                            if (this.outPointer < 2000000) continue;
                            System.err.printf("Error: Broken archive, output buffer overrun at %d.\n", this.outPointer);
                            return 20;
                        }
                        int rleLen = this.up_GetValue();
                        if (rleLen >= 1 << this.maxGamma) {
                            rleLen = rleLen - (1 << this.maxGamma) << 8 - this.maxGamma | this.up_GetBits(8 - this.maxGamma);
                            rleLen |= this.up_GetValue() - 1 << 8;
                        }
                        byte b = (byteCode = this.up_GetValue()) < 16 ? byteCodeVec[byteCodeVecPos + byteCode] : (byte)(byteCode - 16 << 4 | this.up_GetBits(4));
                        if (this.outPointer + rleLen + 1 >= 2000000) {
                            System.err.printf("Error: Broken archive, output buffer overrun at %d.\n", 2000000);
                            return 20;
                        }
                        for (i = 0; i <= rleLen; ++i) {
                            this.outBuffer[this.outPointer++] = b;
                        }
                        continue;
                    }
                    lzPos = this.up_GetBits(8) ^ 0xFF;
                }
                if (this.outPointer - lzPos - 1 < 0) {
                    System.err.printf("Error: Broken archive, LZ copy position underrun at %d (%d). lzLen %d.\n", this.outPointer, lzPos + 1, lzLen + 1);
                    return 20;
                }
                if (this.outPointer + lzLen + 1 >= 2000000) {
                    System.err.printf("Error: Broken archive, output buffer overrun at %d.\n", 2000000);
                    return 20;
                }
                for (i = 0; i <= lzLen; ++i) {
                    this.outBuffer[this.outPointer] = (byte)(this.outBuffer[this.outPointer - lzPos - 1] + add);
                    ++this.outPointer;
                }
                continue;
            }
            byte b = (byte)(sel << 8 - this.escBits | this.up_GetBits(8 - this.escBits));
            this.outBuffer[this.outPointer++] = b;
            if (this.outPointer < 2000000) continue;
            System.err.printf("Error: Broken archive, output buffer overrun at %d.\n", this.outPointer);
            return 20;
        }
        if (error != 0) {
            System.err.printf("Error: Target exceeded source %5ld times.\n", error);
        }
        try {
            PrintStream fp = file != null ? new PrintStream(file) : System.out;
            byte[] tmp = new byte[]{(byte)(startAddr & 0xFF), (byte)(startAddr >> 8)};
            fp.write(tmp, 0, 2);
            fp.write(this.outBuffer, 0, this.outPointer);
            if (fp != System.out) {
                fp.close();
            }
            if (0L == (timeused = System.currentTimeMillis() - timeused)) {
                ++timeused;
            }
            System.err.printf("Decompressed %d bytes in %4.2f seconds (%4.2f kB/s)\n", this.outPointer, (double)timeused / 1000.0, 1000.0 * (double)this.outPointer / (double)timeused / 1024.0);
            return error;
        }
        catch (IOException ioE) {
            System.err.printf("Could not open file \"%s\" for writing.\n", file);
            return 20;
        }
    }

    int PackLz77(int lzsz, int flags, IntContainer startEscape, int endAddr, int memEnd, int type) {
        int headerSize;
        int p;
        int escape = 0;
        int rescan = 0;
        int compares = 0;
        int hashChecks = 0;
        int hashEqual = 0;
        if (lzsz < 0 || lzsz > this.lrange) {
            System.err.printf("LZ range must be from 0 to %d (was %d). Set to %d.\n", this.lrange, lzsz, this.lrange);
            lzsz = this.lrange;
        }
        if (lzsz > 65535) {
            System.err.printf("LZ range must be from 0 to 65535 (was %d). Set to 65535.\n", lzsz);
            lzsz = 65535;
        }
        if (0 == lzsz) {
            System.err.printf("Warning: zero LZ range. Only RLE packing used.\n", new Object[0]);
        }
        this.InitRleLen();
        this.length = new int[this.inlen + 1];
        this.mode = new int[this.inlen];
        this.rle = new int[this.inlen];
        this.elr = new int[this.inlen];
        this.lzlen = new int[this.inlen];
        this.lzpos = new int[this.inlen];
        this.lzmlen = new int[this.inlen];
        this.lzmpos = new int[this.inlen];
        if ((type & 0x200) != 0) {
            this.lzlen2 = new int[this.inlen];
            this.lzpos2 = new int[this.inlen];
        } else {
            this.lzpos2 = null;
            this.lzlen2 = null;
        }
        this.newesc = new byte[this.inlen];
        this.backSkip = new int[this.inlen];
        int[] hashValue = new int[this.inlen];
        int[] lastPair = this.BIG ? new int[65536] : new int[65536];
        int i = 0;
        int j = 0;
        int a = this.inlen;
        for (p = this.inlen - 1; p >= 0; --p) {
            int k = j;
            j = i;
            i = this.indata[--a] & 0xFF;
            hashValue[p] = i * 3 + j * 5 + k * 7;
        }
        for (p = 0; p < this.inlen; ++p) {
            int tmppos;
            int tmplen;
            int topindex;
            int b;
            int valueCompare;
            if (this.BIG && 0 == (p & 0x7FF)) {
                System.err.printf("\r%d ", p);
            }
            if (this.rle[p] <= 0) {
                int rlelen;
                a = p;
                int val = this.indata[a++] & 0xFF;
                int top = this.inlen - p;
                for (rlelen = 1; !(rlelen >= top || (this.indata[a++] & 0xFF) != val || this.BIG && rlelen >= 65535); ++rlelen) {
                }
                compares += rlelen;
                if (rlelen >= 2) {
                    int n = this.indata[p] & 0xFF;
                    this.rleHist[n] = this.rleHist[n] + 1;
                    for (i = rlelen - 1; i >= 0; --i) {
                        this.rle[p + i] = rlelen - i;
                        this.elr[p + i] = i;
                    }
                }
            }
            if (p + this.rle[p] + 1 < this.inlen) {
                int bot = p - lzsz;
                int rlep = this.rle[p];
                valueCompare = 0;
                int hashCompare = hashValue[p];
                if (rlep <= 0) {
                    rlep = 1;
                }
                if (bot < 0) {
                    bot = 0;
                }
                if ((i = lastPair[(this.indata[p] & 0xFF) << 8 | this.indata[p + 1] & 0xFF] - 1) >= 0 && i >= (bot += rlep - 1)) {
                    int maxval = 2;
                    int maxpos = p - i;
                    for (i = lastPair[(this.indata[p + (rlep - 1)] & 0xFF) << 8 | this.indata[p + rlep] & 0xFF] - 1; i >= bot; i -= this.backSkip[i]) {
                        if (0 == rlep - 1 || this.rle[i - (rlep - 1)] == rlep) {
                            ++hashChecks;
                            if (hashValue[i + maxval - rlep - 1] == hashCompare || (this.indata[i + maxval - rlep + 1] & 0xFF) == valueCompare) {
                                a = i + 2;
                                b = p + rlep - 1 + 2;
                                topindex = this.inlen - (p + rlep - 1);
                                for (j = 2; j < topindex && this.indata[a++] == this.indata[b++]; ++j) {
                                }
                                ++hashEqual;
                                compares += j - 1;
                                if (j + rlep - 1 > maxval) {
                                    tmplen = j + rlep - 1;
                                    tmppos = p - i + rlep - 1;
                                    if (tmplen > this.maxlzlen) {
                                        tmplen = this.maxlzlen;
                                    }
                                    if (this.lzmlen[p] < tmplen) {
                                        this.lzmlen[p] = tmplen;
                                        this.lzmpos[p] = tmppos;
                                    }
                                    if (tmplen * 8 - this.LenLz(tmplen, tmppos) > maxval * 8 - this.LenLz(maxval, maxpos)) {
                                        maxval = tmplen;
                                        maxpos = tmppos;
                                        hashCompare = hashValue[p + maxval - 2];
                                    }
                                    if (maxval == this.maxlzlen) break;
                                }
                            }
                        }
                        if (0 == this.backSkip[i]) break;
                    }
                    if (p != 0 && this.rle[p - 1] > maxval) {
                        maxval = this.rle[p - 1] - 1;
                        maxpos = 1;
                    }
                    if (maxval < this.maxlzlen && rlep > maxval) {
                        bot = p - lzsz;
                        if (bot < 0) {
                            bot = 0;
                        }
                        for (i = lastPair[(this.indata[p] & 0xFF) * 257] - 1; i >= bot; i -= this.backSkip[i]) {
                            if (this.elr[i] + 2 > maxval) {
                                maxval = Math.min(this.elr[i] + 2, rlep);
                                maxpos = p - i + (maxval - 2);
                                if (maxval == rlep) break;
                            }
                            if (0 == this.backSkip[i -= this.elr[i]]) break;
                        }
                    }
                    if (p + maxval > this.inlen) {
                        System.err.printf("Error @ %d, lzlen %d, pos %d - exceeds inlen\n", p, maxval, maxpos);
                        maxval = this.inlen - p;
                    }
                    if (this.lzmlen[p] < maxval) {
                        this.lzmlen[p] = maxval;
                        this.lzmpos[p] = maxpos;
                    }
                    if (maxpos <= 256 || maxval > 2) {
                        if (maxpos < 0) {
                            System.err.printf("Error @ %d, lzlen %d, pos %d\n", p, maxval, maxpos);
                        }
                        this.lzlen[p] = maxval < this.maxlzlen ? maxval : this.maxlzlen;
                        this.lzpos[p] = maxpos;
                    }
                }
            }
            if ((type & 0x200) != 0 && p + this.rle[p] + 1 < this.inlen) {
                for (int rot = 1; rot < 255; ++rot) {
                    int bot = p - 256;
                    int rlep = this.rle[p];
                    valueCompare = (this.indata[p + 2] & 0xFF) + rot & 0xFF;
                    if (rlep <= 0) {
                        rlep = 1;
                    }
                    if (bot < 0) {
                        bot = 0;
                    }
                    if ((i = lastPair[((this.indata[p] & 0xFF) + rot & 0xFF) << 8 | (this.indata[p + 1] & 0xFF) + rot & 0xFF] - 1) < 0 || i < (bot += rlep - 1)) continue;
                    int maxval = 2;
                    int maxpos = p - i;
                    for (i = lastPair[((this.indata[p + (rlep - 1)] & 0xFF) + rot & 0xFF) << 8 | (this.indata[p + rlep] & 0xFF) + rot & 0xFF] - 1; i >= bot; i -= this.backSkip[i]) {
                        if (0 == rlep - 1 || this.rle[i - (rlep - 1)] == rlep) {
                            ++hashChecks;
                            if ((this.indata[i + maxval - rlep + 1] & 0xFF) == valueCompare) {
                                a = i + 2;
                                b = p + rlep - 1 + 2;
                                topindex = this.inlen - (p + rlep - 1);
                                for (j = 2; j < topindex && (this.indata[a++] & 0xFF) == ((this.indata[b++] & 0xFF) + rot & 0xFF); ++j) {
                                }
                                ++hashEqual;
                                compares += j - 1;
                                if (j + rlep - 1 > maxval) {
                                    tmplen = j + rlep - 1;
                                    tmppos = p - i + rlep - 1;
                                    if (tmplen > this.maxlzlen) {
                                        tmplen = this.maxlzlen;
                                    }
                                    if (tmplen * 8 - this.LenLz(tmplen, tmppos) > maxval * 8 - this.LenLz(maxval, maxpos)) {
                                        maxval = tmplen;
                                        maxpos = tmppos;
                                        valueCompare = (this.indata[p + maxval] & 0xFF) + rot & 0xFF;
                                    }
                                    if (maxval == this.maxlzlen) break;
                                }
                            }
                        }
                        if (0 == this.backSkip[i]) break;
                    }
                    if (p + maxval > this.inlen) {
                        System.err.printf("Error @ %d, lzlen %d, pos %d - exceeds inlen\n", p, maxval, maxpos);
                        maxval = this.inlen - p;
                    }
                    if (maxval <= 3 || maxpos > 256 || maxval <= this.lzlen2[p] && (maxval != this.lzlen2[p] || maxpos >= this.lzpos2[p])) continue;
                    if (maxpos < 0) {
                        System.err.printf("Error @ %d, lzlen %d, pos %d\n", p, maxval, maxpos);
                    }
                    this.lzlen2[p] = maxval < this.maxlzlen ? maxval : this.maxlzlen;
                    this.lzpos2[p] = maxpos;
                }
                if (this.lzlen2[p] <= this.lzlen[p] || this.lzlen2[p] <= this.rle[p]) {
                    this.lzpos2[p] = 0;
                    this.lzlen2[p] = 0;
                }
            }
            if (p + 1 >= this.inlen) continue;
            int index = (this.indata[p] & 0xFF) << 8 | this.indata[p + 1] & 0xFF;
            int ptr = p - (lastPair[index] - 1);
            if (ptr > p || ptr > 65535) {
                ptr = 0;
            }
            this.backSkip[p] = ptr;
            lastPair[index] = p + 1;
        }
        if ((flags & 0x200) != 0) {
            for (p = 1; p < this.inlen; ++p) {
                if (this.rle[p - 1] - 1 <= this.lzlen[p]) continue;
                this.lzlen[p] = this.rle[p] < this.maxlzlen ? this.rle[p] : this.maxlzlen;
                this.lzpos[p] = 1;
            }
            for (p = 0; p < this.inlen; ++p) {
                this.rle[p] = 0;
            }
        }
        System.err.printf("\rChecked: %d \n", p);
        this.InitRle(flags);
        if ((flags & 4) != 0) {
            int escaped;
            System.err.printf("Selecting the number of escape bits.. ", new Object[0]);
            int mb = 0;
            int mv = 16000000;
            this.escBits = 1;
            while (this.escBits < 9) {
                int other = 0;
                this.escMask = 65280 >> this.escBits & 0xFF;
                this.OptimizeLength(0);
                IntContainer escapeCont = new IntContainer(escape);
                IntContainer otherCont = new IntContainer(other);
                escaped = this.OptimizeEscape(escapeCont, otherCont);
                escape = escapeCont.intVal;
                other = otherCont.intVal;
                int c = (this.escBits + 3) * escaped + other * this.escBits;
                if ((flags & 2) != 0) {
                    System.err.printf(" %d:%d", this.escBits, c);
                }
                if (c >= mv) break;
                mb = this.escBits;
                mv = c;
                if (this.escBits == 4 && (flags & 2) != 0) {
                    System.err.printf("\n", new Object[0]);
                }
                ++this.escBits;
            }
            if (mb == 1) {
                this.escBits = 0;
                this.escMask = 0;
                this.OptimizeLength(0);
                IntContainer escapeCont = new IntContainer(escape);
                escaped = this.OptimizeEscape(escapeCont, null);
                escape = escapeCont.intVal;
                if ((flags & 2) != 0) {
                    System.err.printf(" %d:%d", this.escBits, 3 * escaped);
                }
                if (3 * escaped < mv) {
                    mb = 0;
                }
            }
            if ((flags & 2) != 0) {
                System.err.printf("\n", new Object[0]);
            }
            System.err.printf("Selected %d-bit escapes\n", mb);
            this.escBits = mb;
            this.escMask = 65280 >> this.escBits & 0xFF;
        }
        if (0 == (flags & 8)) {
            System.err.printf("Optimizing LZ77 and RLE lengths...", new Object[0]);
        }
        this.OptimizeLength((flags & 8) != 0 ? 0 : 1);
        if ((flags & 2) != 0) {
            if (0 == (flags & 8)) {
                System.err.printf(" gained %d units.\n", this.lzopt / 8);
            }
        } else {
            System.err.printf("\n", new Object[0]);
        }
        if ((flags & 0x10) != 0) {
            int[] lzstat = new int[]{0, 0, 0, 0, 0};
            int cur = 0;
            int old = this.extraLZPosBits;
            System.err.printf("Selecting LZPOS LO length.. ", new Object[0]);
            p = 0;
            block46: while (p < this.inlen) {
                switch (this.mode[p]) {
                    case 1: {
                        this.extraLZPosBits = 0;
                        lzstat[0] = lzstat[0] + this.LenLz(this.lzlen[p], this.lzpos[p]);
                        this.extraLZPosBits = 1;
                        lzstat[1] = lzstat[1] + this.LenLz(this.lzlen[p], this.lzpos[p]);
                        this.extraLZPosBits = 2;
                        lzstat[2] = lzstat[2] + this.LenLz(this.lzlen[p], this.lzpos[p]);
                        this.extraLZPosBits = 3;
                        lzstat[3] = lzstat[3] + this.LenLz(this.lzlen[p], this.lzpos[p]);
                        this.extraLZPosBits = 4;
                        lzstat[4] = lzstat[4] + this.LenLz(this.lzlen[p], this.lzpos[p]);
                        p += this.lzlen[p];
                        continue block46;
                    }
                    case 3: {
                        p += this.lzlen2[p];
                        continue block46;
                    }
                    case 2: {
                        p += this.rle[p];
                        continue block46;
                    }
                }
                ++p;
            }
            for (i = 0; i < 5; ++i) {
                if ((flags & 2) != 0) {
                    System.err.printf(" %d:%d", i + 8, lzstat[i]);
                }
                if (lzstat[i] >= lzstat[cur]) continue;
                cur = i;
            }
            int n = this.extraLZPosBits = (flags & 0x10) != 0 ? cur : old;
            if ((flags & 2) != 0) {
                System.err.printf("\n", new Object[0]);
            }
            System.err.printf("Selected %d-bit LZPOS LO part\n", this.extraLZPosBits + 8);
            if (cur != old) {
                System.err.printf("Note: Using option -p%d you may get better results.\n", cur);
            }
            if (this.extraLZPosBits != old) {
                this.OptimizeLength((flags & 8) != 0 ? 0 : 1);
            }
        }
        int[] stat = new int[]{0, 0, 0, 0};
        p = 0;
        block48: while (p < this.inlen) {
            switch (this.mode[p]) {
                case 1: {
                    if ((this.lzpos[p] >> 8) + 1 > 1 << this.maxGamma) {
                        stat[3] = stat[3] + 1;
                    }
                    if (this.lzlen[p] > 1 << this.maxGamma) {
                        stat[0] = stat[0] + 1;
                    }
                    p += this.lzlen[p];
                    continue block48;
                }
                case 2: {
                    if (this.rle[p] > 1 << this.maxGamma - 1 && this.rle[p] <= 1 << this.maxGamma) {
                        stat[1] = stat[1] + 1;
                    }
                    p += this.rle[p];
                    continue block48;
                }
                case 3: {
                    p += this.lzlen2[p];
                    continue block48;
                }
            }
            ++p;
        }
        if (this.maxGamma < 7 && stat[0] + stat[1] + stat[3] > 10) {
            System.err.printf("Note: Using option -m%d you may get better results.\n", this.maxGamma + 1);
        }
        if (this.maxGamma > 5 && stat[0] + stat[1] + stat[3] < 4) {
            System.err.printf("Note: Using option -m%d you may get better results.\n", this.maxGamma - 1);
        }
        IntContainer escapeCont = new IntContainer(escape);
        this.OptimizeEscape(escapeCont, null);
        escape = escapeCont.intVal;
        if (startEscape != null) {
            startEscape.intVal = escape;
        }
        this.OptimizeRle(flags);
        if ((flags & 1) != 0) {
            int oldEscape = escape;
            System.out.printf("normal RLE  LZLEN LZPOS(absolute)\n\n", new Object[0]);
            p = 0;
            block49: while (p < this.inlen) {
                switch (this.mode[p]) {
                    case 1: {
                        int n = p - this.lzpos[p];
                        this.mode[n] = this.mode[n] | 4;
                        p += this.lzlen[p];
                        continue block49;
                    }
                    case 2: {
                        p += this.rle[p];
                        continue block49;
                    }
                    case 3: {
                        int n = p - this.lzpos2[p];
                        this.mode[n] = this.mode[n] | 4;
                        p += this.lzlen2[p];
                        continue block49;
                    }
                }
                ++p;
            }
            j = 0;
            p = 0;
            while (p < this.inlen) {
                switch (this.mode[p]) {
                    case 3: 
                    case 7: {
                        if (j == p) {
                            System.out.printf(">", new Object[0]);
                            j += this.lzlen2[p];
                        } else {
                            System.out.printf(" ", new Object[0]);
                        }
                        if (this.lzpos2 != null) {
                            System.out.printf(" %04x*%03d*+%02x", this.lzpos2[p], this.lzlen2[p], (this.indata[p] & 0xFF) - (this.indata[p - this.lzpos2[p]] & 0xFF) & 0xFF);
                        }
                        System.out.printf(" 001   %03d   %03d  %04x(%04x)  %02x %s\n", this.rle[p], this.lzlen[p], this.lzpos[p], p - this.lzpos[p], this.indata[p] & 0xFF, (this.mode[p] & 4) != 0 ? "#" : " ");
                        break;
                    }
                    case 0: 
                    case 4: {
                        if (j == p) {
                            System.out.printf(">", new Object[0]);
                        } else {
                            System.out.printf(" ", new Object[0]);
                        }
                        if (this.lzpos2 != null) {
                            System.out.printf(" %04x %03d +%02x", this.lzpos2[p], this.lzlen2[p], (this.indata[p] & 0xFF) - (this.indata[p - this.lzpos2[p]] & 0xFF) & 0xFF);
                        }
                        if (j == p) {
                            System.out.printf("*001*  %03d   %03d  %04x(%04x)  %02x %s %02x", this.rle[p], this.lzlen[p], this.lzpos[p], p - this.lzpos[p], this.indata[p] & 0xFF, (this.mode[p] & 4) != 0 ? "#" : " ", this.newesc[p] & 0xFF);
                            if ((this.indata[p] & this.escMask) == escape) {
                                escape = this.newesc[p] & 0xFF;
                                System.out.printf("\u00ab", new Object[0]);
                            }
                            System.out.printf("\n", new Object[0]);
                            ++j;
                            break;
                        }
                        System.out.printf("*001*  %03d   %03d  %04x(%04x)  %02x %s %02x\n", this.rle[p], this.lzlen[p], this.lzpos[p], p - this.lzpos[p], this.indata[p] & 0xFF, (this.mode[p] & 4) != 0 ? "#" : " ", this.newesc[p] & 0xFF);
                        break;
                    }
                    case 1: 
                    case 5: {
                        if (j == p) {
                            System.out.printf(">", new Object[0]);
                            j += this.lzlen[p];
                        } else {
                            System.out.printf(" ", new Object[0]);
                        }
                        if (this.lzpos2 != null) {
                            System.out.printf(" %04x %03d +%02x", this.lzpos2[p], this.lzlen2[p], (this.indata[p] & 0xFF) - (this.indata[p - this.lzpos2[p]] & 0xFF) & 0xFF);
                        }
                        System.out.printf(" 001   %03d  *%03d* %04x(%04x)  %02x %s", this.rle[p], this.lzlen[p], this.lzpos[p], p - this.lzpos[p], this.indata[p] & 0xFF, (this.mode[p] & 4) != 0 ? "#" : " ");
                        System.out.printf("\n", new Object[0]);
                        break;
                    }
                    case 2: 
                    case 6: {
                        if (j == p) {
                            System.out.printf(">", new Object[0]);
                            j += this.rle[p];
                        } else {
                            System.out.printf(" ", new Object[0]);
                        }
                        if (this.lzpos2 != null) {
                            System.out.printf(" %04x %03d +%02x", this.lzpos2[p], this.lzlen2[p], (this.indata[p] & 0xFF) - (this.indata[p - this.lzpos2[p]] & 0xFF) & 0xFF);
                        }
                        System.out.printf(" 001  *%03d*  %03d  %04x(%04x)  %02x %s\n", this.rle[p], this.lzlen[p], this.lzpos[p], p - this.lzpos[p], this.indata[p] & 0xFF, (this.mode[p] & 4) != 0 ? "#" : " ");
                        break;
                    }
                    default: {
                        ++j;
                    }
                }
                int n = p++;
                this.mode[n] = this.mode[n] & 0xFFFFFFFB;
            }
            escape = oldEscape;
        }
        int esc = escape;
        p = 0;
        block51: while (p < this.inlen) {
            switch (this.mode[p]) {
                case 0: {
                    if ((this.indata[p] & this.escMask) == esc) {
                        esc = this.newesc[p] & 0xFF;
                    }
                    ++p;
                    continue block51;
                }
                case 3: {
                    p += this.lzlen2[p];
                    continue block51;
                }
                case 1: {
                    if (this.lzopt != 0 && this.lzlen[p] > 2) {
                        int bot = p - this.lzpos[p] + 1;
                        int rlep = this.rle[p];
                        if (0 == rlep) {
                            rlep = 1;
                        }
                        if (bot < 0) {
                            bot = 0;
                        }
                        bot += rlep - 1;
                        for (i = p - this.backSkip[p]; i >= bot; i -= this.backSkip[i]) {
                            if (rlep == 1 || this.rle[i - rlep + 1] == rlep) {
                                a = i + 1;
                                int b = p + rlep - 1 + 1;
                                int topindex = this.inlen - (p + rlep - 1);
                                for (j = 1; j < topindex && this.indata[a++] == this.indata[b++]; ++j) {
                                }
                                if (j + rlep - 1 >= this.lzlen[p]) {
                                    int tmppos = p - i + rlep - 1;
                                    rescan += this.LenLz(this.lzlen[p], this.lzpos[p]) - this.LenLz(this.lzlen[p], tmppos);
                                    this.lzpos[p] = tmppos;
                                    break;
                                }
                            }
                            if (0 == this.backSkip[i]) break;
                        }
                    }
                    p += this.lzlen[p];
                    continue block51;
                }
                case 2: {
                    p += this.rle[p];
                    continue block51;
                }
            }
            System.err.printf("Internal error: mode %d\n", this.mode[p]);
            ++p;
        }
        p = 0;
        block54: while (p < this.inlen) {
            switch (this.mode[p]) {
                case 0: {
                    this.length[p] = this.outPointer;
                    escapeCont = new IntContainer(escape);
                    this.OutputNormal(escapeCont, this.indata, p, this.newesc[p] & 0xFF);
                    escape = escapeCont.intVal;
                    ++p;
                    continue block54;
                }
                case 3: {
                    for (i = 0; i < this.lzlen2[p]; ++i) {
                        this.length[p + i] = this.outPointer;
                    }
                    escapeCont = new IntContainer(escape);
                    this.OutputDLz(escapeCont, this.lzlen2[p], this.lzpos2[p], (this.indata[p] & 0xFF) - (this.indata[p - this.lzpos2[p]] & 0xFF) & 0xFF);
                    escape = escapeCont.intVal;
                    p += this.lzlen2[p];
                    continue block54;
                }
                case 1: {
                    for (i = 0; i < this.lzlen[p]; ++i) {
                        this.length[p + i] = this.outPointer;
                    }
                    escapeCont = new IntContainer(escape);
                    this.OutputLz(escapeCont, this.lzlen[p], this.lzpos[p], this.indata, p - this.lzpos[p], p);
                    escape = escapeCont.intVal;
                    p += this.lzlen[p];
                    continue block54;
                }
                case 2: {
                    for (i = 0; i < this.rle[p]; ++i) {
                        this.length[p + i] = this.outPointer;
                    }
                    escapeCont = new IntContainer(escape);
                    this.OutputRle(escapeCont, this.indata, p, this.rle[p]);
                    escape = escapeCont.intVal;
                    p += this.rle[p];
                    continue block54;
                }
            }
            System.err.printf("Internal error: mode %d\n", this.mode[p]);
            ++p;
        }
        escapeCont = new IntContainer(escape);
        this.OutputEof(escapeCont);
        escape = escapeCont.intVal;
        i = this.inlen;
        for (p = 0; p < this.inlen; ++p) {
            int pos = this.inlen - this.outPointer + this.length[p] - p;
            i = Math.min(i, pos);
        }
        this.reservedBytes = i < 0 ? -i + 2 : 0;
        if (this.BIG && type == 0) {
            headerSize = 16 + this.rleUsed;
        } else {
            type = endAddr + this.reservedBytes + 3 > memEnd ? (type |= 0x100) : (type &= 0xFFFFFEFF);
            headerSize = this.GetHeaderSize(type, null) + this.rleUsed - 15;
        }
        int outlen = this.outPointer + headerSize;
        System.err.printf("In: %d, out: %d, ratio: %5.2f%% (%4.2f[%4.2f] b/B), gained: %5.2f%%\n", this.inlen, outlen, (double)outlen * 100.0 / (double)this.inlen + 0.005, 8.0 * (double)outlen / (double)this.inlen + 0.005, 8.0 * (double)(outlen - headerSize + this.rleUsed + 4) / (double)this.inlen + 0.005, 100.0 - (double)outlen * 100.0 / (double)this.inlen + 0.005);
        if ((type & 0x200) != 0) {
            System.err.printf("Gained RLE: %d (S+L:%d+%d), DLZ: %d, LZ: %d, Esc: %d, Decompressor: %d\n", this.gainedRle / 8, this.gainedSRle / 8, this.gainedLRle / 8, this.gainedDLz / 8, this.gainedLz / 8, -this.gainedEscaped / 8, -headerSize);
            System.err.printf("Times  RLE: %d (%d+%d), DLZ: %d, LZ: %d, Esc: %d (normal: %d), %d escape bit%s\n", this.timesRle, this.timesSRle, this.timesLRle, this.timesDLz, this.timesLz, this.timesEscaped, this.timesNormal, this.escBits, this.escBits == 1 ? "" : "s");
        } else {
            System.err.printf("Gained RLE: %d (S+L:%d+%d), LZ: %d, Esc: %d, Decompressor: %d\n", this.gainedRle / 8, this.gainedSRle / 8, this.gainedLRle / 8, this.gainedLz / 8, -this.gainedEscaped / 8, -headerSize);
            System.err.printf("Times  RLE: %d (%d+%d), LZ: %d, Esc: %d (normal: %d), %d escape bit%s\n", this.timesRle, this.timesSRle, this.timesLRle, this.timesLz, this.timesEscaped, this.timesNormal, this.escBits, this.escBits == 1 ? "" : "s");
        }
        if ((flags & 2) != 0) {
            String[] ll = new String[]{"2", "3-4", "5-8", "9-16", "17-32", "33-64", "65-128", "129-256"};
            System.err.printf("(Gained by RLE Code: %d, LZPOS LO Bits %d, maxLen: %d, tag bit/prim. %4.2f)\n", this.gainedRlecode / 8 - this.rleUsed, this.extraLZPosBits + 8, 2 << this.maxGamma, (double)((this.timesRle + this.timesLz) * this.escBits + this.timesEscaped * (this.escBits + 3)) / (double)(this.timesRle + this.timesLz + this.timesNormal) + 0.0049);
            System.err.printf("   LZPOS HI+2 LZLEN S-RLE RLEcode\n", new Object[0]);
            System.err.printf("   ------------------------------\n", new Object[0]);
            for (i = 0; i <= this.maxGamma; ++i) {
                System.err.printf("%-7s %5d %5d", ll[i], this.lenStat[i][0], this.lenStat[i][1]);
                if (i < this.maxGamma) {
                    System.err.printf(" %5d", this.lenStat[i][2]);
                } else {
                    System.err.printf("     -", new Object[0]);
                }
                if (i < 5) {
                    System.err.printf("   %5d%s\n", this.lenStat[i][3], i == 4 ? "*" : "");
                    continue;
                }
                System.err.printf("       -\n", new Object[0]);
            }
            System.err.printf("LZ77 rescan gained %d bytes\n", rescan / 8);
            System.err.printf("Hash Checks %d (%d, %4.2f%% equal), RLE/LZ compares %d\n", hashChecks, hashEqual, 100.0 * (double)hashEqual / (double)hashChecks, compares);
        }
        return 0;
    }

    public int run(String[] argv) throws IOException {
        int memEnd;
        int memStart;
        String machineTypeTxt;
        InputStream infp;
        int n;
        int execAddr = -1;
        int ea = -1;
        int startAddr = -1;
        int flags = 64;
        int lzlen = -1;
        String fileIn = null;
        String fileOut = null;
        byte[] tmp = new byte[2];
        long timeused = System.currentTimeMillis();
        int machineType = 64;
        int type = 0;
        this.lrange = this.LRANGE;
        this.maxlzlen = this.MAXLZLEN;
        this.maxrlelen = this.MAXRLELEN;
        this.InitValueLen();
        flags |= 0x14;
        for (n = 0; n < argv.length; ++n) {
            if (argv[n].equals("-flist")) {
                System.out.printf("List of Decompressors:\n", new Object[0]);
                System.out.printf("----------------------\n", new Object[0]);
                this.ListDecompressors(System.out);
                return -1;
            }
            if (argv[n].equals("-ffast")) {
                type |= 0x800;
                continue;
            }
            if (argv[n].equals("-fnorle")) {
                flags |= 0x200;
                continue;
            }
            if (argv[n].equals("-fshort")) {
                type |= 0x1000;
                continue;
            }
            if (argv[n].equals("-fbasic")) {
                type |= 0x400;
                continue;
            }
            if (argv[n].equals("-fdelta")) {
                type |= 0x200;
                continue;
            }
            if (argv[n].equals("+f")) {
                flags &= 0xFFFFFFBF;
                continue;
            }
            if (argv[n].startsWith("-")) {
                block33: for (int i = 1; i < argv[n].length(); ++i) {
                    switch (argv[n].charAt(i)) {
                        case 'u': {
                            flags |= 0x4000;
                            continue block33;
                        }
                        case 'd': {
                            flags |= 0x20;
                            continue block33;
                        }
                        case 'n': {
                            flags |= 8;
                            continue block33;
                        }
                        case 's': {
                            flags |= 2;
                            continue block33;
                        }
                        case 'v': {
                            flags |= 1;
                            continue block33;
                        }
                        case 'f': {
                            flags |= 0x40;
                            continue block33;
                        }
                        case 'a': {
                            flags |= 0x80;
                            continue block33;
                        }
                        case '?': 
                        case 'h': {
                            flags |= 0x8000;
                            continue block33;
                        }
                        case 'c': 
                        case 'e': 
                        case 'g': 
                        case 'i': 
                        case 'l': 
                        case 'm': 
                        case 'p': 
                        case 'r': 
                        case 'x': {
                            int tmpval;
                            String val;
                            char c = argv[n].charAt(i);
                            if (i + 1 < argv[n].length()) {
                                val = argv[n].substring(i + 1);
                            } else if (n + 1 < argv.length) {
                                val = argv[n + 1];
                                ++n;
                            } else {
                                flags |= 0x8000;
                                continue block33;
                            }
                            i = argv[n].length() - 1;
                            try {
                                tmpval = val.startsWith("$") ? Integer.parseInt(val.substring(1), 16) : Integer.parseInt(val.substring(1));
                            }
                            catch (NumberFormatException e) {
                                System.err.printf("Error: invalid number: \"%s\"\n", val);
                                flags |= 0x8000;
                                continue block33;
                            }
                            switch (c) {
                                case 'r': {
                                    lzlen = tmpval;
                                    break;
                                }
                                case 'x': {
                                    ea = tmpval;
                                    break;
                                }
                                case 'm': {
                                    this.maxGamma = tmpval;
                                    if (this.maxGamma < 5 || this.maxGamma > 7) {
                                        System.err.printf("Max length must be 5..7!\n", new Object[0]);
                                        flags |= 0x8000;
                                        this.maxGamma = 7;
                                    }
                                    this.lrange = this.LRANGE;
                                    this.maxlzlen = this.MAXLZLEN;
                                    this.maxrlelen = this.MAXRLELEN;
                                    this.InitValueLen();
                                    break;
                                }
                                case 'e': {
                                    this.escBits = tmpval;
                                    if (this.escBits < 0 || this.escBits > 8) {
                                        System.err.printf("Escape bits must be 0..8!\n", new Object[0]);
                                        flags |= 0x8000;
                                    } else {
                                        flags &= 0xFFFFFFFB;
                                    }
                                    this.escMask = 65280 >> this.escBits & 0xFF;
                                    break;
                                }
                                case 'p': {
                                    this.extraLZPosBits = tmpval;
                                    if (this.extraLZPosBits < 0 || this.extraLZPosBits > 4) {
                                        System.err.printf("Extra LZ-pos bits must be 0..4!\n", new Object[0]);
                                        flags |= 0x8000;
                                        break;
                                    }
                                    flags &= 0xFFFFFFEF;
                                    break;
                                }
                                case 'l': {
                                    startAddr = tmpval;
                                    if (startAddr >= 0 && startAddr <= 65535) break;
                                    System.err.printf("Load address must be 0..0xffff!\n", new Object[0]);
                                    flags |= 0x8000;
                                    break;
                                }
                                case 'c': {
                                    machineType = tmpval;
                                    if (machineType == 64 || machineType == 20 || machineType == 16 || machineType == 4 || machineType == 128 || machineType == 0) break;
                                    System.err.printf("Machine must be 64, 20, 16/4, 128!\n", new Object[0]);
                                    flags |= 0x8000;
                                    break;
                                }
                                case 'i': {
                                    if (tmpval == 0) {
                                        this.intConfig = 120;
                                        break;
                                    }
                                    this.intConfig = 88;
                                    break;
                                }
                                case 'g': {
                                    this.memConfig = tmpval & 0xFF;
                                }
                            }
                            continue block33;
                        }
                        default: {
                            System.err.printf("Error: Unknown option \"%c\"\n", Character.valueOf(argv[n].charAt(i)));
                            flags |= 0x8000;
                        }
                    }
                }
                continue;
            }
            if (null == fileIn) {
                fileIn = argv[n];
                continue;
            }
            if (null == fileOut) {
                fileOut = argv[n];
                continue;
            }
            System.err.printf("Only two filenames wanted!\n", new Object[0]);
            flags |= 0x8000;
        }
        if ((flags & 0x8000) != 0) {
            System.err.printf("Usage: %s [-<flags>] [<infile> [<outfile>]]\n", argv[0]);
            System.err.printf("\t -flist    list all decompressors\n\t -ffast    select faster version, if available (longer)\n\t -fshort   select shorter version, if available (slower)\n\t -fbasic   select version for BASIC programs (for VIC20 and C64)\n\t -fdelta   use delta-lz77 -- shortens some files\n\t -f        enable fast mode for C128 (C64 mode) and C16/+4 (default)\n\t +f        disable fast mode for C128 (C64 mode) and C16/+4\n\t c<val>    machine: 64 (C64), 20 (VIC20), 16 (C16/+4)\n\t a         avoid video matrix (for VIC20)\n\t d         data (no loading address)\n\t l<val>    set/override load address\n\t x<val>    set execution address\n\t e<val>    force escape bits\n\t r<val>    restrict lz search range\n\t n         no RLE/LZ length optimization\n\t s         full statistics\n\t v         verbose\n\t p<val>    force extralzposbits\n\t m<val>    max len 5..7 (2*2^5..2*2^7)\n\t i<val>    interrupt enable after decompress (0=disable)\n\t g<val>    memory configuration after decompress\n\t u         unpack\n", new Object[0]);
            return -1;
        }
        if (lzlen == -1) {
            lzlen = this.DEFAULT_LZLEN;
        }
        if (fileIn != null) {
            try {
                infp = new FileInputStream(new File(fileIn));
            }
            catch (IOException e) {
                System.err.printf("Could not open %s for reading!\n", fileIn);
                return -1;
            }
        } else {
            System.err.printf("Reading from stdin\n", new Object[0]);
            infp = System.in;
        }
        if (0 == (flags & 0x20)) {
            infp.read(tmp, 0, 2);
            if (startAddr == -1) {
                startAddr = (tmp[0] & 0xFF) + 256 * (tmp[1] & 0xFF);
            }
        }
        if (startAddr == -1) {
            startAddr = 600;
        }
        this.inlen = 0;
        int buflen = 0;
        this.indata = null;
        while (true) {
            int newlen;
            if (buflen < this.inlen + this.lrange) {
                tmp = new byte[buflen + this.lrange];
                if (this.indata != null) {
                    System.arraycopy(this.indata, 0, tmp, 0, buflen);
                }
                this.indata = tmp;
                buflen += this.lrange;
            }
            if ((newlen = infp.read(this.indata, this.inlen, this.lrange)) <= 0) break;
            this.inlen += newlen;
        }
        if (infp != System.in) {
            infp.close();
        }
        if ((flags & 0x4000) != 0) {
            n = this.UnPack(startAddr, this.indata, fileOut, flags);
            return n;
        }
        if (startAddr < 600 && (this.BIG || startAddr + this.inlen - 1 > 65535)) {
            System.err.printf("Only programs from 0x0258 to 0xffff can be compressed\n", new Object[0]);
            System.err.printf("(the input file is from 0x%04x to 0x%04x)\n", startAddr, startAddr + this.inlen - 1);
            return -1;
        }
        switch (machineType) {
            case 20: {
                machineTypeTxt = "VIC20 with 8k or 16k (or 24k) expansion memory";
                memStart = 4609;
                memEnd = 16384;
                type |= 0x102;
                if (startAddr + this.inlen > 32768) {
                    System.err.printf("Original file exceeds 0x8000 (0x%04x), not a valid VIC20 file!\n", startAddr + this.inlen - 1);
                    n = -1;
                    return n;
                }
                if (startAddr + this.inlen > 24576) {
                    if (startAddr < 4096) {
                        System.err.printf("Original file exceeds 0x6000 (0x%04x), 3kB+24kB memory expansions assumed\n", startAddr + this.inlen - 1);
                        machineTypeTxt = "VIC20 with 3k+24k expansion memory";
                    } else {
                        System.err.printf("Original file exceeds 0x6000 (0x%04x), 24kB memory expansion assumed\n", startAddr + this.inlen - 1);
                        machineTypeTxt = "VIC20 with 24k expansion memory";
                    }
                    memEnd = 32768;
                    break;
                }
                if (startAddr + this.inlen > 16384) {
                    if (startAddr < 4096) {
                        System.err.printf("Original file exceeds 0x4000 (0x%04x), 3kB+16kB memory expansion assumed\n", startAddr + this.inlen - 1);
                        machineTypeTxt = "VIC20 with 3k+16k (or 3k+24k) expansion memory";
                    } else {
                        System.err.printf("Original file exceeds 0x4000 (0x%04x), 16kB memory expansion assumed\n", startAddr + this.inlen - 1);
                        machineTypeTxt = "VIC20 with 16k (or 24k) expansion memory";
                    }
                    memEnd = 24576;
                    break;
                }
                if (startAddr + this.inlen > 8192) {
                    if (startAddr < 4096) {
                        System.err.printf("Original file exceeds 0x2000 (0x%04x), 3kB+8kB memory expansion assumed\n", startAddr + this.inlen - 1);
                        machineTypeTxt = "VIC20 with 3k+8k (or 3k+16k, or 3k+24k) expansion memory";
                        break;
                    }
                    System.err.printf("Original file exceeds 0x2000 (0x%04x), 8kB memory expansion assumed\n", startAddr + this.inlen - 1);
                    break;
                }
                if (startAddr >= 4096 && startAddr < 4608) {
                    System.err.printf("Program for unexpanded VIC detected.\n", new Object[0]);
                    memStart = 4097;
                    memEnd = (flags & 0x80) != 0 ? 7680 : 8192;
                    machineTypeTxt = "VIC20 without expansion memory";
                }
                if (startAddr < 1024 || startAddr >= 4096) break;
                System.err.printf("Program for 3k-expanded VIC detected.\n", new Object[0]);
                memStart = 1025;
                memEnd = (flags & 0x80) != 0 ? 7680 : 8192;
                machineTypeTxt = "VIC20 with 3k expansion memory";
                break;
            }
            case 4: 
            case 16: {
                type |= 0x104;
                if (startAddr + this.inlen > 16384) {
                    System.err.printf("Original file exceeds 0x4000, 61k RAM assumed\n", new Object[0]);
                    memStart = 4097;
                    memEnd = 64768;
                    machineTypeTxt = "Plus/4";
                    break;
                }
                System.err.printf("Program for unexpanded C16 detected.\n", new Object[0]);
                memStart = 4097;
                memEnd = 16384;
                machineTypeTxt = "Commodore 16";
                break;
            }
            case 128: {
                type |= 0x108;
                memStart = 7169;
                memEnd = 65536;
                machineTypeTxt = "Commodore 128";
                break;
            }
            case 0: {
                type |= 0;
                machineTypeTxt = "Without decompressor";
                memStart = 2049;
                memEnd = 65536;
                break;
            }
            default: {
                type |= 0x101;
                machineTypeTxt = "Commodore 64";
                memStart = 2049;
                memEnd = 65536;
            }
        }
        if (startAddr <= memStart) {
            for (n = memStart - startAddr; n < memStart - startAddr + 60; ++n) {
                if (this.indata[n] != -98) continue;
                execAddr = 0;
                ++n;
                while (this.indata[n] == 40 || this.indata[n] == 32) {
                    ++n;
                }
                while (this.indata[n] >= 48 && this.indata[n] <= 57) {
                    execAddr = execAddr * 10 + this.indata[n++] - 48;
                }
                break;
            }
        }
        if (ea != -1) {
            if (execAddr != -1 && ea != execAddr) {
                System.err.printf("Discarding execution address 0x%04x=%d\n", execAddr, execAddr);
            }
            execAddr = ea;
        } else if (execAddr < startAddr || execAddr >= startAddr + this.inlen) {
            if ((type & 0x400) != 0) {
                execAddr = 42926;
            } else {
                System.err.printf("Note: The execution address was not detected correctly!\n", new Object[0]);
                System.err.printf("      Use the -x option to set the execution address.\n", new Object[0]);
            }
        }
        System.err.printf("Load address 0x%04x=%d, Last byte 0x%04x=%d\n", startAddr, startAddr, startAddr + this.inlen - 1, startAddr + this.inlen - 1);
        System.err.printf("Exec address 0x%04x=%d\n", execAddr, execAddr);
        System.err.printf("New load address 0x%04x=%d\n", memStart, memStart);
        if (machineType == 64) {
            System.err.printf("Interrupts %s and memory config set to $%02x after decompression\n", this.intConfig == 88 ? "enabled" : "disabled", this.memConfig);
            System.err.printf("Runnable on %s\n", machineTypeTxt);
        } else if (machineType != 0) {
            System.err.printf("Interrupts %s after decompression\n", this.intConfig == 88 ? "enabled" : "disabled");
            System.err.printf("Runnable on %s\n", machineTypeTxt);
        } else {
            System.err.printf("Standalone decompressor required\n", new Object[0]);
        }
        IntContainer startEscapeCont = new IntContainer();
        n = this.PackLz77(lzlen, flags, startEscapeCont, startAddr + this.inlen, memEnd, type);
        int startEscape = startEscapeCont.intVal;
        if (0 == n) {
            int endAddr;
            int progEnd = endAddr = startAddr + this.inlen;
            IntContainer hDeCallCont = new IntContainer();
            if (this.GetHeaderSize(type, hDeCallCont) == 0) {
                this.GetHeaderSize(type & 0xFFFFFEFF, hDeCallCont);
            }
            int hDeCall = hDeCallCont.intVal;
            if (machineType != 0 && endAddr - (this.outPointer + 255 & 0xFFFFFF00) < memStart + hDeCall + 3) {
                System.err.printf("$%x < $%x, decompressor overwrite possible, moving upwards\n", endAddr - (this.outPointer + 255 & 0xFFFFFF00), memStart + hDeCall + 3);
                endAddr = memStart + hDeCall + 3 + (this.outPointer + 255 & 0xFFFFFF00);
            }
            endAddr += 3 + this.reservedBytes;
            if (this.BIG) {
                endAddr = 65536;
            }
            if (0 == this.timesDLz) {
                type &= 0xFFFFFDFF;
            }
            this.SavePack(type, this.outBuffer, this.outPointer, fileOut, startAddr, execAddr, startEscape, this.rleValues, endAddr, progEnd, this.extraLZPosBits, (flags & 0x40) != 0 ? 1 : 0, memStart, memEnd);
            timeused = System.currentTimeMillis() - timeused;
            if (0L == timeused) {
                ++timeused;
            }
            System.err.printf("Compressed %d bytes in %4.2f seconds (%4.2f kB/sec)\n", this.inlen, (double)timeused / 1000.0, 1000.0 * (double)this.inlen / (double)timeused / 1024.0);
        }
        return n;
    }

    public static void main(String[] args) {
        PUCrunch puCrunch = new PUCrunch();
        try {
            System.exit(puCrunch.run(args));
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static class IntContainer {
        int intVal;

        public IntContainer(int v) {
            this.intVal = v;
        }

        public IntContainer() {
        }
    }
}

