/*
 * Decompiled with CFR 0.152.
 */
package libsidutils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import libsidutils.stringsearch.BNDMWildcards;

public final class SidIdV2 {
    private static final String SID_ID_PKG = "libsidutils/";
    private static final String FNAME = "sidid.cfg";
    private static final int HEX_RADIX = 16;
    private static final int MAX_KEY_LENGTH = 32;
    private final BNDMWildcards search = new BNDMWildcards();
    private ArrayList<PlayerSection> sections;
    private boolean multiScan;

    public void setMultiScan(boolean m) {
        this.multiScan = m;
    }

    public ArrayList<String> identify(String filename) throws IOException {
        return this.identify(this.load(filename));
    }

    public ArrayList<String> identify(byte[] prg) {
        ArrayList<String> result = new ArrayList<String>();
        for (PlayerSection section : this.sections) {
            if (!this.matchOneOf(section.getOrList(), prg)) continue;
            result.add(section.getPlayerName());
            if (this.multiScan) continue;
            return result;
        }
        return result;
    }

    private boolean matchOneOf(ArrayList<ArrayList<Pattern>> orList, byte[] prg) {
        for (ArrayList<Pattern> andList : orList) {
            if (!this.matchAllOf(andList, prg)) continue;
            return true;
        }
        return false;
    }

    private boolean matchAllOf(ArrayList<Pattern> andList, byte[] prg) {
        int prgOffset = 0;
        for (Pattern pattern : andList) {
            int prgEnd = prg.length - prgOffset;
            if (pattern.isSubPattern() && (prgEnd = prgOffset + pattern.getPattern().length) > prg.length) {
                return false;
            }
            int index = this.search.searchBytes(prg, prgOffset, prgEnd, pattern.getPattern(), pattern.getPreProcessedPattern());
            if (index == -1) {
                return false;
            }
            prgOffset = index + pattern.getPattern().length;
        }
        return true;
    }

    private byte[] load(String name) throws IOException {
        DataInputStream in = new DataInputStream(new FileInputStream(name));
        int length = (int)new File(name).length();
        byte[] buffer = new byte[length];
        in.readFully(buffer);
        in.close();
        return buffer;
    }

    public void readconfig() {
        BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.readConfiguration())));
        this.sections = new ArrayList();
        PlayerSection section = null;
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                StringTokenizer stok = new StringTokenizer(line, " ");
                while (stok.hasMoreTokens()) {
                    String origToken = stok.nextToken();
                    String token = origToken.toLowerCase();
                    if (token.length() <= 0) continue;
                    if ("??".equals(token)) {
                        byteList.add((byte)63);
                        continue;
                    }
                    if ("end".equals(token)) {
                        assert (section != null);
                        this.andBytes(section, byteList);
                        ArrayList orList = new ArrayList();
                        section.getOrList().add(orList);
                        continue;
                    }
                    if ("and".equals(token)) {
                        assert (section != null);
                        this.andBytes(section, byteList);
                        continue;
                    }
                    if (token.length() == 2) {
                        byteList.add(Integer.valueOf(token, 16).byteValue());
                        continue;
                    }
                    if (section != null) {
                        section.getOrList().remove(section.getOrList().size() - 1);
                    }
                    section = new PlayerSection(origToken);
                    this.sections.add(section);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (section != null) {
            section.getOrList().remove(section.getOrList().size() - 1);
        }
    }

    private void andBytes(PlayerSection section, ArrayList<Byte> byteList) {
        ArrayList<Pattern> lastOr = section.getOrList().get(section.getOrList().size() - 1);
        int byteListOffset = 0;
        int byteCount = byteList.size();
        boolean isSubPattern = false;
        while (byteCount > 32) {
            this.andBytesMaxPtnLength(lastOr, byteList, byteListOffset, 32, isSubPattern);
            byteCount -= 32;
            byteListOffset += 32;
            isSubPattern = true;
        }
        this.andBytesMaxPtnLength(lastOr, byteList, byteListOffset, byteCount, isSubPattern);
        byteList.clear();
    }

    private void andBytesMaxPtnLength(ArrayList<Pattern> ptnList, ArrayList<Byte> byteList, int byteListOffset, int byteCount, boolean isSubPattern) {
        assert (byteCount < 32);
        byte[] and = new byte[byteCount];
        for (int i = 0; i < and.length; ++i) {
            and[i] = byteList.get(i + byteListOffset);
        }
        ptnList.add(new Pattern(and, this.search.processBytes(and, (byte)63), isSubPattern));
    }

    private byte[] readConfiguration() {
        File iniFilename = this.getLocation();
        if (iniFilename != null) {
            try {
                return this.load(iniFilename.getAbsolutePath());
            }
            catch (IOException e) {
                System.err.println("Read error: " + iniFilename);
                return this.readInternal();
            }
        }
        return this.readInternal();
    }

    private byte[] readInternal() {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("libsidutils/sidid.cfg");
        if (inputStream == null) {
            throw new RuntimeException("Internal SIDID not found: libsidutils/sidid.cfg");
        }
        try {
            int pos;
            int count;
            int length = inputStream.available();
            byte[] data = new byte[length];
            for (pos = 0; pos < length && (count = inputStream.read(data, pos, length - pos)) >= 0; pos += count) {
            }
            if (pos != length) {
                System.err.println("Internal SIDID was not loaded completely!");
            }
            byte[] byArray = data;
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Internal SIDID not found: libsidutils/sidid.cfg");
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private File getLocation() {
        try {
            String[] paths;
            for (String path : paths = new String[]{"user.dir", "user.home"}) {
                File sidIdFile = this.locate(path);
                if (!sidIdFile.exists()) continue;
                return sidIdFile;
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        return null;
    }

    private File locate(String location) {
        String path = System.getProperty(location);
        if (path != null) {
            return new File(path, FNAME);
        }
        return new File("", FNAME);
    }

    private static class PlayerSection {
        private final String playerName;
        private final ArrayList<ArrayList<Pattern>> orList;

        public PlayerSection(String name) {
            this.playerName = name;
            this.orList = new ArrayList();
            this.orList.add(new ArrayList());
        }

        public final String getPlayerName() {
            return this.playerName;
        }

        public final ArrayList<ArrayList<Pattern>> getOrList() {
            return this.orList;
        }
    }

    private static class Pattern {
        private final byte[] pattern;
        private final Object preProcessedPattern;
        private final boolean isSubPattern;

        public Pattern(byte[] p, Object pre, boolean subPattern) {
            this.pattern = p;
            this.preProcessedPattern = pre;
            this.isSubPattern = subPattern;
        }

        public byte[] getPattern() {
            return this.pattern;
        }

        public Object getPreProcessedPattern() {
            return this.preProcessedPattern;
        }

        public boolean isSubPattern() {
            return this.isSubPattern;
        }
    }
}

