/*
 * Decompiled with CFR 0.152.
 */
package libsidutils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import libsidplay.sidtune.SidTune;
import libsidutils.zip.ZipEntryFileProxy;
import libsidutils.zip.ZipFileProxy;
import sidplay.ini.IniReader;

public class SidDatabase {
    private static final Pattern TIME_VALUE = Pattern.compile("([0-9]{1,2}):([0-9]{2})(?:\\(.*)?");
    private final IniReader database;
    private static SidDatabase theSLDB;
    private static String theHVSCRoot;

    public static SidDatabase getInstance(final String hvscRoot) {
        if (theSLDB == null && hvscRoot != null && hvscRoot.length() != 0 && hvscRoot != theHVSCRoot) {
            try {
                theSLDB = AccessController.doPrivileged(new PrivilegedExceptionAction<SidDatabase>(){

                    @Override
                    public SidDatabase run() throws Exception {
                        File sldbFile = SidDatabase.getSLDBFilename(hvscRoot);
                        if (sldbFile != null && sldbFile.exists()) {
                            return new SidDatabase(sldbFile);
                        }
                        return null;
                    }
                });
                if (theSLDB != null) {
                    theHVSCRoot = hvscRoot;
                }
            }
            catch (PrivilegedActionException e) {
                e.getException().printStackTrace();
            }
        }
        return theSLDB;
    }

    protected SidDatabase(File file) {
        try {
            this.database = file instanceof ZipEntryFileProxy ? new IniReader(((ZipEntryFileProxy)file).getInputStream()) : new IniReader(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int parseTimeStamp(String arg) {
        Matcher m = TIME_VALUE.matcher(arg);
        if (!m.matches()) {
            System.out.println("Failed to parse: " + arg);
            return 0;
        }
        return Integer.parseInt(m.group(1)) * 60 + Integer.parseInt(m.group(2));
    }

    public int length(SidTune tune) {
        int song = tune.getInfo().currentSong;
        if (song == 0) {
            return -1;
        }
        String md5 = tune.getMD5Digest();
        if (md5 == null) {
            return 0;
        }
        return this.length(md5, song);
    }

    public int length(String md5, int song) {
        String value = this.database.getPropertyString("Database", md5, null);
        if (value == null) {
            return 0;
        }
        String[] times = value.split(" ");
        return this.parseTimeStamp(times[song - 1]);
    }

    protected static File getSLDBFilename(String hvscRoot) {
        if (hvscRoot.toLowerCase().endsWith(".zip")) {
            if (new File(hvscRoot).exists()) {
                ZipFileProxy root = new ZipFileProxy(new File(hvscRoot));
                File[] docs = root.getFileChildren("C64Music/DOCUMENTS/");
                for (int i = 0; i < docs.length; ++i) {
                    if (!docs[i].getName().equals("Songlengths.txt")) continue;
                    return docs[i];
                }
            }
            return null;
        }
        return new File(hvscRoot + File.separator + "DOCUMENTS" + File.separator + "Songlengths.txt");
    }

    public int getFullSongLength(SidTune currentTune) {
        int length = 0;
        String md5 = currentTune.getMD5Digest();
        for (int i = 1; i <= currentTune.getInfo().songs; ++i) {
            int curr_length = this.length(md5, i);
            length += curr_length;
        }
        return length;
    }
}

