/*
 * Decompiled with CFR 0.152.
 */
package libsidutils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import libsidutils.zip.ZipEntryFileProxy;
import libsidutils.zip.ZipFileProxy;

public class STIL {
    public static final String[] STIL_INFOS = new String[]{"STIL_GLB_COMMENT", "STIL_NAME", "STIL_AUTHOR", "STIL_TITLE", "STIL_ARTIST", "STIL_COMMENT"};
    private final HashMap<String, STILEntry> fastMap = new HashMap();
    private static STIL theStil;
    private static String theHVSCRoot;

    public static STIL getInstance(String hvscRoot) {
        File stilFile;
        if (theStil == null && hvscRoot != null && hvscRoot.length() != 0 && hvscRoot != theHVSCRoot && (stilFile = STIL.getSTILFile(hvscRoot)) != null && stilFile.exists()) {
            theStil = new STIL(stilFile);
            theHVSCRoot = hvscRoot;
        }
        return theStil;
    }

    private STIL(File file) {
        this.fastMap.clear();
        Pattern p = Pattern.compile("(NAME|AUTHOR|TITLE|ARTIST|COMMENT): *(.*)");
        BufferedReader r = null;
        try {
            String line;
            InputStream is = file instanceof ZipEntryFileProxy ? ((ZipEntryFileProxy)file).getInputStream() : new FileInputStream(file);
            r = new BufferedReader(new InputStreamReader(is));
            STILEntry entry = null;
            TuneEntry tuneEntry = null;
            Info lastInfo = null;
            String lastProp = null;
            StringBuilder cmts = new StringBuilder();
            while ((line = r.readLine()) != null) {
                if (line.startsWith("#")) {
                    cmts.append(line.trim() + "\n");
                    continue;
                }
                if (line.startsWith("/")) {
                    entry = new STILEntry(line);
                    this.fastMap.put(line, entry);
                    entry.comment = cmts.toString();
                    cmts.delete(0, cmts.length());
                    lastInfo = new Info();
                    entry.infos.add(lastInfo);
                    tuneEntry = null;
                    lastProp = null;
                    continue;
                }
                if (line.startsWith("(#")) {
                    if (entry == null) {
                        throw new RuntimeException("Invalid format in STIL file: '(#' before '/'.");
                    }
                    int end = line.indexOf(")");
                    int tuneNo = Integer.parseInt(line.substring(2, end));
                    tuneEntry = new TuneEntry();
                    tuneEntry.tuneNo = tuneNo;
                    entry.subtunes.add(tuneEntry);
                    lastInfo = new Info();
                    tuneEntry.infos.add(lastInfo);
                    lastProp = null;
                    continue;
                }
                if ("".equals(line = line.trim())) continue;
                if (entry == null) {
                    throw new RuntimeException("No entry to put data in: " + line);
                }
                if (lastInfo == null) {
                    throw new RuntimeException("No context to put data in: " + line);
                }
                Matcher m = p.matcher(line);
                if (m.matches()) {
                    lastProp = m.group(1);
                    Field f = lastInfo.getClass().getField(lastProp.toLowerCase());
                    if (f.get(lastInfo) != null) {
                        lastInfo = new Info();
                        if (tuneEntry != null) {
                            tuneEntry.infos.add(lastInfo);
                        } else {
                            entry.infos.add(lastInfo);
                        }
                    }
                    f.set(lastInfo, m.group(2));
                    continue;
                }
                if (lastProp == null) continue;
                Field f = lastInfo.getClass().getField(lastProp.toLowerCase());
                f.set(lastInfo, f.get(lastInfo) + "\n" + line);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static File getSTILFile(String hvscRoot) {
        if (hvscRoot.toLowerCase().endsWith(".zip")) {
            ZipFileProxy root = new ZipFileProxy(new File(hvscRoot));
            File[] docs = root.getFileChildren("C64Music/DOCUMENTS/");
            for (int i = 0; i < docs.length; ++i) {
                if (!docs[i].getName().equals("STIL.txt")) continue;
                return docs[i];
            }
            return null;
        }
        return new File(hvscRoot + File.separator + "DOCUMENTS" + File.separator + "STIL.txt");
    }

    public STILEntry getSTIL(String name) {
        return this.fastMap.get(name);
    }

    public static class STILEntry {
        public String comment;
        public String filename;
        public String globalComment;
        public ArrayList<TuneEntry> subtunes = new ArrayList();
        public ArrayList<Info> infos = new ArrayList();

        public STILEntry(String name) {
            this.filename = name;
        }

        public String toString() {
            return "" + this.filename.substring(this.filename.lastIndexOf(47) + 1);
        }
    }

    public static class TuneEntry {
        public String globalComment;
        public int tuneNo = -1;
        public ArrayList<Info> infos = new ArrayList();

        public String toString() {
            return "" + this.tuneNo;
        }
    }

    public static class Info {
        public String name;
        public String author;
        public String title;
        public String artist;
        public String comment;

        public String toString() {
            return "info";
        }
    }
}

