/*
 * Decompiled with CFR 0.152.
 */
package libsidutils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SIDDump {
    protected static final String FILE_NAME = "siddump.xml";
    public static final int FREQ_LO_1 = 0;
    public static final int FREQ_HI_1 = 1;
    public static final int PULSE_LO_1 = 2;
    public static final int PULSE_HI_1 = 3;
    public static final int WAVEFORM_1 = 4;
    public static final int ATTACK_DECAY_1 = 5;
    public static final int SUSTAIN_RELEASE_1 = 6;
    public static final int FREQ_LO_2 = 7;
    public static final int FREQ_HI_2 = 8;
    public static final int PULSE_LO_2 = 9;
    public static final int PULSE_HI_2 = 10;
    public static final int WAVEFORM_2 = 11;
    public static final int ATTACK_DECAY_2 = 12;
    public static final int SUSTAIN_RELEASE_2 = 13;
    public static final int FREQ_LO_3 = 14;
    public static final int FREQ_HI_3 = 15;
    public static final int PULSE_LO_3 = 16;
    public static final int PULSE_HI_3 = 17;
    public static final int WAVEFORM_3 = 18;
    public static final int ATTACK_DECAY_3 = 19;
    public static final int SUSTAIN_RELEASE_3 = 20;
    public static final int FILTERFREQ_LO = 21;
    public static final int FILTERFREQ_HI = 22;
    public static final int FILTERCTRL = 23;
    public static final int VOL = 24;
    private Document siddump;
    ArrayList<Player> fPlayers;

    public SIDDump() {
        try {
            this.open(this.findConfigFile());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ArrayList<Player> getPlayers() {
        return this.fPlayers;
    }

    private InputStream findConfigFile() {
        String configPath;
        File sidDumpFile;
        InputStream is = null;
        String path = System.getProperty("user.dir");
        if (path == null) {
            path = "";
        }
        if (!(sidDumpFile = new File((configPath = String.format("%s/%s", path, FILE_NAME)).replace("\\", "/"))).exists()) {
            path = System.getProperty("user.home");
            if (path == null) {
                path = "";
            }
            if (!(sidDumpFile = new File((configPath = String.format("%s/%s", path, FILE_NAME)).replace("\\", "/"))).exists()) {
                is = SIDDump.class.getResourceAsStream(FILE_NAME);
                System.out.println("Using internal SIDDump file: libsidutils/siddump.xml");
                return is;
            }
        }
        try {
            is = new FileInputStream(sidDumpFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        System.out.println("Using SIDDump file: " + sidDumpFile.getAbsolutePath());
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open(InputStream is) throws Exception {
        try {
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            fac.setIgnoringElementContentWhitespace(true);
            fac.setIgnoringComments(true);
            DocumentBuilder builder = fac.newDocumentBuilder();
            this.siddump = builder.parse(is);
            this.parse();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void parse() {
        Element root = this.siddump.getDocumentElement();
        if (root == null) {
            return;
        }
        NodeList player = root.getElementsByTagName("PLAYER");
        this.fPlayers = new ArrayList();
        for (int i = 0; i < player.getLength(); ++i) {
            this.createPlayer((Element)player.item(i));
        }
    }

    private void createPlayer(Element player) {
        NamedNodeMap atts = player.getAttributes();
        Node name = atts.getNamedItem("name");
        if (name != null) {
            Player pl = new Player(name.getNodeValue());
            NodeList regs = player.getElementsByTagName("REGS");
            if (regs.getLength() == 0) {
                return;
            }
            NodeList reg = ((Element)regs.item(0)).getElementsByTagName("REG");
            for (int i = 0; i < reg.getLength(); ++i) {
                if (reg.item(i).getFirstChild() == null) continue;
                pl.add(reg.item(i).getFirstChild().getNodeValue());
            }
            this.fPlayers.add(pl);
        }
    }

    public static class Player {
        private final String fName;
        private final ArrayList<Byte> fRegs;

        public Player(String name) {
            this.fName = name;
            this.fRegs = new ArrayList();
        }

        public String getName() {
            return this.fName;
        }

        public Byte[] getBytes() {
            return this.fRegs.toArray(new Byte[this.fRegs.size()]);
        }

        void add(String reg) {
            this.fRegs.add(this.name2reg(reg));
        }

        private Byte name2reg(String reg) {
            if ("VOL".equals(reg)) {
                return (byte)24;
            }
            if ("ATTACK_DECAY_3".equals(reg)) {
                return (byte)19;
            }
            if ("SUSTAIN_RELEASE_3".equals(reg)) {
                return (byte)20;
            }
            if ("WAVEFORM_3".equals(reg)) {
                return (byte)18;
            }
            if ("PULSE_LO_3".equals(reg)) {
                return (byte)16;
            }
            if ("PULSE_HI_3".equals(reg)) {
                return (byte)17;
            }
            if ("FREQ_LO_3".equals(reg)) {
                return (byte)14;
            }
            if ("FREQ_HI_3".equals(reg)) {
                return (byte)15;
            }
            if ("ATTACK_DECAY_2".equals(reg)) {
                return (byte)12;
            }
            if ("SUSTAIN_RELEASE_2".equals(reg)) {
                return (byte)13;
            }
            if ("WAVEFORM_2".equals(reg)) {
                return (byte)11;
            }
            if ("PULSE_LO_2".equals(reg)) {
                return (byte)9;
            }
            if ("PULSE_HI_2".equals(reg)) {
                return (byte)10;
            }
            if ("FREQ_LO_2".equals(reg)) {
                return (byte)7;
            }
            if ("FREQ_HI_2".equals(reg)) {
                return (byte)8;
            }
            if ("ATTACK_DECAY_1".equals(reg)) {
                return (byte)5;
            }
            if ("SUSTAIN_RELEASE_1".equals(reg)) {
                return (byte)6;
            }
            if ("WAVEFORM_1".equals(reg)) {
                return (byte)4;
            }
            if ("PULSE_LO_1".equals(reg)) {
                return (byte)2;
            }
            if ("PULSE_HI_1".equals(reg)) {
                return (byte)3;
            }
            if ("FREQ_LO_1".equals(reg)) {
                return (byte)0;
            }
            if ("FREQ_HI_1".equals(reg)) {
                return (byte)1;
            }
            if ("FILTERFREQ_LO".equals(reg)) {
                return (byte)21;
            }
            if ("FILTERFREQ_HI".equals(reg)) {
                return (byte)22;
            }
            if ("FILTERCTRL".equals(reg)) {
                return (byte)23;
            }
            throw new RuntimeException("Invalid siddump database entry: " + reg);
        }
    }
}

