/*
 * Decompiled with CFR 0.152.
 */
package libsidutils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import libsidplay.components.DirEntry;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidplay.sidtune.T64;

public class PRG2TAP {
    private static final int[] PULSE_LENGTH = new int[]{384, 536, 680};

    private final boolean main2(String[] argo) {
        String inputFilename = argo[0];
        String outputFilename = argo[1];
        byte tapVersion = 1;
        int threshold = 263;
        C64Program program = new C64Program();
        try {
            byte[] petsciiName;
            SidTune p = SidTune.load(new File(inputFilename));
            if (p == null) {
                return false;
            }
            p.placeProgramInMemory(program.data);
            program.startAddr = p.getInfo().loadAddr;
            program.endAddr = program.startAddr + p.getInfo().c64dataLen;
            if (p instanceof T64) {
                petsciiName = ((T64)p).getLastEntryName();
            } else {
                String filenameNoExt = new File(inputFilename).getName();
                if (filenameNoExt.lastIndexOf(46) != -1) {
                    filenameNoExt = filenameNoExt.substring(0, filenameNoExt.lastIndexOf(46));
                }
                petsciiName = DirEntry.asciiTopetscii(filenameNoExt, 16);
            }
            System.arraycopy(petsciiName, 0, program.name, 0, Math.min(16, petsciiName.length));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SidTuneError e) {
            e.printStackTrace();
        }
        TapHandle handle = new TapHandle();
        if (this.tapfileInitWrite(outputFilename, handle, tapVersion) != 0) {
            System.out.printf("Error creating TAP file %s\n", outputFilename);
            return false;
        }
        try {
            this.convertFromPrg(program, handle, threshold);
            this.tapfileWriteClose(handle);
        }
        catch (IOException e) {
            System.err.printf("Error writing tap: error %s\n", e.getMessage());
        }
        return true;
    }

    private void convertFromPrg(C64Program program, TapHandle handle, int threshold) throws IOException {
        byte[] c64HeaderChunk = new byte[]{3, 1, 8, -110, 8, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, -41, 5, -112, -16, 4, -87, -1, -123, -112, 76, -87, -11, 32, -65, 3, -55, 0, -16, -7, -123, -85, 32, -19, 3, -123, -61, 32, -19, 3, -123, -60, 32, -19, 3, -123, -82, 32, -19, 3, -123, -81, -96, -68, 32, -19, 3, -120, -48, -6, -16, 47, 32, -65, 3, 32, -19, 3, -124, -109, 72, -87, 4, -123, 1, 104, -111, -61, 69, -41, -123, -41, -87, 7, -123, 1, -26, -61, -48, 2, -26, -60, -91, -61, -59, -82, -91, -60, -27, -81, -112, -37, 32, -19, 3, 32, 2, 1, -56, -124, -64, 88, 24, -87, 0, -115, -96, 2, 76, -109, -4, 32, 23, -8, 32, 2, 1, -124, -41, -87, 7, -115, 6, -35, -94, 1, 32, 22, 1, 38, -67, -91, -67, -55, 2, -48, -11, -96, 9, 32, -19, 3, -55, 2, -16, -7, -60, -67, -48, -24, 32, -19, 3, -120, -48, -10, 96, -87, 8, -123, -93, 32, 22, 1, 38, -67, -18, 32, -48, -58, -93, -48};
        byte[] c64DataChunk = new byte[]{11, 8, 0, 0, -98, 50, 48, 54, 49, 0, 0, 0, -94, 5, -67, -116, 8, -99, 119, 2, -54, 16, -9, -87, 6, -123, -58, -87, 3, -115, 49, 3, -87, 60, -115, 48, 3, -94, 42, -67, 72, 8, -99, 2, 1, -54, 16, -9, -94, 21, -67, 114, 8, -99, 59, 3, -54, -48, -9, -94, 4, -67, -121, 8, -99, -5, 3, -54, -48, -9, 96, -96, 0, -124, -64, -83, 17, -48, 41, -17, -115, 17, -48, -54, -48, -3, -120, -48, -6, 120, 96, -87, 16, 44, 13, -36, -16, -5, -83, 13, -35, -114, 7, -35, 72, -87, 25, -115, 15, -35, 104, 74, 74, 96, -123, -112, 32, 93, 3, -91, -85, -55, 2, -16, 4, -55, 1, -48, -13, 32, -124, 3, -91, -67, 69, -12, -91, -67, 96, 76, -49, 13, 82, -43, 13};
        int namePos = 5;
        if (program.endAddr < program.startAddr) {
            System.err.printf("End address lower than start address\n", new Object[0]);
            return;
        }
        for (int i = 0; i < 16; ++i) {
            c64HeaderChunk[namePos + i] = program.name[i];
        }
        c64HeaderChunk[140] = (byte)(threshold & 0xFF);
        c64HeaderChunk[145] = (byte)(threshold >> 8);
        if (this.slowConvert(handle, c64HeaderChunk, 0, c64HeaderChunk.length, 20000) != 0) {
            return;
        }
        this.tapfileWriteSetPulse(handle, 200000);
        if (this.slowConvert(handle, c64DataChunk, 0, c64DataChunk.length, 5000) != 0) {
            return;
        }
        this.tapfileWriteSetPulse(handle, 1000000);
        if (this.turbotapeConvert(handle, program, threshold) != 0) {
            return;
        }
    }

    private void tapfileWriteSetPulse(TapHandle handle, int ncycles) throws IOException {
        byte[] threebytes = new byte[3];
        if (ncycles < 2048) {
            byte byt = (byte)(ncycles / 8);
            handle.file.write(byt);
            return;
        }
        int byt = 0;
        handle.file.write(byt);
        if (handle.version == 0) {
            return;
        }
        threebytes[0] = (byte)(ncycles & 0xFF);
        threebytes[1] = (byte)(ncycles >> 8 & 0xFF);
        threebytes[2] = (byte)(ncycles >> 16 & 0xFF);
        handle.file.write(threebytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tapfileWriteClose(TapHandle handle) throws IOException {
        handle.file.close();
        long size = handle.fileHandle.length();
        if ((size -= 20L) < 0L) {
            System.err.printf("Invalid file size\n", new Object[0]);
            return;
        }
        byte[] sizeHeader = new byte[]{(byte)(size & 0xFFL), (byte)(size >> 8 & 0xFFL), (byte)(size >> 16 & 0xFFL), (byte)(size >> 24 & 0xFFL)};
        RandomAccessFile rnd = null;
        try {
            rnd = new RandomAccessFile(handle.fileHandle, "rw");
            rnd.seek(16L);
            rnd.write(sizeHeader);
        }
        catch (IOException e) {
            System.err.printf("Cannot write to file, header won't have correct size: error %s\n", e.getMessage());
        }
        finally {
            if (rnd != null) {
                try {
                    rnd.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    private int tapfileInitWrite(String name, TapHandle handle, byte version) {
        if (version != 0 && version != 1) {
            System.err.printf("Unsupported version %d\n", version);
            return -1;
        }
        try {
            handle.fileHandle = new File(name);
            handle.file = new BufferedOutputStream(new FileOutputStream(handle.fileHandle));
        }
        catch (IOException e) {
            System.err.printf("Could not open file: error %s\n", e.getMessage());
            return -1;
        }
        try {
            byte[] c64TapHeader = "C64-TAPE-RAW\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".getBytes("ISO-8859-1");
            c64TapHeader[12] = version;
            handle.file.write(c64TapHeader);
        }
        catch (IOException e) {
            System.err.printf("Could not write to file: error %s\n", e.getMessage());
            try {
                handle.file.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return -1;
        }
        handle.version = version;
        return 0;
    }

    private int slowConvert(TapHandle handle, byte[] data, int dataPos, int size, int leadin_len) throws IOException {
        int i;
        int num;
        byte checksum = 0;
        for (num = 0; num < leadin_len; ++num) {
            this.tapfileWriteSetPulse(handle, PULSE_LENGTH[0]);
        }
        for (i = 137; i > 128; --i) {
            if (this.slowWriteByte(handle, (byte)i) == 0) continue;
            return -1;
        }
        for (num = 0; num < size; ++num) {
            if (this.slowWriteByte(handle, data[dataPos + num]) != 0) {
                return -1;
            }
            checksum = (byte)(checksum ^ data[dataPos + num]);
        }
        if (this.slowWriteByte(handle, checksum) != 0) {
            return -1;
        }
        this.tapfileWriteSetPulse(handle, PULSE_LENGTH[2]);
        this.tapfileWriteSetPulse(handle, PULSE_LENGTH[0]);
        for (num = 0; num < 79; ++num) {
            this.tapfileWriteSetPulse(handle, PULSE_LENGTH[0]);
        }
        for (i = 9; i > 0; --i) {
            if (this.slowWriteByte(handle, (byte)i) == 0) continue;
            return -1;
        }
        for (num = 0; num < size; ++num) {
            if (this.slowWriteByte(handle, data[dataPos + num]) == 0) continue;
            return -1;
        }
        if (this.slowWriteByte(handle, checksum) != 0) {
            return -1;
        }
        this.tapfileWriteSetPulse(handle, PULSE_LENGTH[2]);
        this.tapfileWriteSetPulse(handle, PULSE_LENGTH[0]);
        for (num = 0; num < 200; ++num) {
            this.tapfileWriteSetPulse(handle, PULSE_LENGTH[0]);
        }
        return 0;
    }

    private int slowWriteByte(TapHandle handle, byte byt) throws IOException {
        byte count = 1;
        boolean parity = true;
        this.tapfileWriteSetPulse(handle, PULSE_LENGTH[2]);
        this.tapfileWriteSetPulse(handle, PULSE_LENGTH[1]);
        do {
            if ((byt & count) != 0) {
                parity ^= true;
                this.tapfileWriteSetPulse(handle, PULSE_LENGTH[1]);
                this.tapfileWriteSetPulse(handle, PULSE_LENGTH[0]);
                continue;
            }
            this.tapfileWriteSetPulse(handle, PULSE_LENGTH[0]);
            this.tapfileWriteSetPulse(handle, PULSE_LENGTH[1]);
        } while ((count = (byte)(count << 1)) != 0);
        if (parity) {
            this.tapfileWriteSetPulse(handle, PULSE_LENGTH[1]);
            this.tapfileWriteSetPulse(handle, PULSE_LENGTH[0]);
        } else {
            this.tapfileWriteSetPulse(handle, PULSE_LENGTH[0]);
            this.tapfileWriteSetPulse(handle, PULSE_LENGTH[1]);
        }
        return 0;
    }

    private int turbotapeConvert(TapHandle handle, C64Program program, int threshold) throws IOException {
        byte byt;
        int i;
        byte checksum = 0;
        for (i = 0; i < 630; ++i) {
            if (this.turbotapeWriteByte(handle, (byte)2, threshold) == 0) continue;
            return -1;
        }
        for (byt = 9; byt >= 1; byt = (byte)(byt - 1)) {
            if (this.turbotapeWriteByte(handle, byt, threshold) == 0) continue;
            return -1;
        }
        if (this.turbotapeWriteByte(handle, (byte)1, threshold) != 0) {
            return -1;
        }
        if (this.turbotapeWriteByte(handle, (byte)(program.startAddr & 0xFF), threshold) != 0) {
            return -1;
        }
        if (this.turbotapeWriteByte(handle, (byte)(program.startAddr >> 8 & 0xFF), threshold) != 0) {
            return -1;
        }
        if (this.turbotapeWriteByte(handle, (byte)(program.endAddr & 0xFF), threshold) != 0) {
            return -1;
        }
        if (this.turbotapeWriteByte(handle, (byte)(program.endAddr >> 8 & 0xFF), threshold) != 0) {
            return -1;
        }
        if (this.turbotapeWriteByte(handle, (byte)0, threshold) != 0) {
            return -1;
        }
        for (i = 0; i < 16; ++i) {
            if (this.turbotapeWriteByte(handle, program.name[i], threshold) == 0) continue;
            return -1;
        }
        for (i = 0; i < 171; ++i) {
            if (this.turbotapeWriteByte(handle, (byte)32, threshold) == 0) continue;
            return -1;
        }
        for (i = 0; i < 630; ++i) {
            if (this.turbotapeWriteByte(handle, (byte)2, threshold) == 0) continue;
            return -1;
        }
        for (byt = 9; byt >= 1; byt = (byte)(byt - 1)) {
            if (this.turbotapeWriteByte(handle, byt, threshold) == 0) continue;
            return -1;
        }
        if (this.turbotapeWriteByte(handle, (byte)0, threshold) != 0) {
            return -1;
        }
        for (i = program.startAddr; i < program.endAddr; ++i) {
            if (this.turbotapeWriteByte(handle, program.data[i], threshold) != 0) {
                return -1;
            }
            checksum = (byte)(checksum ^ program.data[i]);
        }
        if (this.turbotapeWriteByte(handle, checksum, threshold) != 0) {
            return -1;
        }
        for (i = 0; i < 630; ++i) {
            if (this.turbotapeWriteByte(handle, (byte)0, threshold) == 0) continue;
            return -1;
        }
        return 0;
    }

    private int turbotapeWriteByte(TapHandle handle, byte byt, int threshold) throws IOException {
        int count = 128;
        int zeroBit = threshold * 4 / 5;
        int oneBit = threshold * 13 / 10;
        do {
            if ((byt & count) != 0) {
                this.tapfileWriteSetPulse(handle, oneBit);
                continue;
            }
            this.tapfileWriteSetPulse(handle, zeroBit);
        } while ((count >>= 1) != 0);
        return 0;
    }

    public static final void main(String[] args) {
        new PRG2TAP().main2(args);
    }

    protected static class C64Program {
        byte[] name = new byte[16];
        int startAddr;
        int endAddr;
        byte[] data = new byte[65536];

        protected C64Program() {
        }
    }

    protected static class TapHandle {
        File fileHandle;
        BufferedOutputStream file;
        byte version;

        protected TapHandle() {
        }
    }
}

