/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.sidtune;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.List;
import libsidplay.components.DirEntry;
import libsidplay.components.Directory;
import libsidplay.sidtune.Prg;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;

public class T64
extends Prg {
    private static final Charset ISO88591 = Charset.forName("ISO-8859-1");
    private byte[] data;
    private byte[] lastEntryName;

    protected static SidTune load(String fileName, byte[] dataBuf) throws SidTuneError {
        T64 sidtune;
        if (fileName != null) {
            String ext;
            int lastIndexOf = fileName.lastIndexOf(".");
            String string = ext = lastIndexOf != -1 ? fileName.substring(lastIndexOf) : "";
            if (!ext.equalsIgnoreCase(".t64")) {
                return null;
            }
        }
        if (!(sidtune = new T64()).getEntry(dataBuf, 1)) {
            return null;
        }
        sidtune.info.songs = 1;
        sidtune.info.startSong = 1;
        sidtune.info.numberOfInfoStrings = 0;
        sidtune.program = dataBuf;
        sidtune.convertOldStyleSpeedToTables(-1L);
        return sidtune;
    }

    private boolean getEntry(byte[] dataBuf, int entryNum) {
        int totalEntries = (dataBuf[35] & 0xFF) << 8 | dataBuf[34] & 0xFF;
        if (entryNum < 1 || entryNum > totalEntries) {
            return false;
        }
        int pos = 32 + 32 * entryNum;
        if (dataBuf[pos++] != 1) {
            return false;
        }
        if ((dataBuf[pos++] & 7) != 2) {
            return false;
        }
        this.info.loadAddr = (dataBuf[pos++] & 0xFF) + ((dataBuf[pos++] & 0xFF) << 8);
        this.info.c64dataLen = (dataBuf[pos++] & 0xFF) + ((dataBuf[pos++] & 0xFF) << 8);
        this.info.c64dataLen -= this.info.loadAddr;
        pos += 2;
        this.fileOffset = 0;
        for (int power = 0; power <= 3; ++power) {
            this.fileOffset += (dataBuf[pos++] & 0xFF) << 8 * power;
        }
        this.lastEntryName = new byte[16];
        System.arraycopy(dataBuf, pos += 4, this.lastEntryName, 0, 16);
        return true;
    }

    public byte[] getLastEntryName() {
        return this.lastEntryName;
    }

    public static Directory getDirectory(File file) throws IOException {
        Directory dir = new Directory();
        final T64 t64 = new T64();
        int length = (int)file.length();
        t64.data = new byte[length];
        RandomAccessFile fd = new RandomAccessFile(file, "r");
        fd.readFully(t64.data, 0, t64.data.length);
        fd.close();
        byte[] diskName = new byte[32];
        System.arraycopy(t64.data, 0, diskName, 0, diskName.length);
        dir.setTitle(new String(diskName, ISO88591).toUpperCase().getBytes(ISO88591));
        int totalEntries = (t64.data[35] & 0xFF) << 8 | t64.data[34] & 0xFF;
        List<DirEntry> dirEntries = dir.getDirEntries();
        for (int i = 1; i <= totalEntries; ++i) {
            if (!t64.getEntry(t64.data, i)) continue;
            final int loadAddr = t64.info.loadAddr;
            final int c64dataLen = t64.info.c64dataLen;
            final int fileOffset = t64.fileOffset;
            dirEntries.add(new DirEntry(t64.info.c64dataLen, t64.getLastEntryName(), -126){

                @Override
                public void save(File autostartFile) throws IOException {
                    t64.save(autostartFile, loadAddr, c64dataLen, fileOffset);
                }
            });
        }
        return dir;
    }

    public void save(File file, int loadAddr, int c64dataLen, int fileOffset) throws IOException {
        DataOutputStream dout = new DataOutputStream(new FileOutputStream(file));
        dout.writeByte(loadAddr & 0xFF);
        int hiBytePart = loadAddr & 0xFF00;
        dout.writeByte(hiBytePart >> 8);
        dout.write(this.data, fileOffset, c64dataLen);
        dout.close();
    }
}

