/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.sidtune;

import applet.sidtuneinfo.SidTuneInfoCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import libsidplay.components.DirEntry;
import libsidplay.components.Directory;
import libsidplay.sidtune.MP3Tune;
import libsidplay.sidtune.Mus;
import libsidplay.sidtune.P00;
import libsidplay.sidtune.PSid;
import libsidplay.sidtune.Prg;
import libsidplay.sidtune.SidTuneError;
import libsidplay.sidtune.SidTuneInfo;
import libsidplay.sidtune.T64;
import libsidutils.zip.ZipEntryFileProxy;
import sidplay.ini.IniConfig;

public abstract class SidTune {
    private static final Charset ISO88591 = Charset.forName("ISO-8859-1");
    protected static final int SIDTUNE_MAX_SONGS = 256;
    protected static final int SIDTUNE_MAX_CREDIT_STRINGS = 10;
    protected SidTuneInfo info = new SidTuneInfo();
    protected final Speed[] songSpeed = new Speed[256];
    private static final String[] defaultMusNames = new String[]{".mus", ".str"};
    private static final short[] _sidtune_CHRtab = new short[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 13, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 32, 33, 1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 36, 93, 32, 32, 45, 35, 124, 45, 45, 45, 45, 124, 124, 92, 92, 47, 92, 92, 47, 47, 92, 35, 95, 35, 124, 47, 88, 79, 35, 124, 35, 43, 124, 124, 38, 92, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 32, 124, 35, 45, 45, 124, 35, 124, 35, 47, 124, 124, 47, 92, 92, 45, 47, 45, 45, 124, 124, 124, 124, 45, 45, 45, 47, 92, 92, 47, 47, 35, 45, 35, 124, 45, 45, 45, 45, 124, 124, 92, 92, 47, 92, 92, 47, 47, 92, 35, 95, 35, 124, 47, 88, 79, 35, 124, 35, 43, 124, 124, 38, 92, 32, 124, 35, 45, 45, 124, 35, 124, 35, 47, 124, 124, 47, 92, 92, 45, 47, 45, 45, 124, 124, 124, 124, 45, 45, 45, 47, 92, 92, 47, 47, 35};
    private static SidTuneInfoCache cache;

    protected SidTune() {
        Arrays.fill((Object[])this.songSpeed, (Object)Speed.VBI);
    }

    public static SidTune load(File f) throws IOException, SidTuneError {
        if (f.getName().toLowerCase().endsWith(".mp3")) {
            return MP3Tune.load(f);
        }
        String fileName = f.getAbsolutePath();
        byte[] fileBuf1 = SidTune.loadFile(f);
        if (fileBuf1 == null) {
            return null;
        }
        SidTune s = PSid.load(fileBuf1);
        if (s != null) {
            s.info.dataFileLen = fileBuf1.length;
            s.info.file = f;
            return s;
        }
        s = Prg.load(fileName, fileBuf1);
        if (s != null) {
            s.info.dataFileLen = fileBuf1.length;
            s.info.file = f;
            return s;
        }
        s = P00.load(fileName, fileBuf1);
        if (s != null) {
            s.info.dataFileLen = fileBuf1.length;
            s.info.file = f;
            return s;
        }
        s = T64.load(fileName, fileBuf1);
        if (s != null) {
            s.info.dataFileLen = fileBuf1.length;
            s.info.file = f;
            return s;
        }
        s = Mus.load(fileBuf1, null);
        if (s != null) {
            byte[] fileBuf2;
            s.info.dataFileLen = fileBuf1.length;
            s.info.file = f;
            File stereoTune = SidTune.getStereoTune(f);
            if (stereoTune != null && (fileBuf2 = SidTune.loadFile(stereoTune)) != null && (s = Mus.load(fileBuf1, fileBuf2)) != null) {
                s.info.dataFileLen = fileBuf1.length;
                s.info.file = f;
            }
            return s;
        }
        return null;
    }

    public static File getStereoTune(File f) {
        block5: {
            int i;
            String fileName2;
            File[] childs;
            String fileName;
            block4: {
                fileName = f.getAbsolutePath();
                childs = f.getParentFile().listFiles();
                for (String extension : defaultMusNames) {
                    String fileName22 = fileName.replaceFirst("\\.\\w+$", extension);
                    for (int i2 = 0; i2 < childs.length; ++i2) {
                        if (fileName.equalsIgnoreCase(fileName22) || !childs[i2].getAbsolutePath().equalsIgnoreCase(fileName22) || !childs[i2].exists()) continue;
                        return childs[i2];
                    }
                }
                if (!fileName.toLowerCase().endsWith("_a.mus")) break block4;
                fileName2 = fileName.toLowerCase().replace("_a.mus", "_b.mus");
                for (i = 0; i < childs.length; ++i) {
                    if (fileName.equalsIgnoreCase(fileName2) || !childs[i].getAbsolutePath().equalsIgnoreCase(fileName2) || !childs[i].exists()) continue;
                    return childs[i];
                }
                break block5;
            }
            if (!fileName.toLowerCase().endsWith("_b.mus")) break block5;
            fileName2 = fileName.toLowerCase().replace("_b.mus", "_a.mus");
            for (i = 0; i < childs.length; ++i) {
                if (fileName.equalsIgnoreCase(fileName2) || !childs[i].getAbsolutePath().equalsIgnoreCase(fileName2) || !childs[i].exists()) continue;
                return childs[i];
            }
        }
        return null;
    }

    protected static InputStream getInputStream(File f) throws IOException, FileNotFoundException {
        InputStream stream = f instanceof ZipEntryFileProxy ? ((ZipEntryFileProxy)f).getInputStream() : new FileInputStream(f);
        return stream;
    }

    public static SidTune load(InputStream stream) throws IOException, SidTuneError {
        int len;
        int count;
        int maxLength = 65536;
        byte[] fileBuf1 = new byte[65536];
        for (len = 0; len < 65536 && (count = stream.read(fileBuf1, len, 65536 - len)) >= 0; len += count) {
        }
        byte[] buffer = new byte[len];
        for (int i = 0; i < len; ++i) {
            buffer[i] = fileBuf1[i];
        }
        SidTune s = PSid.load(buffer);
        if (s != null) {
            return s;
        }
        s = Mus.load(buffer, null);
        if (s != null) {
            return s;
        }
        s = Prg.load(null, buffer);
        if (s != null) {
            return s;
        }
        return null;
    }

    public int selectSong(int selectedSong) {
        int song = selectedSong;
        if (selectedSong == 0 || selectedSong > this.info.songs) {
            song = this.info.startSong;
        }
        this.info.currentSong = song;
        return song;
    }

    public final SidTuneInfo getInfo() {
        return this.info;
    }

    public abstract int placeProgramInMemory(byte[] var1);

    public abstract void save(String var1, boolean var2) throws IOException;

    public abstract ArrayList<String> identify();

    private static byte[] loadFile(File f) throws IOException {
        int count;
        InputStream stream = SidTune.getInputStream(f);
        int length = Math.min(65536, (int)f.length());
        byte[] data = new byte[length];
        for (int pos = 0; pos < length && (count = stream.read(data, pos, length - pos)) >= 0; pos += count) {
        }
        stream.close();
        return data;
    }

    protected void convertOldStyleSpeedToTables(long speed) {
        for (int s = 0; s < 256; ++s) {
            int i = s > 31 ? 31 : s;
            this.songSpeed[s] = (speed & (long)(1 << i)) != 0L ? Speed.CIA_1A : Speed.VBI;
        }
    }

    protected static String convertPetsciiToAscii(byte[] petscii, int startOffset) {
        StringBuilder result = new StringBuilder();
        for (int idx = startOffset; idx < petscii.length; ++idx) {
            short out = _sidtune_CHRtab[petscii[idx] & 0xFF];
            result.append((char)out);
        }
        return result.toString();
    }

    public String getMD5Digest() {
        return null;
    }

    public int getSongSpeedArray() {
        int speed = 0;
        for (int i = 0; i < 32; ++i) {
            if (this.songSpeed[i] == Speed.VBI) continue;
            speed |= 1 << i;
        }
        return speed;
    }

    public Speed getSongSpeed(int selected) {
        return this.songSpeed[selected - 1];
    }

    public abstract long getInitDelay();

    public static Directory getDirectory(File file, IniConfig cfg) throws IOException {
        SidTune tune;
        Directory dir = new Directory();
        try {
            tune = SidTune.load(file);
            if (tune == null) {
                throw new IOException();
            }
        }
        catch (SidTuneError e) {
            throw new IOException();
        }
        SidTuneInfo tuneInfo = tune.getInfo();
        String title = tuneInfo.infoString[0] != null ? tuneInfo.infoString[0] : file.getName();
        dir.setTitle(DirEntry.asciiTopetscii(title, 16));
        dir.setId((String.valueOf(tuneInfo.startSong) + "/" + String.valueOf(Math.max(1, tuneInfo.songs))).getBytes(ISO88591));
        List<DirEntry> entries = dir.getDirEntries();
        if (cache == null) {
            cache = new SidTuneInfoCache(cfg);
        }
        Object[] infos = cache.getInfo(file);
        for (int i = 0; infos != null && i < infos.length; ++i) {
            String property = SidTuneInfoCache.SIDTUNE_INFOS[i];
            String value = infos[i] != null ? infos[i].toString() : "?";
            byte[] filename = DirEntry.asciiTopetscii(property + "=" + value, 20);
            entries.add(new DirEntry(0, filename, -1){

                @Override
                public void save(File autostartFile) throws IOException {
                }
            });
        }
        return dir;
    }

    public static enum Compatibility {
        PSIDv3,
        PSIDv2,
        PSIDv1,
        RSID,
        RSID_BASIC;

    }

    public static enum Model {
        UNKNOWN,
        MOS6581,
        MOS8580,
        ANY;

    }

    public static enum Clock {
        UNKNOWN,
        PAL,
        NTSC,
        ANY;

    }

    public static enum Speed {
        VBI(0),
        CIA_1A(60);

        private int val;

        private Speed(int n2) {
            this.val = n2;
        }

        public int speedValue() {
            return this.val;
        }
    }
}

