/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.sidtune;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.SidIdV2;

class Prg
extends SidTune {
    private static final SidIdV2 sidId = new SidIdV2();
    protected int fileOffset;
    private static final String _sidtune_truncated = "ERROR: File is most likely truncated";
    protected byte[] program;

    Prg() {
    }

    protected static SidTune load(String fileName, byte[] dataBuf) throws SidTuneError {
        if (fileName != null) {
            String ext;
            int lastIndexOf = fileName.lastIndexOf(".");
            String string = ext = lastIndexOf != -1 ? fileName.substring(lastIndexOf) : "";
            if (!ext.equalsIgnoreCase(".prg")) {
                return null;
            }
        }
        Prg sidtune = new Prg();
        if (dataBuf.length < 2) {
            throw new SidTuneError(_sidtune_truncated);
        }
        sidtune.fileOffset = 2;
        sidtune.info.loadAddr = (dataBuf[0] & 0xFF) + ((dataBuf[1] & 0xFF) << 8);
        sidtune.info.c64dataLen = dataBuf.length - 2;
        sidtune.program = dataBuf;
        sidtune.convertOldStyleSpeedToTables(-1L);
        return sidtune;
    }

    @Override
    public void save(String destFileName, boolean overWriteFlag) throws IOException {
        FileOutputStream fMyOut = new FileOutputStream(destFileName, !overWriteFlag);
        fMyOut.write(this.program);
        fMyOut.close();
    }

    @Override
    public int placeProgramInMemory(byte[] c64buf) {
        int start = this.info.loadAddr;
        int end = start + this.info.c64dataLen;
        c64buf[45] = (byte)(end & 0xFF);
        c64buf[46] = (byte)(end >> 8);
        c64buf[47] = (byte)(end & 0xFF);
        c64buf[48] = (byte)(end >> 8);
        c64buf[49] = (byte)(end & 0xFF);
        c64buf[50] = (byte)(end >> 8);
        c64buf[172] = (byte)(start & 0xFF);
        c64buf[173] = (byte)(start >> 8);
        c64buf[174] = (byte)(end & 0xFF);
        c64buf[175] = (byte)(end >> 8);
        System.arraycopy(this.program, this.fileOffset, c64buf, this.info.loadAddr, this.info.c64dataLen);
        return -1;
    }

    @Override
    public ArrayList<String> identify() {
        return sidId.identify(this.program);
    }

    @Override
    public long getInitDelay() {
        return 2500000L;
    }

    static {
        sidId.readconfig();
        sidId.setMultiScan(true);
    }
}

