/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.sidtune;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import libsidplay.Reloc65;
import libsidplay.mem.IPSIDDrv;
import libsidplay.sidtune.Mus;
import libsidplay.sidtune.Prg;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;

class PSid
extends Prg {
    private static final MessageDigest md5Digest;
    public static final int PSID_MUS = 1;
    public static final int PSID_SPECIFIC = 2;
    public static final int PSID_BASIC = 2;
    private final Reloc65 relocator = new Reloc65();
    private ByteBuffer relocatedBuffer;
    private final byte[] driver = new byte[IPSIDDrv.PSIDDRV.length];

    protected PSid() {
        System.arraycopy(IPSIDDrv.PSIDDRV, 0, this.driver, 0, IPSIDDrv.PSIDDRV.length);
    }

    private byte iomap(int addr) {
        switch (this.info.compatibility) {
            case RSID: 
            case RSID_BASIC: {
                return 0;
            }
        }
        if (addr == 0) {
            return 0;
        }
        if (addr < 40960) {
            return 55;
        }
        if (addr < 53248) {
            return 54;
        }
        if (addr >= 57344) {
            return 53;
        }
        return 52;
    }

    @Override
    public int placeProgramInMemory(byte[] c64buf) {
        super.placeProgramInMemory(c64buf);
        if (this.info.compatibility != SidTune.Compatibility.RSID_BASIC) {
            return this.psidDrvReloc(c64buf);
        }
        c64buf[780] = (byte)(this.info.currentSong - 1);
        return -1;
    }

    private int psidDrvReloc(byte[] m_ram) {
        byte[] reloc_driver = this.relocatedBuffer.array();
        int reloc_driverPos = this.relocatedBuffer.position();
        if (this.info.playAddr != 0 || this.info.loadAddr != 512) {
            m_ram[788] = reloc_driver[reloc_driverPos + 2];
            m_ram[789] = reloc_driver[reloc_driverPos + 2 + 1];
            if (this.info.compatibility != SidTune.Compatibility.RSID) {
                m_ram[790] = reloc_driver[reloc_driverPos + 2 + 2];
                m_ram[791] = reloc_driver[reloc_driverPos + 2 + 3];
                m_ram[792] = reloc_driver[reloc_driverPos + 2 + 4];
                m_ram[793] = reloc_driver[reloc_driverPos + 2 + 5];
            }
        }
        int pos = this.info.determinedDriverAddr;
        System.arraycopy(reloc_driver, reloc_driverPos + 10, m_ram, pos, this.info.determinedDriverLength);
        m_ram[pos++] = (byte)(this.info.currentSong - 1);
        m_ram[pos] = this.songSpeed[this.info.currentSong - 1] == SidTune.Speed.VBI ? (byte)0 : 1;
        int n = ++pos;
        m_ram[n] = (byte)(this.info.initAddr & 0xFF);
        int n2 = ++pos;
        m_ram[n2] = (byte)(this.info.initAddr >> 8);
        int n3 = ++pos;
        m_ram[n3] = (byte)(this.info.playAddr & 0xFF);
        int n4 = ++pos;
        m_ram[n4] = (byte)(this.info.playAddr >> 8);
        int powerOnDelay = (int)(256L + (System.currentTimeMillis() & 0x1FFL));
        int n5 = ++pos;
        m_ram[n5] = (byte)(powerOnDelay & 0xFF);
        int n6 = ++pos;
        m_ram[n6] = (byte)(powerOnDelay >> 8);
        int n7 = ++pos;
        m_ram[n7] = this.iomap(this.info.initAddr);
        int n8 = ++pos;
        m_ram[n8] = this.iomap(this.info.playAddr);
        byte by = m_ram[678];
        m_ram[++pos + 0] = by;
        m_ram[pos + 1] = by;
        ++pos;
        switch (this.info.clockSpeed) {
            case PAL: {
                m_ram[pos++] = 1;
                break;
            }
            case NTSC: {
                m_ram[pos++] = 0;
                break;
            }
            default: {
                ++pos;
            }
        }
        m_ram[pos++] = this.info.compatibility == SidTune.Compatibility.RSID ? 0 : 4;
        return reloc_driver[reloc_driverPos + 0] & 0xFF | (reloc_driver[reloc_driverPos + 1] & 0xFF) << 8;
    }

    private boolean resolveAddrs() throws SidTuneError {
        if (this.info.playAddr == 65535) {
            this.info.playAddr = 0;
        }
        if (this.info.loadAddr == 0) {
            if (this.info.c64dataLen < 2) {
                throw new SidTuneError("Song is truncated");
            }
            this.info.loadAddr = (this.program[this.fileOffset] & 0xFF) + ((this.program[this.fileOffset + 1] & 0xFF) << 8);
            this.fileOffset += 2;
            this.info.c64dataLen -= 2;
        }
        if (this.info.compatibility == SidTune.Compatibility.RSID_BASIC) {
            if (this.info.initAddr != 0) {
                throw new SidTuneError("Init address given for a RSID tune with BASIC flag");
            }
        } else if (this.info.initAddr == 0) {
            this.info.initAddr = this.info.loadAddr;
        }
        return true;
    }

    protected void findPlaceForDriver() throws SidTuneError {
        short startlp = (short)(this.info.loadAddr >> 8);
        short endlp = (short)(this.info.loadAddr + this.info.c64dataLen - 1 >> 8);
        if (this.info.relocStartPage == 255) {
            this.info.relocPages = 0;
        } else if (this.info.relocPages == 0) {
            this.info.relocStartPage = 0;
        } else {
            short startp = this.info.relocStartPage;
            short endp = (short)(startp + this.info.relocPages - 1 & 0xFF);
            if (endp < startp) {
                throw new SidTuneError(String.format("Relocation info is invalid: end before start: end=%02x, start=%02x", endp, startp));
            }
            if (startp <= startlp && endp >= startlp || startp <= endlp && endp >= endlp) {
                throw new SidTuneError(String.format("Relocation info is invalid: relocation in middle of song tune itself: songstart=%02x, songend=%02x, relocstart=%02x, relocend=%02x", startlp, endlp, startp, endp));
            }
            if (startp < 4 || 160 <= startp && startp <= 191 || startp >= 208 || 160 <= endp && endp <= 191 || endp >= 208) {
                throw new SidTuneError(String.format("Relocation info is invalid: beyond acceptable bounds (kernal, basic, io, < 4th page): %02x-%02x", startp, endp));
            }
        }
        this.info.determinedDriverAddr = this.info.relocStartPage << 8;
        if (this.info.determinedDriverAddr == 0) {
            boolean driverLen = true;
            block0: for (int i = 4; i < 208; ++i) {
                for (int j = 0; j < 1; ++j) {
                    if (i + j >= startlp && i + j <= endlp || i + j >= 160 && i + j <= 191) continue block0;
                }
                this.info.determinedDriverAddr = i << 8;
                break;
            }
        }
        if (this.info.determinedDriverAddr == 0) {
            throw new SidTuneError("Can't relocate tune: no pages left to store driver.");
        }
        this.relocatedBuffer = this.relocator.reloc65(this.driver, this.driver.length, this.info.determinedDriverAddr - 10, new HashMap<String, Integer>());
        if (this.relocatedBuffer == null) {
            throw new SidTuneError("Failed to relocate driver.");
        }
        this.info.determinedDriverLength = this.relocatedBuffer.limit() - 10;
    }

    protected static final SidTune load(byte[] dataBuf) throws SidTuneError {
        int i;
        int speed;
        PSid sidtune;
        PHeader pHeader;
        block25: {
            block24: {
                if (dataBuf.length < 124) {
                    return null;
                }
                pHeader = new PHeader(dataBuf);
                sidtune = new PSid();
                sidtune.fileOffset = pHeader.data;
                sidtune.info.c64dataLen = dataBuf.length - sidtune.fileOffset;
                sidtune.info.loadAddr = pHeader.load & 0xFFFF;
                sidtune.info.initAddr = pHeader.init & 0xFFFF;
                sidtune.info.playAddr = pHeader.play & 0xFFFF;
                sidtune.info.songs = pHeader.songs & 0xFFFF;
                if (sidtune.info.songs == 0) {
                    ++sidtune.info.songs;
                }
                if (sidtune.info.songs > 256) {
                    sidtune.info.songs = 256;
                }
                sidtune.info.startSong = pHeader.start & 0xFFFF;
                if (sidtune.info.startSong > sidtune.info.songs) {
                    sidtune.info.startSong = 1;
                } else if (sidtune.info.startSong == 0) {
                    ++sidtune.info.startSong;
                }
                speed = pHeader.speed;
                if (!Arrays.equals(pHeader.id, new byte[]{80, 83, 73, 68})) break block24;
                switch (pHeader.version) {
                    case 1: {
                        sidtune.info.compatibility = SidTune.Compatibility.PSIDv1;
                        break block25;
                    }
                    case 2: {
                        sidtune.info.compatibility = SidTune.Compatibility.PSIDv2;
                        if ((pHeader.flags & 2) != 0) {
                            throw new SidTuneError("PSID-specific files are not supported by this player");
                        }
                        break block25;
                    }
                    case 3: {
                        sidtune.info.compatibility = SidTune.Compatibility.PSIDv3;
                        break block25;
                    }
                    default: {
                        throw new SidTuneError("PSID version must be 1, 2 or 3, now: " + pHeader.version);
                    }
                }
            }
            if (Arrays.equals(pHeader.id, new byte[]{82, 83, 73, 68})) {
                if (pHeader.version < 2 || pHeader.version > 3) {
                    throw new SidTuneError("RSID version must be 2 or 3, now: " + pHeader.version);
                }
                SidTune.Compatibility compatibility = sidtune.info.compatibility = (pHeader.flags & 2) != 0 ? SidTune.Compatibility.RSID_BASIC : SidTune.Compatibility.RSID;
                if (sidtune.info.loadAddr != 0 || sidtune.info.playAddr != 0 || speed != 0) {
                    throw new SidTuneError("RSID tune specified load, play or speed information.");
                }
                speed = -1;
            } else {
                return null;
            }
        }
        int clock = 0;
        int model1 = 0;
        int model2 = 0;
        if (pHeader.version >= 2) {
            clock = pHeader.flags >> 2 & 3;
            model1 = pHeader.flags >> 4 & 3;
            sidtune.info.relocStartPage = (short)(pHeader.relocStartPage & 0xFF);
            sidtune.info.relocPages = (short)(pHeader.relocPages & 0xFF);
            if (pHeader.version >= 3) {
                model2 = pHeader.flags >> 6 & 3;
                int sid2loc = 0xD000 | (pHeader.sidChip2MiddleNybbles & 0xFF) << 4;
                if ((sid2loc >= 54304 && sid2loc < 55296 || sid2loc >= 56832) && (sid2loc & 0x10) == 0) {
                    sidtune.info.sidChipBase2 = sid2loc;
                }
            }
        }
        sidtune.info.clockSpeed = SidTune.Clock.values()[clock];
        sidtune.info.sid1Model = SidTune.Model.values()[model1];
        sidtune.info.sid2Model = SidTune.Model.values()[model2];
        sidtune.convertOldStyleSpeedToTables(speed);
        sidtune.info.numberOfInfoStrings = (short)3;
        for (i = 0; i < pHeader.name.length && pHeader.name[i] != 0; ++i) {
        }
        sidtune.info.infoString[0] = PSid.makeString(pHeader.name, 0, Math.min(i, pHeader.name.length));
        for (i = 0; i < pHeader.author.length && pHeader.author[i] != 0; ++i) {
        }
        sidtune.info.infoString[1] = PSid.makeString(pHeader.author, 0, Math.min(i, pHeader.author.length));
        for (i = 0; i < pHeader.released.length && pHeader.released[i] != 0; ++i) {
        }
        sidtune.info.infoString[2] = PSid.makeString(pHeader.released, 0, Math.min(i, pHeader.released.length));
        for (i = 0; i < 3; ++i) {
            if (sidtune.info.infoString[i].length() != 0) continue;
            sidtune.info.infoString[i] = "<?>";
            sidtune.info.infoString[i] = sidtune.info.infoString[i];
        }
        if ((pHeader.flags & 1) != 0) {
            Mus mus = new Mus();
            mus.info = sidtune.info;
            mus.fileOffset = sidtune.fileOffset;
            return Mus.loadWithProvidedMetadata(dataBuf, null, mus);
        }
        sidtune.program = dataBuf;
        sidtune.resolveAddrs();
        sidtune.findPlaceForDriver();
        return sidtune;
    }

    private static String makeString(byte[] bytes, int start, int len) {
        try {
            return new String(bytes, start, len, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    @Override
    public void save(String name, boolean overWrite) throws IOException {
        FileOutputStream fos = new FileOutputStream(name, overWrite);
        PHeader myHeader = new PHeader();
        myHeader.id = "PSID".getBytes();
        myHeader.version = this.info.sidChipBase2 != 0 ? (short)3 : (short)2;
        myHeader.data = (short)124;
        myHeader.songs = (short)this.info.songs;
        myHeader.start = (short)this.info.startSong;
        myHeader.speed = this.getSongSpeedArray();
        int tmpFlags = 0;
        myHeader.init = (short)this.info.initAddr;
        myHeader.relocStartPage = (byte)this.info.relocStartPage;
        myHeader.relocPages = (byte)this.info.relocPages;
        switch (this.info.compatibility) {
            case RSID_BASIC: {
                tmpFlags = (short)(tmpFlags | 2);
            }
            case RSID: {
                myHeader.id = "RSID".getBytes();
                myHeader.speed = 0;
                break;
            }
            case PSIDv1: {
                tmpFlags = (short)(tmpFlags | 2);
            }
            default: {
                myHeader.play = (short)this.info.playAddr;
            }
        }
        if (this.info.numberOfInfoStrings == 3) {
            int i;
            if (this.info.infoString[0].length() == 32) {
                myHeader.version = (short)3;
            } else if (this.info.infoString[1].length() == 32) {
                myHeader.version = (short)3;
            } else if (this.info.infoString[2].length() == 32) {
                myHeader.version = (short)3;
            }
            for (i = 0; i < this.info.infoString[0].length(); ++i) {
                myHeader.name[i] = (byte)this.info.infoString[0].charAt(i);
            }
            for (i = 0; i < this.info.infoString[1].length(); ++i) {
                myHeader.author[i] = (byte)this.info.infoString[1].charAt(i);
            }
            for (i = 0; i < this.info.infoString[2].length(); ++i) {
                myHeader.released[i] = (byte)this.info.infoString[2].charAt(i);
            }
        }
        tmpFlags = (short)(tmpFlags | this.info.clockSpeed.ordinal() << 2);
        tmpFlags = (short)(tmpFlags | this.info.sid1Model.ordinal() << 4);
        tmpFlags = (short)(tmpFlags | this.info.sid2Model.ordinal() << 6);
        myHeader.flags = (short)tmpFlags;
        fos.write(myHeader.getArray());
        byte[] saveAddr = new byte[]{(byte)(this.info.loadAddr & 0xFF), (byte)(this.info.loadAddr >> 8)};
        fos.write(saveAddr);
        fos.write(this.program, this.fileOffset, this.info.dataFileLen - this.fileOffset);
        fos.close();
    }

    @Override
    public final String getMD5Digest() {
        byte[] encryptMsg;
        byte[] myMD5 = new byte[this.info.c64dataLen + 6 + this.info.songs + (this.info.clockSpeed == SidTune.Clock.NTSC ? 1 : 0)];
        System.arraycopy(this.program, this.fileOffset, myMD5, 0, this.info.c64dataLen);
        int i = this.info.c64dataLen;
        myMD5[i++] = (byte)(this.info.initAddr & 0xFF);
        myMD5[i++] = (byte)(this.info.initAddr >> 8);
        myMD5[i++] = (byte)(this.info.playAddr & 0xFF);
        myMD5[i++] = (byte)(this.info.playAddr >> 8);
        myMD5[i++] = (byte)(this.info.songs & 0xFF);
        myMD5[i++] = (byte)(this.info.songs >> 8);
        for (int s = 1; s <= this.info.songs; ++s) {
            myMD5[i++] = (byte)this.songSpeed[s - 1].speedValue();
        }
        if (this.info.clockSpeed == SidTune.Clock.NTSC) {
            myMD5[i++] = (byte)this.info.clockSpeed.ordinal();
        }
        StringBuilder md5 = new StringBuilder();
        for (byte anEncryptMsg : encryptMsg = md5Digest.digest(myMD5)) {
            md5.append(String.format("%02x", anEncryptMsg & 0xFF));
        }
        return md5.toString();
    }

    @Override
    public long getInitDelay() {
        return 2500L;
    }

    static {
        try {
            md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class PHeader {
        protected static final int SIZE = 124;
        public byte[] id = new byte[4];
        public short version;
        public short data;
        public short load;
        public short init;
        public short play;
        public short songs;
        public short start;
        public int speed;
        public byte[] name = new byte[32];
        public byte[] author = new byte[32];
        public byte[] released = new byte[32];
        public short flags;
        public byte relocStartPage;
        public byte relocPages;
        public byte sidChip2MiddleNybbles;
        public byte reserved;

        public PHeader(byte[] s) {
            ByteBuffer b = ByteBuffer.wrap(s);
            b.get(this.id);
            this.version = b.getShort();
            this.data = b.getShort();
            this.load = b.getShort();
            this.init = b.getShort();
            this.play = b.getShort();
            this.songs = b.getShort();
            this.start = b.getShort();
            this.speed = b.getInt();
            b.get(this.name);
            b.get(this.author);
            b.get(this.released);
            if (this.version >= 2) {
                this.flags = b.getShort();
                this.relocStartPage = b.get();
                this.relocPages = b.get();
                this.sidChip2MiddleNybbles = b.get();
                this.reserved = b.get();
            }
        }

        public PHeader() {
        }

        public byte[] getArray() {
            ByteBuffer b = ByteBuffer.allocate(124);
            b.put(this.id);
            b.putShort(this.version);
            b.putShort(this.data);
            b.putShort(this.load);
            b.putShort(this.init);
            b.putShort(this.play);
            b.putShort(this.songs);
            b.putShort(this.start);
            b.putInt(this.speed);
            b.put(this.name);
            b.put(this.author);
            b.put(this.released);
            if (this.version >= 2) {
                b.putShort(this.flags);
                b.put(this.relocStartPage);
                b.put(this.relocPages);
                b.put(this.sidChip2MiddleNybbles);
                b.put(this.reserved);
            }
            return b.array();
        }
    }
}

