/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.sidtune;

import java.nio.ByteBuffer;
import libsidplay.sidtune.Prg;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;

class P00
extends Prg {
    private static final int X00_ID_LEN = 8;
    private static final int X00_NAME_LEN = 17;
    private static final String _sidtune_id = "C64File";
    private static final String _sidtune_truncated = "ERROR: File is most likely truncated";

    protected P00() {
    }

    protected static SidTune load(String fileName, byte[] dataBuf) throws SidTuneError {
        int lastIndexOf = fileName.lastIndexOf(".");
        String ext = lastIndexOf != -1 ? fileName.substring(lastIndexOf) : "";
        X00Header pHeader = new X00Header(dataBuf);
        int bufLen = dataBuf.length;
        if (ext.length() != 4) {
            return null;
        }
        if (!Character.isDigit(ext.charAt(2)) || !Character.isDigit(ext.charAt(3))) {
            return null;
        }
        X00Format type = X00Format.X00_UNKNOWN;
        switch (Character.toUpperCase(ext.charAt(1))) {
            case 'D': {
                type = X00Format.X00_DEL;
                break;
            }
            case 'S': {
                type = X00Format.X00_SEQ;
                break;
            }
            case 'P': {
                type = X00Format.X00_PRG;
                break;
            }
            case 'U': {
                type = X00Format.X00_USR;
                break;
            }
            case 'R': {
                type = X00Format.X00_REL;
            }
        }
        if (type == X00Format.X00_UNKNOWN) {
            return null;
        }
        if (bufLen < 8) {
            return null;
        }
        if (!new String(pHeader.id, 0, 7).equals(_sidtune_id)) {
            return null;
        }
        P00 sidtune = new P00();
        if (type != X00Format.X00_PRG) {
            throw new SidTuneError("Not a PRG inside X00");
        }
        if (bufLen < 28) {
            throw new SidTuneError(_sidtune_truncated);
        }
        sidtune.info.infoString[0] = P00.convertPetsciiToAscii(pHeader.name, 0);
        sidtune.info.numberOfInfoStrings = 1;
        sidtune.fileOffset = 28;
        sidtune.info.loadAddr = dataBuf[26] & 0xFF | (dataBuf[27] & 0xFF) << 8;
        sidtune.info.c64dataLen = dataBuf.length - 2 - 26;
        sidtune.info.songs = 1;
        sidtune.info.startSong = 1;
        sidtune.program = dataBuf;
        sidtune.convertOldStyleSpeedToTables(-1L);
        return sidtune;
    }

    static enum X00Format {
        X00_UNKNOWN,
        X00_DEL,
        X00_SEQ,
        X00_PRG,
        X00_USR,
        X00_REL;

    }

    private static class X00Header {
        public static final int SIZE = 26;
        byte[] id = new byte[8];
        byte[] name = new byte[17];

        public X00Header(byte[] s) {
            ByteBuffer b = ByteBuffer.wrap(s);
            b.get(this.id);
            b.get(this.name);
        }
    }
}

