/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.pla;

import java.util.Arrays;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.components.OvImageIcon;
import libsidplay.components.cart.Cartridge;
import libsidplay.components.mos6510.MOS6510;
import libsidplay.components.mos656x.VIC;
import libsidplay.components.pla.Bank;
import libsidplay.components.pla.DisconnectedBusBank;
import libsidplay.components.ram.ColorRAMBank;
import libsidplay.mem.IBasic;
import libsidplay.mem.IChar;
import libsidplay.mem.IKernal;

public final class PLA {
    private static final OvImageIcon cart = new OvImageIcon(Cartridge.class.getResource("icons/cartridge.png"));
    private static final Bank characterRomBank = new Bank(){

        @Override
        public byte read(int address) {
            return IChar.CHAR[address & 0xFFF];
        }

        @Override
        public void write(int address, byte value) {
            throw new RuntimeException("This bank should never be mapped to W mode");
        }
    };
    private static final Bank basicRomBank = new Bank(){

        @Override
        public byte read(int address) {
            return IBasic.BASIC[address & 0x1FFF];
        }

        @Override
        public void write(int address, byte value) {
            throw new RuntimeException("This bank should never be mapped to W mode");
        }
    };
    private static final Bank kernalRomBank = new Bank(){

        @Override
        public byte read(int address) {
            return IKernal.KERNAL[address & 0x1FFF];
        }

        @Override
        public void write(int address, byte value) {
            throw new RuntimeException("This bank should never be mapped to W mode");
        }
    };
    private Bank customKernalRomBank;
    protected final ColorRAMBank colorRamBank = new ColorRAMBank();
    private final Bank colorRamDisconnectedBusBank = new Bank(){

        @Override
        public byte read(int address) {
            return (byte)(PLA.this.colorRamBank.read(address) | PLA.this.disconnectedBusBank.read(address) & 0xF0);
        }

        @Override
        public void write(int address, byte value) {
            PLA.this.colorRamBank.write(address, value);
        }
    };
    private final IOBank ioBank = new IOBank();
    private boolean basic;
    private boolean kernal;
    private boolean io;
    private final Bank[] cpuReadMap = new Bank[16];
    private final Bank[] cpuWriteMap = new Bank[16];
    private final Bank[] vicMapPHI1 = new Bank[16];
    private int vicMemBase;
    private boolean oldBAState;
    protected boolean aecDuringPhi2;
    private final Event aecDisableEvent = new Event("BA transitions"){

        @Override
        public void event() {
            PLA.this.aecDuringPhi2 = false;
        }
    };
    private final EventScheduler context;
    private MOS6510 cpu;
    private final Bank ramBank;
    private Cartridge cartridge;
    private final Cartridge nullCartridge;
    protected DisconnectedBusBank disconnectedBusBank;
    private boolean gamePHI1;
    private boolean exromPHI1;
    private boolean gamePHI2;
    private boolean exromPHI2;
    private int nmiCount;
    private int irqCount;
    private boolean cartridgeDma;

    public void setCustomKernalRomBank(Bank kernalRom) {
        this.customKernalRomBank = kernalRom;
    }

    public PLA(EventScheduler context, Bank sid, Bank zeroRAMBank, Bank ramBank) {
        this.context = context;
        this.ramBank = ramBank;
        this.nullCartridge = Cartridge.nullCartridge(this);
        this.ioBank.setBank(4, sid);
        this.ioBank.setBank(5, sid);
        this.ioBank.setBank(6, sid);
        this.ioBank.setBank(7, sid);
        this.ioBank.setBank(8, this.colorRamDisconnectedBusBank);
        this.ioBank.setBank(9, this.colorRamDisconnectedBusBank);
        this.ioBank.setBank(10, this.colorRamDisconnectedBusBank);
        this.ioBank.setBank(11, this.colorRamDisconnectedBusBank);
        Arrays.fill(this.cpuReadMap, ramBank);
        Arrays.fill(this.cpuWriteMap, ramBank);
        this.cpuReadMap[0] = this.cpuWriteMap[0] = zeroRAMBank;
        Arrays.fill(this.vicMapPHI1, ramBank);
        this.setCartridge(null);
    }

    public void reset() {
        this.exromPHI2 = true;
        this.gamePHI2 = true;
        this.exromPHI1 = true;
        this.gamePHI1 = true;
        this.vicMemBase = 0;
        this.aecDuringPhi2 = false;
        this.oldBAState = true;
        this.nmiCount = 0;
        this.irqCount = 0;
        this.colorRamBank.reset();
        this.cartridge.reset();
        this.updateMappingPHI1();
        this.updateMappingPHI2();
    }

    public void setCpuPort(int state) {
        this.basic = (state & 1) != 0;
        this.kernal = (state & 2) != 0;
        this.io = (state & 4) != 0;
        this.updateMappingPHI2();
    }

    public void setGameExrom(boolean game, boolean exrom) {
        this.setGameExrom(game, exrom, game, exrom);
    }

    public void setGameExrom(boolean gamephi1, boolean exromphi1, boolean gamephi2, boolean exromphi2) {
        this.gamePHI1 = gamephi1;
        this.exromPHI1 = exromphi1;
        this.updateMappingPHI1();
        this.exromPHI2 = exromphi2;
        this.gamePHI2 = gamephi2;
        this.updateMappingPHI2();
    }

    public void setBA(boolean state) {
        if (state ^ !this.oldBAState) {
            return;
        }
        this.oldBAState = state;
        if (!this.cartridgeDma) {
            this.cpu.setRDY(state);
        }
        this.cartridge.changedBA(state);
        if (state) {
            this.aecDuringPhi2 = true;
            this.context.cancel(this.aecDisableEvent);
        } else {
            this.context.schedule(this.aecDisableEvent, 3L, Event.Phase.PHI1);
        }
    }

    public void setDMA(boolean state) {
        this.cartridgeDma = state;
        if (this.cartridgeDma) {
            if (this.oldBAState) {
                this.cpu.setRDY(false);
            }
        } else if (this.oldBAState) {
            this.cpu.setRDY(true);
        }
    }

    public void setNMI(boolean state) {
        if (state) {
            if (this.nmiCount == 0) {
                this.cpu.triggerNMI();
                this.cartridge.changedNMI(true);
            }
            ++this.nmiCount;
        } else {
            --this.nmiCount;
            if (this.nmiCount == 0) {
                this.cartridge.changedNMI(false);
            }
        }
    }

    public void setIRQ(boolean state) {
        if (state) {
            if (this.irqCount == 0) {
                this.cpu.triggerIRQ();
                this.cartridge.changedIRQ(true);
            }
            ++this.irqCount;
        } else {
            --this.irqCount;
            if (this.irqCount == 0) {
                this.cpu.clearIRQ();
                this.cartridge.changedIRQ(false);
            }
        }
    }

    private void updateMappingPHI2() {
        if (this.exromPHI2 && !this.gamePHI2) {
            for (int i : new int[]{1, 2, 3, 4, 5, 6, 7, 10, 11, 12}) {
                this.cpuReadMap[i] = this.cpuWriteMap[i] = this.cartridge.getUltimaxMemory();
            }
            this.cpuWriteMap[8] = this.cpuWriteMap[9] = this.cartridge.getRoml();
            this.cpuReadMap[9] = this.cpuWriteMap[9];
            this.cpuReadMap[8] = this.cpuWriteMap[9];
            this.cpuReadMap[13] = this.ioBank;
            this.cpuWriteMap[13] = this.ioBank;
            this.cpuWriteMap[14] = this.cpuWriteMap[15] = this.cartridge.getRomh();
            this.cpuReadMap[15] = this.cpuWriteMap[15];
            this.cpuReadMap[14] = this.cpuWriteMap[15];
        } else {
            for (int i : new int[]{1, 2, 3, 4, 5, 6, 7, 12}) {
                this.cpuReadMap[i] = this.cpuWriteMap[i] = this.ramBank;
            }
            this.cpuWriteMap[8] = this.cpuWriteMap[9] = this.ramBank;
            this.cpuWriteMap[10] = this.cpuWriteMap[11] = this.ramBank;
            this.cpuWriteMap[14] = this.cpuWriteMap[15] = this.ramBank;
            this.cpuReadMap[8] = this.basic && this.kernal && !this.exromPHI2 ? (this.cpuReadMap[9] = this.cartridge.getRoml()) : (this.cpuReadMap[9] = this.ramBank);
            this.cpuReadMap[10] = this.kernal && !this.exromPHI2 && !this.gamePHI2 ? (this.cpuReadMap[11] = this.cartridge.getRomh()) : (this.basic && this.kernal & this.gamePHI2 ? (this.cpuReadMap[11] = basicRomBank) : (this.cpuReadMap[11] = this.ramBank));
            if (this.io && (this.basic || this.kernal) && (this.gamePHI2 || !this.gamePHI2 && !this.exromPHI2)) {
                this.cpuReadMap[13] = this.cpuWriteMap[13] = this.ioBank;
            } else if (!this.io && ((this.basic || this.kernal) && this.gamePHI2 || this.kernal && !this.gamePHI2 && !this.exromPHI2)) {
                this.cpuReadMap[13] = characterRomBank;
                this.cpuWriteMap[13] = this.ramBank;
            } else {
                this.cpuReadMap[13] = this.ramBank;
                this.cpuWriteMap[13] = this.ramBank;
            }
            if (this.kernal & (this.gamePHI2 || !this.gamePHI2 && !this.exromPHI2)) {
                this.cpuReadMap[15] = this.customKernalRomBank != null ? this.customKernalRomBank : kernalRomBank;
                this.cpuReadMap[14] = this.cpuReadMap[15];
            } else {
                this.cpuReadMap[14] = this.cpuReadMap[15] = this.ramBank;
            }
        }
        Bank io1 = this.cartridge.getIO1();
        this.ioBank.setBank(14, io1);
        Bank io2 = this.cartridge.getIO2();
        this.ioBank.setBank(15, io2);
        this.cartridge.installBankHooks(this.cpuReadMap, this.cpuWriteMap);
    }

    private void updateMappingPHI1() {
        this.vicMapPHI1[1] = this.gamePHI1 || !this.gamePHI1 && !this.exromPHI1 ? (this.vicMapPHI1[9] = characterRomBank) : (this.vicMapPHI1[9] = this.ramBank);
        if (this.exromPHI1 && !this.gamePHI1) {
            for (int i = 3; i < 16; i += 4) {
                this.vicMapPHI1[i] = this.cartridge.getRomh();
            }
        } else {
            for (int i = 3; i < 16; i += 4) {
                this.vicMapPHI1[i] = this.ramBank;
            }
        }
    }

    public byte cpuRead(int address) {
        return this.cpuReadMap[address >> 12].read(address);
    }

    public void cpuWrite(int address, byte value) {
        this.cpuWriteMap[address >> 12].write(address, value);
    }

    public void setVicMemBase(int base) {
        this.vicMemBase = base;
    }

    public byte vicReadMemoryPHI1(int addr) {
        return this.vicMapPHI1[(addr |= this.vicMemBase) >> 12].read(addr);
    }

    public byte vicReadMemoryPHI2(int addr) {
        if (this.aecDuringPhi2) {
            return -1;
        }
        return this.vicReadMemoryPHI1(addr);
    }

    public byte vicReadColorMemoryPHI2(int addr) {
        if (this.aecDuringPhi2) {
            return (byte)(this.cpu.getStalledOnByte() & 0xF);
        }
        return this.colorRamBank.read(addr);
    }

    public void setCartridge(Cartridge cartridge) {
        if (cartridge == null) {
            cartridge = this.nullCartridge;
        }
        this.cartridge = cartridge;
        this.updateIcons();
    }

    private void updateIcons() {
        cart.setImageName(this.cartridge.toString());
    }

    public void setCpu(MOS6510 cpu) {
        this.cpu = cpu;
    }

    public void setCia1(Bank cia1) {
        this.ioBank.setBank(12, cia1);
    }

    public void setCia2(Bank cia2) {
        this.ioBank.setBank(13, cia2);
    }

    public void setVic(VIC vic) {
        this.ioBank.setBank(0, vic);
        this.ioBank.setBank(1, vic);
        this.ioBank.setBank(2, vic);
        this.ioBank.setBank(3, vic);
        this.disconnectedBusBank = new DisconnectedBusBank(vic);
    }

    public Bank getDisconnectedBusBank() {
        return this.disconnectedBusBank;
    }

    public MOS6510 getCPU() {
        return this.cpu;
    }

    public Cartridge getCartridge() {
        return this.cartridge;
    }

    public OvImageIcon getIcon() {
        return cart;
    }

    public static class IOBank
    extends Bank {
        private final Bank[] map = new Bank[16];

        public void setBank(int num, Bank b) {
            this.map[num] = b;
        }

        @Override
        public byte read(int address) {
            return this.map[address >> 8 & 0xF].read(address);
        }

        @Override
        public void write(int address, byte value) {
            this.map[address >> 8 & 0xF].write(address, value);
        }
    }
}

