/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.keyboard;

import java.util.HashSet;
import java.util.Set;
import libsidplay.components.keyboard.KeyTableEntry;

public abstract class Keyboard {
    private final Set<KeyTableEntry> keysDown = new HashSet<KeyTableEntry>();
    private boolean cbm;
    private boolean leftShift;
    private boolean rightShift;
    private int forcedShift = 0;

    public synchronized void reset() {
        this.keysDown.clear();
        this.rightShift = false;
        this.leftShift = false;
        this.cbm = false;
        this.forcedShift = 0;
    }

    public synchronized void keyPressed(KeyTableEntry ktEntry) {
        if (this.keysDown.contains(ktEntry)) {
            return;
        }
        if (ktEntry.hasShiftPreference()) {
            this.forcedShift += ktEntry.shiftDown() ? 1 : -1;
        }
        if (ktEntry.hasCommodorePreference()) {
            this.cbm = true;
        }
        this.keysDown.add(ktEntry);
    }

    public synchronized void keyReleased(KeyTableEntry ktEntry) {
        if (!this.keysDown.contains(ktEntry)) {
            return;
        }
        if (ktEntry.hasShiftPreference()) {
            this.forcedShift -= ktEntry.shiftDown() ? 1 : -1;
        }
        if (ktEntry.hasCommodorePreference()) {
            this.cbm = false;
        }
        this.keysDown.remove(ktEntry);
    }

    private synchronized byte readMatrix(byte selected, boolean wantRow) {
        if (this.cbm) {
            this.keyPressed(KeyTableEntry.COMMODORE);
        }
        if (this.forcedShift >= (this.rightShift ? 0 : 1)) {
            this.keyPressed(KeyTableEntry.SHIFT_RIGHT);
        }
        if (this.forcedShift >= (this.leftShift ? 0 : 1)) {
            this.keyPressed(KeyTableEntry.SHIFT_LEFT);
        }
        byte result = -1;
        for (KeyTableEntry kte : this.keysDown) {
            if (wantRow) {
                if ((selected & 1 << kte.getCol()) != 0) continue;
                result = (byte)(result & ~(1 << kte.getRow()));
                continue;
            }
            if ((selected & 1 << kte.getRow()) != 0) continue;
            result = (byte)(result & ~(1 << kte.getCol()));
        }
        if (this.cbm) {
            this.keyReleased(KeyTableEntry.COMMODORE);
        }
        if (this.forcedShift >= (this.rightShift ? 0 : 1)) {
            this.keyReleased(KeyTableEntry.SHIFT_RIGHT);
        }
        if (this.forcedShift >= (this.leftShift ? 0 : 1)) {
            this.keyReleased(KeyTableEntry.SHIFT_LEFT);
        }
        return result;
    }

    public byte readColumn(byte selected) {
        return this.readMatrix(selected, true);
    }

    public byte readRow(byte selected) {
        return this.readMatrix(selected, false);
    }

    public synchronized void cbm(boolean b) {
        this.cbm = b;
    }

    public synchronized void leftShift(boolean b) {
        this.leftShift = b;
    }

    public synchronized void rightShift(boolean b) {
        this.rightShift = b;
    }

    public abstract void restore();
}

