/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.iec;

import java.util.Arrays;
import libsidplay.common.ISID2Types;
import libsidplay.components.iec.IECBus;

public abstract class SerialIECDevice {
    protected static final int IECBUS_DEVICE_READ_DATA = 1;
    protected static final int IECBUS_DEVICE_READ_CLK = 4;
    protected static final int IECBUS_DEVICE_READ_ATN = 128;
    protected static final int IECBUS_DEVICE_WRITE_CLK = 64;
    protected static final int IECBUS_DEVICE_WRITE_DATA = 128;
    protected static final int P_PRE0 = 0;
    protected static final int P_PRE1 = 1;
    protected static final int P_PRE2 = 2;
    protected static final int P_READY = 3;
    protected static final int P_EOI = 4;
    protected static final int P_EOIw = 5;
    protected static final int P_BIT0 = 6;
    protected static final int P_BIT0w = 7;
    protected static final int P_BIT1 = 8;
    protected static final int P_BIT1w = 9;
    protected static final int P_BIT2 = 10;
    protected static final int P_BIT2w = 11;
    protected static final int P_BIT3 = 12;
    protected static final int P_BIT3w = 13;
    protected static final int P_BIT4 = 14;
    protected static final int P_BIT4w = 15;
    protected static final int P_BIT5 = 16;
    protected static final int P_BIT5w = 17;
    protected static final int P_BIT6 = 18;
    protected static final int P_BIT6w = 19;
    protected static final int P_BIT7 = 20;
    protected static final int P_BIT7w = 21;
    protected static final int P_DONE0 = 22;
    protected static final int P_DONE1 = 23;
    protected static final int P_FRAMEERR0 = 24;
    protected static final int P_FRAMEERR1 = 25;
    protected static final int P_TALKING = 32;
    protected static final int P_LISTENING = 64;
    protected static final int P_ATN = 128;
    protected boolean enabled;
    protected byte byt;
    protected byte state;
    protected byte flags;
    protected byte primary;
    protected byte secondary;
    protected byte secondaryPrev;
    protected byte[] st = new byte[16];
    protected long timeout;
    private byte serialIECDeviceSt;
    private double serialIECDeviceCyclesPerUs = 1.0;
    private IECBus iecBus;
    protected int prnr = 0;

    public SerialIECDevice(IECBus bus) {
        this.iecBus = bus;
        this.enabled = false;
        this.iecBus.deviceWrite(this.prnr, (byte)-64);
    }

    public void reset() {
        if (this.enabled) {
            this.iecBus.deviceWrite(this.prnr, (byte)-64);
            this.flags = 0;
            this.timeout = 0L;
            Arrays.fill(this.st, 0, 15, (byte)0);
        }
    }

    protected void setDeviceEnable(boolean enable) {
        if (enable) {
            if (!this.enabled) {
                this.enabled = true;
                this.flags = 0;
                this.timeout = 0L;
                Arrays.fill(this.st, 0, 15, (byte)0);
            }
        } else if (this.enabled) {
            this.iecBus.deviceWrite(this.prnr, (byte)-64);
            this.enabled = false;
            this.timeout = 0L;
        }
    }

    public int getID() {
        return this.prnr;
    }

    public void setClock(ISID2Types.Clock cpuFreq) {
        this.serialIECDeviceCyclesPerUs = cpuFreq.getCpuFrequency() / 1000000.0;
    }

    public void clock() {
        if (this.enabled) {
            byte bus = this.iecBus.deviceRead();
            if (0 == (this.flags & 0x80) && 0 == (bus & 0x80)) {
                this.state = 0;
                this.flags = (byte)(this.flags | 0x80);
                this.primary = 0;
                this.secondaryPrev = this.secondary;
                this.secondary = 0;
                this.timeout = this.clk() + this.usToCycles(100.0);
                this.iecBus.deviceWrite(this.prnr, (byte)64);
            } else if ((this.flags & 0x80) != 0 && (bus & 0x80) != 0) {
                this.flags = (byte)(this.flags & 0xFFFFFF7F);
                if (this.primary == 32 + this.prnr || this.primary == 64 + this.prnr) {
                    if ((this.secondary & 0xF0) == 96) {
                        switch (this.primary & 0xF0) {
                            case 32: {
                                this.listenTalk(this.prnr, this.secondary);
                                this.serialIECDeviceSt = this.getStatus();
                                break;
                            }
                            case 64: {
                                this.listenTalk(this.prnr, this.secondary);
                                this.serialIECDeviceSt = this.getStatus();
                            }
                        }
                    } else if ((this.secondary & 0xF0) == 224) {
                        this.serialIECDeviceSt = 0;
                        this.close(this.prnr, this.secondary);
                        this.st[this.secondary & 0xF] = this.serialIECDeviceSt = this.getStatus();
                    } else if ((this.secondary & 0xF0) == 240) {
                        this.serialIECDeviceSt = 0;
                        this.open(this.prnr, this.secondary);
                        this.st[this.secondary & 0xF] = this.serialIECDeviceSt = this.getStatus();
                    }
                    if (this.primary == 32 + this.prnr) {
                        this.flags = (byte)(this.flags & 0xFFFFFFDF);
                        if (this.st[this.secondary & 0xF] == 0) {
                            this.flags = (byte)(this.flags | 0x40);
                            this.state = 1;
                        }
                        this.iecBus.deviceWrite(this.prnr, (byte)64);
                    } else if (this.primary == 64 + this.prnr) {
                        this.flags = (byte)(this.flags & 0xFFFFFFBF);
                        this.flags = (byte)(this.flags | 0x20);
                        this.state = 0;
                    }
                } else if (this.primary == 63 && (this.flags & 0x40) != 0) {
                    this.flags = (byte)(this.flags & 0xFFFFFFBF);
                    this.serialIECDeviceSt = this.st[this.secondaryPrev & 0xF];
                    this.unlisten(this.prnr, this.secondaryPrev);
                    this.st[this.secondaryPrev & 0xF] = this.serialIECDeviceSt = this.getStatus();
                } else if (this.primary == 95 && (this.flags & 0x20) != 0) {
                    this.untalk(this.prnr, this.secondaryPrev);
                    this.serialIECDeviceSt = this.getStatus();
                    this.flags = (byte)(this.flags & 0xFFFFFFDF);
                }
                if (0 == (this.flags & 0x60)) {
                    this.iecBus.deviceWrite(this.prnr, (byte)-64);
                }
            }
            if ((this.flags & 0xC0) != 0) {
                switch (this.state) {
                    case 0: {
                        if (this.clk() < this.timeout) break;
                        this.state = 1;
                        break;
                    }
                    case 1: {
                        if (0 != (bus & 4)) break;
                        this.state = (byte)2;
                        break;
                    }
                    case 2: {
                        if ((bus & 4) == 0) break;
                        this.iecBus.deviceWrite(this.prnr, (byte)-64);
                        this.timeout = this.clk() + this.usToCycles(200.0);
                        this.state = (byte)3;
                        break;
                    }
                    case 3: {
                        if (0 == (bus & 4)) {
                            this.state = (byte)6;
                            break;
                        }
                        if (0 != (this.flags & 0x80) || this.clk() < this.timeout) break;
                        this.iecBus.deviceWrite(this.prnr, (byte)64);
                        this.state = (byte)4;
                        this.timeout = this.clk() + this.usToCycles(60.0);
                        break;
                    }
                    case 4: {
                        if (this.clk() < this.timeout) break;
                        this.iecBus.deviceWrite(this.prnr, (byte)-64);
                        this.state = (byte)5;
                        break;
                    }
                    case 5: {
                        if (0 != (bus & 4)) break;
                        this.state = (byte)6;
                        break;
                    }
                    case 6: 
                    case 8: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 16: 
                    case 18: 
                    case 20: {
                        if ((bus & 4) == 0) break;
                        byte bit = (byte)(1 << (byte)(this.state - 6) / 2);
                        this.byt = (byte)(this.byt & ~bit | ((bus & 1) != 0 ? bit : (byte)0));
                        this.state = (byte)(this.state + 1);
                        break;
                    }
                    case 7: 
                    case 9: 
                    case 11: 
                    case 13: 
                    case 15: 
                    case 17: 
                    case 19: {
                        if (0 != (bus & 4)) break;
                        this.state = (byte)(this.state + 1);
                        break;
                    }
                    case 21: {
                        if (0 != (bus & 4)) break;
                        if ((this.flags & 0x80) != 0) {
                            if (this.primary == 0) {
                                this.primary = this.byt;
                            } else if (this.secondary == 0) {
                                this.secondary = this.byt;
                            }
                            if (0 == (this.primary & 0x10) && (this.primary & 0xF) != this.prnr) {
                                this.state = (byte)22;
                                break;
                            }
                            this.iecBus.deviceWrite(this.prnr, (byte)64);
                            this.state = (byte)2;
                            break;
                        }
                        if ((this.flags & 0x40) == 0) break;
                        this.serialIECDeviceSt = this.st[this.secondary & 0xF];
                        this.write(this.prnr, this.secondary, this.byt);
                        this.st[this.secondary & 0xF] = this.serialIECDeviceSt = this.getStatus();
                        if (this.st[this.secondary & 0xF] != 0) {
                            this.state = (byte)22;
                            break;
                        }
                        this.iecBus.deviceWrite(this.prnr, (byte)64);
                        this.state = (byte)2;
                        break;
                    }
                }
            } else if ((this.flags & 0x20) != 0) {
                switch (this.state) {
                    case 0: {
                        if ((bus & 4) == 0) break;
                        this.iecBus.deviceWrite(this.prnr, (byte)-128);
                        this.state = 1;
                        this.timeout = this.clk() + this.usToCycles(80.0);
                        break;
                    }
                    case 1: {
                        if (this.clk() >= this.timeout) {
                            this.iecBus.deviceWrite(this.prnr, (byte)-64);
                            this.state = (byte)3;
                            break;
                        }
                    }
                    case 3: {
                        if ((bus & 1) == 0) break;
                        this.serialIECDeviceSt = this.st[this.secondary & 0xF];
                        byte data = this.read(this.prnr, this.secondary);
                        this.serialIECDeviceSt = this.getStatus();
                        this.byt = data;
                        this.st[this.secondary & 0xF] = this.serialIECDeviceSt;
                        if (this.st[this.secondary & 0xF] == 0) {
                            this.state = (byte)6;
                            this.timeout = this.clk();
                            break;
                        }
                        if (this.st[this.secondary & 0xF] == 64) {
                            this.state = (byte)4;
                            break;
                        }
                        this.flags = (byte)(this.flags & 0xFFFFFFDF);
                        break;
                    }
                    case 4: {
                        if (0 != (bus & 1)) break;
                        this.state = (byte)5;
                        break;
                    }
                    case 5: {
                        if ((bus & 1) == 0) break;
                        this.state = (byte)6;
                        this.timeout = this.clk();
                        break;
                    }
                    case 6: 
                    case 8: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 16: 
                    case 18: 
                    case 20: {
                        if (this.clk() < this.timeout) break;
                        int bit = 1 << (this.state - 6) / 2;
                        this.iecBus.deviceWrite(this.prnr, (byte)((this.byt & bit) != 0 ? 128 : 0));
                        this.timeout = this.clk() + this.usToCycles(60.0);
                        this.state = (byte)(this.state + 1);
                        break;
                    }
                    case 7: 
                    case 9: 
                    case 11: 
                    case 13: 
                    case 15: 
                    case 17: 
                    case 19: 
                    case 21: {
                        if (this.clk() < this.timeout) break;
                        if ((bus & 1) != 0) {
                            this.iecBus.deviceWrite(this.prnr, (byte)-64);
                        } else {
                            this.iecBus.deviceWrite(this.prnr, (byte)64);
                        }
                        this.timeout = this.clk() + this.usToCycles(60.0);
                        this.state = (byte)(this.state + 1);
                        break;
                    }
                    case 22: {
                        if (this.clk() < this.timeout) break;
                        this.iecBus.deviceWrite(this.prnr, (byte)-128);
                        this.timeout = this.clk() + this.usToCycles(1000.0);
                        this.state = (byte)23;
                        break;
                    }
                    case 23: {
                        if (0 == (bus & 1)) {
                            if (this.st[this.secondary & 0xF] == 64) {
                                this.flags = (byte)(this.flags & 0xFFFFFFDF);
                                this.st[this.secondary & 0xF] = 0;
                                this.iecBus.deviceWrite(this.prnr, (byte)-64);
                                break;
                            }
                            this.timeout = this.clk();
                            this.state = 1;
                            break;
                        }
                        if (this.clk() < this.timeout) break;
                        this.iecBus.deviceWrite(this.prnr, (byte)-64);
                        this.timeout = this.clk() + this.usToCycles(100.0);
                        this.state = (byte)24;
                        break;
                    }
                    case 24: {
                        if (this.clk() < this.timeout) break;
                        this.iecBus.deviceWrite(this.prnr, (byte)-128);
                        this.state = (byte)25;
                        break;
                    }
                    case 25: {
                        if (0 != (bus & 1)) break;
                        this.timeout = this.clk();
                        this.state = 1;
                    }
                }
            }
        }
    }

    private long usToCycles(double us) {
        return (long)(us * this.serialIECDeviceCyclesPerUs + 0.5);
    }

    public abstract void open(int var1, byte var2);

    public abstract void close(int var1, byte var2);

    public abstract void listenTalk(int var1, byte var2);

    public abstract void unlisten(int var1, byte var2);

    public abstract void untalk(int var1, byte var2);

    public abstract byte read(int var1, byte var2);

    public abstract void write(int var1, byte var2, byte var3);

    public abstract byte getStatus();

    public abstract long clk();
}

