/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.iec;

import java.util.Arrays;
import libsidplay.components.c1541.C1541;
import libsidplay.components.iec.SerialIECDevice;

public class IECBus {
    public static final int IECBUS_NUM = 16;
    protected byte[] drvBus = new byte[16];
    protected byte[] drvData = new byte[16];
    protected byte drvPort;
    protected byte cpuBus;
    protected byte cpuPort;
    protected C1541[] drives = new C1541[0];
    protected SerialIECDevice[] serialDevices = new SerialIECDevice[0];

    public IECBus() {
        this.reset();
    }

    public final void reset() {
        Arrays.fill(this.drvBus, (byte)-1);
        Arrays.fill(this.drvData, (byte)-1);
        this.cpuBus = (byte)-1;
        this.cpuPort = (byte)-1;
        this.drvPort = (byte)-123;
    }

    public final void setFloppies(C1541[] drvs) {
        this.drives = drvs;
    }

    public final void setSerialDevices(SerialIECDevice[] devices) {
        this.serialDevices = devices;
    }

    public final byte readFromIECBus() {
        for (SerialIECDevice serialDevice : this.serialDevices) {
            serialDevice.clock();
        }
        return this.cpuPort;
    }

    public final void writeToIECBus(byte data) {
        for (SerialIECDevice serialDevice : this.serialDevices) {
            serialDevice.clock();
        }
        byte oldCpuBus = this.cpuBus;
        this.cpuBus = (byte)((data & 0xFF) << 2 & 0x80 | (data & 0xFF) << 2 & 0x40 | (data & 0xFF) << 1 & 0x10);
        if (((oldCpuBus ^ this.cpuBus) & 0x10) != 0) {
            for (C1541 drive : this.drives) {
                drive.getBusController().signal(0, (this.cpuBus & 0x10) != 0 ? 0 : 1);
            }
        }
        for (C1541 drive : this.drives) {
            this.setDriveBus(drive.getID());
        }
        this.updatePorts();
    }

    public final byte deviceRead() {
        return this.drvPort;
    }

    public final void deviceWrite(int deviceNum, byte data) {
        this.drvBus[deviceNum] = data;
        this.updatePorts();
    }

    public final void updateDrive(int deviceNum, byte byt) {
        this.drvData[deviceNum] = ~byt;
        this.setDriveBus(deviceNum);
        this.updatePorts();
    }

    protected final void setDriveBus(int deviceNum) {
        this.drvBus[deviceNum] = (byte)((this.drvData[deviceNum] & 0xFF) << 3 & 0x40 | (this.drvData[deviceNum] & 0xFF) << 6 & ((~this.drvData[deviceNum] ^ this.cpuBus) & 0xFF) << 3 & 0x80);
    }

    protected final void updatePorts() {
        this.cpuPort = this.cpuBus;
        for (SerialIECDevice serialDevice : this.serialDevices) {
            this.cpuPort = (byte)(this.cpuPort & this.drvBus[serialDevice.getID()]);
        }
        for (C1541 drive : this.drives) {
            this.cpuPort = (byte)(this.cpuPort & this.drvBus[drive.getID()]);
        }
        this.drvPort = (byte)((this.cpuPort & 0xFF) >> 4 & 4 | (this.cpuPort & 0xFF) >> 7 | (this.cpuBus & 0xFF) << 3 & 0x80);
    }
}

