/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported;

import java.io.DataInputStream;
import java.io.IOException;
import libsidplay.components.cart.Cartridge;
import libsidplay.components.pla.Bank;
import libsidplay.components.pla.PLA;

public class Rex
extends Cartridge {
    protected final byte[] romL;
    private final Bank romL_Bank = new Bank(){

        @Override
        public byte read(int address) {
            return Rex.this.romL[address & 0x1FFF];
        }
    };
    private final Bank io2Bank = new Bank(){

        @Override
        public byte read(int address) {
            if ((address & 0xFF) < 192) {
                Rex.this.pla.setGameExrom(true, true);
            } else {
                Rex.this.pla.setGameExrom(true, false);
            }
            return 0;
        }

        @Override
        public void write(int address, byte value) {
        }
    };

    public Rex(DataInputStream is, PLA pla) throws IOException {
        super(pla);
        byte[] chipHeader = new byte[16];
        is.readFully(chipHeader);
        int bankLen = (chipHeader[14] & 0xFF) << 8;
        this.romL = new byte[bankLen];
        is.readFully(this.romL);
    }

    @Override
    public Bank getRoml() {
        return this.romL_Bank;
    }

    @Override
    public Bank getIO2() {
        return this.io2Bank;
    }

    @Override
    public void reset() {
        this.io2Bank.read(57087);
    }
}

