/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import libsidplay.components.cart.Cartridge;
import libsidplay.components.cart.SDCard;
import libsidplay.components.pla.Bank;
import libsidplay.components.pla.PLA;
import libsidplay.mem.IMMC_BIOS104;

public class MMC64
extends Cartridge {
    protected boolean enabled;
    protected boolean clockportEnabled;
    protected int hwClockport = 56834;
    protected int biosWrite;
    protected String imageFilename;
    protected RandomAccessFile imageFile;
    protected int imagePointer;
    protected int writeSequence;
    protected byte[] cmdBuffer = new byte[9];
    protected int cmdBufferPointer;
    protected boolean bit7Unlocked;
    protected byte[] unlocking = new byte[]{0, 0};
    protected boolean biosChanged;
    protected boolean hwFlashJumper;
    protected boolean hwWriteProtect;
    protected byte active;
    protected byte spiMode;
    protected byte extrom;
    protected byte flashMode;
    protected byte cport;
    protected byte speed;
    protected byte cardsel;
    protected byte biossel;
    public static final int MMC_FLASHJMP = 32;
    public static final int MMC_WRITEPROT = 16;
    public static final int MMC_CARDPRS = 8;
    public static final int MMC_EXTEXROM = 4;
    public static final int MMC_EXTGAME = 2;
    public static final int MMC_SPISTAT = 1;
    protected byte flashJumper;
    protected boolean extExrom;
    protected boolean extGame;
    protected int revision;
    protected int sdType;
    protected boolean imageFileReadonly;
    protected byte[] bios = IMMC_BIOS104.BIOS_1_04;
    SDCard card = new SDCard();
    protected final Bank io2Bank = new Bank(){

        @Override
        public byte read(int addr) {
            if (MMC64.this.enabled && addr >= 57104 && addr <= 57107) {
                if (MMC64.this.active != 0) {
                    return 0;
                }
                switch (addr) {
                    case 57104: {
                        byte value = MMC64.this.card.dataRead();
                        return value;
                    }
                    case 57105: {
                        byte value = MMC64.this.biossel;
                        value = (byte)(value | MMC64.this.card.cardSelectedRead() << 1);
                        value = (byte)(value | MMC64.this.card.enable8mhzRead() << 2);
                        value = (byte)(value | MMC64.this.cport << 3);
                        value = (byte)(value | MMC64.this.flashMode << 4);
                        value = (byte)(value | MMC64.this.extrom << 5);
                        value = (byte)(value | MMC64.this.card.triggerModeRead() << 6);
                        value = (byte)(value | MMC64.this.active << 7);
                        return value;
                    }
                    case 2: 
                    case 57106: {
                        byte value = (byte)(MMC64.this.flashJumper << 5);
                        value = (byte)(value | MMC64.this.card.mmcBusy());
                        value = (byte)(value | (MMC64.this.extExrom ? 0 : 1) << 1);
                        value = (byte)(value | (MMC64.this.extGame ? 0 : 1) << 2);
                        value = (byte)(value | (MMC64.this.card.cardInserted() ^ 1) << 3);
                        value = (byte)(value | (MMC64.this.card.cardWriteEnabled() ? 0 : 1) << 4);
                        return value;
                    }
                    case 57107: {
                        if (0 == MMC64.this.cardsel) {
                            return 100;
                        }
                        if (MMC64.this.revision != 0) {
                            return 2;
                        }
                        return 1;
                    }
                }
            }
            return MMC64.this.pla.getDisconnectedBusBank().read(addr);
        }

        @Override
        public void write(int addr, byte value) {
            MMC64.this.regStore(addr, value, MMC64.this.active ^ 1);
        }
    };
    protected final Bank io1Bank = new Bank(){

        @Override
        public byte read(int addr) {
            return MMC64.this.io2Bank.read(addr);
        }

        @Override
        public void write(int addr, byte value) {
            if (addr == 56833) {
                MMC64.this.clockportEnableStore(value != 0);
            }
            if (addr >= 56848 && addr <= 56851 && MMC64.this.hwFlashJumper) {
                MMC64.this.regStore(addr, value, 1);
            }
        }
    };
    protected final Bank romlBank = new Bank(){

        @Override
        public byte read(int addr) {
            if (0 == MMC64.this.active && 0 == MMC64.this.biossel) {
                return MMC64.this.bios[addr & 0x1FFF];
            }
            return MMC64.this.pla.getDisconnectedBusBank().read(addr);
        }

        @Override
        public void write(int addr, byte value) {
            if (addr == 57121) {
                MMC64.this.clockportEnableStore(value != 0);
            }
            if (addr >= 57104 && addr <= 57107) {
                if (0 == MMC64.this.active && 0 == MMC64.this.biossel && MMC64.this.flashJumper != 0 && MMC64.this.flashMode != 0 && MMC64.this.bios[addr & 0x1FFF] != value) {
                    MMC64.this.bios[addr & 0x1FFF] = value;
                    MMC64.this.biosChanged = true;
                }
                MMC64.this.pla.cpuWrite(addr, value);
            }
        }
    };

    public MMC64(PLA pla, File imgFile) {
        super(pla);
        this.setImageFilename(imgFile.getAbsolutePath());
        this.setEnabled(true);
    }

    public int cartActive() {
        if (this.enabled && 0 == this.active && 0 == this.biossel) {
            return 1;
        }
        return 0;
    }

    @Override
    public void reset() {
        this.active = 0;
        this.spiMode = 0;
        this.extrom = 0;
        this.flashMode = 0;
        this.cport = 0;
        this.speed = 0;
        this.cardsel = 0;
        this.biossel = 0;
        if (!this.clockportEnabled) {
            this.clockportEnabled = true;
        }
        if (this.enabled) {
            this.pla.setGameExrom(true, false);
        }
    }

    private void activate() {
        this.biosChanged = false;
        try {
            this.card.mmc_open_card_image(this.imageFilename, !this.hwWriteProtect);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void deactivate() {
        this.card.closeCardImage();
        if (!this.biosChanged || this.biosWrite != 0) {
            // empty if block
        }
    }

    private void setEnabled(boolean en) {
        if (!en) {
            if (this.enabled) {
                this.deactivate();
            }
            this.enabled = false;
            this.pla.setGameExrom(true, true);
        } else {
            if (!this.enabled) {
                this.activate();
            }
            this.enabled = true;
            this.pla.setGameExrom(true, false);
        }
    }

    public void setReadOnly(boolean ro) {
        this.hwWriteProtect = !this.imageFileReadonly ? ro : true;
    }

    public void setFlashJumper(boolean val) {
        this.hwFlashJumper = val;
        this.flashJumper = (byte)(val ? 32 : 0);
    }

    public void setRevision(int val) {
        this.revision = val;
    }

    public void setSdType(int val) {
        this.sdType = val;
        this.card.setCardType(val);
    }

    public void setBiosWrite(int val) {
        this.biosWrite = val;
    }

    public void configInit() {
        this.active = 0;
        this.spiMode = 0;
        this.extrom = 0;
        this.flashMode = 0;
        this.cport = 0;
        this.speed = 0;
        this.cardsel = 0;
        this.biossel = 0;
        this.extExrom = true;
        this.extGame = true;
        if (this.enabled) {
            this.pla.setGameExrom(true, false);
        }
    }

    void passthrough_changed() {
        this.extExrom = true;
        this.extGame = true;
    }

    void clockportEnableStore(int addr, byte value) {
        if ((value & 1) != 0 != this.clockportEnabled) {
            this.clockportEnabled = (value & 1) != 0;
        }
    }

    public void clockportEnableStore(boolean value) {
        this.clockportEnabled = value;
    }

    protected void regStore(int addr, byte value, int active) {
        if (this.enabled && addr >= 57104 && addr <= 57107) {
            switch (addr) {
                case 57104: {
                    if (active == 0) break;
                    this.card.dataWrite(value);
                    return;
                }
                case 57105: {
                    if (active == 0) break;
                    this.biossel = (byte)(value & 1);
                    this.extrom = (byte)(value >> 5 & 1);
                    this.card.cardSelectedWrite((byte)((value >> 1 ^ 1) & 1));
                    this.card.spi_mmc_enable_8mhz_write((byte)(value >> 2 & 1));
                    this.cport = (byte)(value >> 3 & 1);
                    if (this.flashJumper != 0) {
                        this.flashMode = (byte)(value >> 4 & 1);
                    }
                    this.card.triggerModeWrite((byte)(value >> 6 & 1));
                    active = value >> 7 & 1;
                    if (active != 0) {
                        this.pla.setGameExrom(true, true);
                    } else if (this.biossel != 0) {
                        this.pla.setGameExrom(true, true);
                    } else {
                        this.pla.setGameExrom(true, false);
                    }
                    this.hwClockport = this.cport != 0 ? 57122 : 56834;
                    return;
                }
                case 57106: {
                    break;
                }
                case 57107: {
                    this.unlocking[0] = this.unlocking[1];
                    this.unlocking[1] = value;
                    if (this.unlocking[0] == 85 && this.unlocking[1] == -86) {
                        System.out.println("bit 7 unlocked");
                        this.bit7Unlocked = true;
                    }
                    if (this.unlocking[0] != 10 || this.unlocking[1] != 28) break;
                    active = 0;
                    this.pla.setGameExrom(true, false);
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    private int setImageFilename(String name) {
        if (this.imageFilename != null && name != null && name.equals(this.imageFilename)) {
            return 0;
        }
        if (name != null && name.length() > 0 && !new File(name).exists()) {
            return -1;
        }
        if (this.enabled) {
            this.deactivate();
            this.imageFilename = name;
            this.activate();
        } else {
            this.imageFilename = name;
        }
        return 0;
    }

    @Override
    public Bank getRoml() {
        return this.romlBank;
    }

    @Override
    public Bank getIO1() {
        return this.io1Bank;
    }

    @Override
    public Bank getIO2() {
        return this.io2Bank;
    }

    public static void main(String[] args) {
        try {
            File file = new File("E:/usb/develop/workspace/jsidplay2/test/cart/mmc64/1.10/mmc64v1b.upd");
            DataInputStream dis = new DataInputStream(new FileInputStream(file));
            byte[] b = new byte[(int)file.length()];
            dis.readFully(b, 0, 1049);
            dis.readFully(b, 0, 8192);
            dis.close();
            for (int i = 0; i < 8192; i += 8) {
                if (i % 8 == 0) {
                    System.out.print("\n\t\t");
                }
                for (int j = 0; j < 8 && i + j < 8192; ++j) {
                    System.out.printf(" (byte) 0x%02X,", b[i + j]);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

