/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported;

import java.io.DataInputStream;
import java.io.IOException;
import libsidplay.common.Event;
import libsidplay.components.cart.Cartridge;
import libsidplay.components.pla.Bank;
import libsidplay.components.pla.PLA;

public class FinalV3
extends Cartridge {
    protected int currentRomBank;
    protected final byte[][] romLBanks;
    protected final byte[][] romHBanks;
    protected boolean controlRegAvailable;
    private final Bank ioBank = new Bank(){

        @Override
        public byte read(int address) {
            return FinalV3.this.romLBanks[FinalV3.this.currentRomBank][address & 0x1FFF];
        }

        @Override
        public void write(int address, byte value) {
            if (FinalV3.this.controlRegAvailable && address == 57343) {
                FinalV3.this.currentRomBank = value & 3;
                FinalV3.this.pla.setGameExrom(true, true, (value & 0x20) != 0, (value & 0x10) != 0);
                FinalV3.this.setNMI((value & 0x40) == 0);
                if ((value & 0x80) != 0) {
                    FinalV3.this.controlRegAvailable = false;
                }
            }
        }
    };
    private final Bank romlBank = new Bank(){

        @Override
        public byte read(int address) {
            return FinalV3.this.romLBanks[FinalV3.this.currentRomBank][address & 0x1FFF];
        }

        @Override
        public void write(int address, byte value) {
        }
    };
    private final Bank romhBank = new Bank(){

        @Override
        public byte read(int address) {
            return FinalV3.this.romHBanks[FinalV3.this.currentRomBank][address & 0x1FFF];
        }

        @Override
        public void write(int address, byte value) {
        }
    };

    public FinalV3(DataInputStream dis, PLA pla) throws IOException {
        super(pla);
        byte[] chipHeader = new byte[16];
        this.romLBanks = new byte[4][8192];
        this.romHBanks = new byte[4][8192];
        for (int i = 0; i < 4; ++i) {
            dis.readFully(chipHeader);
            if (chipHeader[12] != -96 && chipHeader[14] != 64 && chipHeader[11] > 3) {
                throw new RuntimeException("Unexpected Chip header!");
            }
            int bank = chipHeader[11] & 0xFF;
            dis.readFully(this.romLBanks[bank]);
            dis.readFully(this.romHBanks[bank]);
        }
    }

    @Override
    public Bank getRoml() {
        return this.romlBank;
    }

    @Override
    public Bank getRomh() {
        return this.romhBank;
    }

    @Override
    public Bank getIO1() {
        return this.ioBank;
    }

    @Override
    public Bank getIO2() {
        return this.ioBank;
    }

    @Override
    protected void doFreeze() {
        this.setNMI(true);
        this.pla.getCPU().getEventScheduler().schedule(new Event("Freeze"){

            @Override
            public void event() {
                FinalV3.this.pla.setGameExrom(false, true);
            }
        }, 3L, Event.Phase.PHI1);
    }

    @Override
    public void reset() {
        super.reset();
        this.pla.setGameExrom(false, false);
        this.currentRomBank = 0;
        this.controlRegAvailable = true;
    }
}

