/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported;

import java.io.DataInputStream;
import java.io.IOException;
import libsidplay.common.Event;
import libsidplay.components.cart.Cartridge;
import libsidplay.components.pla.Bank;
import libsidplay.components.pla.PLA;

public class FinalV1
extends Cartridge {
    protected final byte[] roml = new byte[8192];
    protected final byte[] romh = new byte[8192];
    private final Bank io1Bank = new Bank(){

        @Override
        public byte read(int address) {
            FinalV1.this.setNMI(false);
            FinalV1.this.pla.setGameExrom(true, true);
            return FinalV1.this.roml[address & 0x1FFF];
        }

        @Override
        public void write(int address, byte value) {
            FinalV1.this.setNMI(false);
            FinalV1.this.pla.setGameExrom(true, true);
        }
    };
    private final Bank io2Bank = new Bank(){

        @Override
        public byte read(int address) {
            FinalV1.this.pla.setGameExrom(false, false);
            return FinalV1.this.roml[address & 0x1FFF];
        }

        @Override
        public void write(int address, byte value) {
            FinalV1.this.pla.setGameExrom(false, false);
        }
    };
    private final Bank romlBank = new Bank(){

        @Override
        public byte read(int address) {
            return FinalV1.this.roml[address & 0x1FFF];
        }

        @Override
        public void write(int address, byte value) {
        }
    };
    private final Bank romhBank = new Bank(){

        @Override
        public byte read(int address) {
            return FinalV1.this.romh[address & 0x1FFF];
        }

        @Override
        public void write(int address, byte value) {
        }
    };

    public FinalV1(DataInputStream dis, PLA pla) throws IOException {
        super(pla);
        byte[] chipHeader = new byte[16];
        dis.readFully(chipHeader);
        if (chipHeader[12] != -128 || chipHeader[14] != 64) {
            throw new RuntimeException("Unexpected Chip header!");
        }
        dis.readFully(this.roml);
        dis.readFully(this.romh);
    }

    @Override
    public Bank getRoml() {
        return this.romlBank;
    }

    @Override
    public Bank getRomh() {
        return this.romhBank;
    }

    @Override
    public Bank getIO1() {
        return this.io1Bank;
    }

    @Override
    public Bank getIO2() {
        return this.io2Bank;
    }

    @Override
    protected void doFreeze() {
        this.setNMI(true);
        this.pla.getCPU().getEventScheduler().schedule(new Event("Freeze"){

            @Override
            public void event() {
                FinalV1.this.pla.setGameExrom(false, true);
            }
        }, 3L, Event.Phase.PHI1);
    }

    @Override
    public void reset() {
        super.reset();
        this.pla.setGameExrom(true, true);
    }
}

