/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.Arrays;
import libsidplay.common.Event;
import libsidplay.components.cart.Cartridge;
import libsidplay.components.cart.supported.core.Flash040Core;
import libsidplay.components.pla.Bank;
import libsidplay.components.pla.PLA;

public class EasyFlash
extends Cartridge {
    private Flash040Core core = new Flash040Core(){

        @Override
        protected long maincpuClk() {
            return EasyFlash.this.pla.getCPU().getEventScheduler().getTime(Event.Phase.PHI1);
        }

        @Override
        protected void alarmUnset(Event alarm) {
            EasyFlash.this.pla.getCPU().getEventScheduler().cancel(alarm);
        }

        @Override
        protected void alarmSet(Event alarm, long time) {
            EasyFlash.this.pla.getCPU().getEventScheduler().schedule(alarm, time);
        }
    };
    private static final int EASYFLASH_N_BANK_BITS = 6;
    private static final int EASYFLASH_N_BANKS = 64;
    private static final int EASYFLASH_BANK_MASK = 63;
    private Flash040Core.Flash040Context easyflashStateLow;
    private Flash040Core.Flash040Context easyflashStateHigh;
    private int easyflashJumper;
    private boolean easyflashCrtWrite;
    private byte easyflashRegister00;
    private byte easyflashRegister02;
    private static final byte[] easyflashMemconfig = new byte[]{3, 3, 1, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1};
    private byte[] easyflashRam = new byte[256];
    private String easyflashFilename;
    private int easyflashFiletype;
    private final String STRING_EASYFLASH = CARTRIDGE_NAME_EASYFLASH;
    protected static final Charset US_ASCII = Charset.forName("US-ASCII");
    private static String CARTRIDGE_NAME_EASYFLASH = "EasyFlash";
    private static int CARTRIDGE_FILETYPE_BIN = 1;
    private static int CARTRIDGE_FILETYPE_CRT = 2;
    private static String CRT_HEADER = "C64 CARTRIDGE   ";
    private static String CHIP_HEADER = "CHIP";
    private static byte CARTRIDGE_EASYFLASH = (byte)32;
    private byte[] romlBanks = new byte[524288];
    private byte[] romhBanks = new byte[524288];
    int romlBankNum;
    int romhBankNum;
    private final Bank io1Bank = new Bank(){

        @Override
        public byte read(int addr) {
            return EasyFlash.this.pla.getDisconnectedBusBank().read(addr);
        }

        @Override
        public void write(int addr, byte value) {
            EasyFlash.this.easyflashIO1Store(addr, value);
        }
    };
    private final Bank io2Bank = new Bank(){

        @Override
        public byte read(int addr) {
            return EasyFlash.this.easyflashIO2Read(addr);
        }

        @Override
        public void write(int addr, byte value) {
            EasyFlash.this.easyflashIO2Store(addr, value);
        }
    };
    private final Bank romlBank = new Bank(){

        @Override
        public byte read(int addr) {
            return EasyFlash.this.easyflashRomlRead(addr);
        }

        @Override
        public void write(int addr, byte value) {
            EasyFlash.this.easyflashRomlStore(addr, value);
        }
    };
    private final Bank romhBank = new Bank(){

        @Override
        public byte read(int addr) {
            return EasyFlash.this.easyflashRomhRead(addr);
        }

        @Override
        public void write(int addr, byte value) {
            EasyFlash.this.easyflashRomhStore(addr, value);
        }
    };

    protected void easyflashIO1Store(int addr, byte value) {
        switch (addr & 2) {
            case 0: {
                this.easyflashRegister00 = (byte)(value & 0x3F);
                break;
            }
            default: {
                this.easyflashRegister02 = (byte)(value & 0x87);
                byte memMode = easyflashMemconfig[this.easyflashJumper << 3 | this.easyflashRegister02 & 7];
                this.pla.setGameExrom(true, true, (memMode & 1) == 0, (memMode & 2) != 0);
            }
        }
        this.cartRomhBankSetSlotmain(this.easyflashRegister00);
        this.cartRomlBankSetSlotmain(this.easyflashRegister00);
        this.cartPortConfigChangedSlotmain();
    }

    protected byte easyflashIO2Read(int addr) {
        return this.easyflashRam[addr & 0xFF];
    }

    protected void easyflashIO2Store(int addr, byte value) {
        this.easyflashRam[addr & 0xFF] = value;
    }

    protected byte easyflashIO1Peek(int addr) {
        return (addr & 2) != 0 ? this.easyflashRegister02 : this.easyflashRegister00;
    }

    protected void easyflashIO1Dump() {
        System.out.printf("Mode %d, LED %s, jumper %s\n", easyflashMemconfig[this.easyflashJumper << 3 | this.easyflashRegister02 & 7], (this.easyflashRegister02 & 0x80) != 0 ? "on" : "off", this.easyflashJumper != 0 ? "on" : "off");
    }

    private boolean easyflashCheckEmpty(byte[] data, int dataPos) {
        for (int i = 0; i < 8192; ++i) {
            if (data[dataPos + i] == 255) continue;
            return false;
        }
        return true;
    }

    public void setEasyflashJumper(boolean val) {
        this.easyflashJumper = val ? 1 : 0;
    }

    public void setEasyflashCRTWrite(boolean val) {
        this.easyflashCrtWrite = val;
    }

    private void easyflashWriteChipIfNotEmpty(RandomAccessFile fd, byte[] chipheader, byte[] data, int dataPos) throws IOException {
        if (!this.easyflashCheckEmpty(data, dataPos)) {
            fd.write(chipheader, 0, 16);
            fd.write(data, dataPos, 8192);
        }
    }

    public byte easyflashRomlRead(int addr) {
        return this.core.flash040CoreRead(this.easyflashStateLow, ((this.easyflashRegister00 & 0xFF) << 13) + (addr & 0x1FFF));
    }

    public void easyflashRomlStore(int addr, byte value) {
        this.core.flash040CoreStore(this.easyflashStateLow, ((this.easyflashRegister00 & 0xFF) << 13) + (addr & 0x1FFF), value);
    }

    public byte easyflashRomhRead(int addr) {
        return this.core.flash040CoreRead(this.easyflashStateHigh, ((this.easyflashRegister00 & 0xFF) << 13) + (addr & 0x1FFF));
    }

    public void easyflashRomhStore(int addr, byte value) {
        this.core.flash040CoreStore(this.easyflashStateHigh, ((this.easyflashRegister00 & 0xFF) << 13) + (addr & 0x1FFF), value);
    }

    public void easyflashConfigInit() {
        this.easyflashIO1Store(56832, (byte)0);
        this.easyflashIO1Store(56834, (byte)0);
    }

    public void easyflashConfigSetup(byte[] rawcart) {
        this.easyflashStateLow = new Flash040Core.Flash040Context();
        this.easyflashStateHigh = new Flash040Core.Flash040Context();
        this.core.flash040coreInit(this.easyflashStateLow, this.pla.getCPU().getEventScheduler(), Flash040Core.Flash040Type.FLASH040_TYPE_B, this.romlBanks);
        System.arraycopy(rawcart, 0, this.easyflashStateLow.flashData, 0, 524288);
        this.core.flash040coreInit(this.easyflashStateHigh, this.pla.getCPU().getEventScheduler(), Flash040Core.Flash040Type.FLASH040_TYPE_B, this.romhBanks);
        System.arraycopy(rawcart, 524288, this.easyflashStateHigh.flashData, 0, 524288);
    }

    private void easyflashCommonAttach(String filename) {
        this.easyflashFilename = filename;
    }

    public void easyflashBinAttach(String filename, byte[] rawcart) throws IOException {
        this.easyflashFiletype = 0;
        Arrays.fill(rawcart, 0, 0x100000, (byte)-1);
        RandomAccessFile fd = new RandomAccessFile(filename, "r");
        int low = 0;
        int i = 0;
        while (i < 64) {
            fd.read(rawcart, low, 8192);
            fd.read(rawcart, low + 524288, 8192);
            ++i;
            low += 8192;
        }
        fd.close();
        this.easyflashFiletype = CARTRIDGE_FILETYPE_BIN;
        this.easyflashCommonAttach(filename);
    }

    public boolean easyflashCRTAttach(DataInputStream dis, byte[] rawcart, String filename) throws IOException {
        block6: {
            byte[] chipheader = new byte[16];
            this.easyflashFiletype = 0;
            Arrays.fill(rawcart, 0, 0x100000, (byte)-1);
            while (true) {
                try {
                    dis.readFully(chipheader);
                }
                catch (EOFException e) {
                    break block6;
                }
                int bank = (chipheader[10] & 0xFF) << 8 | chipheader[11];
                int offset = (chipheader[12] & 0xFF) << 8 | chipheader[13];
                int length = (chipheader[14] & 0xFF) << 8 | chipheader[15];
                if (length == 8192) {
                    if (bank >= 64 || offset != 32768 && offset != 40960 && offset != 57344) {
                        return false;
                    }
                    dis.read(rawcart, bank << 13 | (offset == 32768 ? 0 : 524288), 8192);
                    continue;
                }
                if (length != 16384) break;
                if (bank >= 64 || offset != 32768) {
                    return false;
                }
                dis.read(rawcart, bank << 13 | 0, 8192);
                dis.read(rawcart, bank << 13 | 0x80000, 8192);
            }
            return false;
        }
        this.easyflashFiletype = CARTRIDGE_FILETYPE_CRT;
        this.easyflashCommonAttach(filename);
        return true;
    }

    public void easyflashDetach() throws IOException {
        if (this.easyflashCrtWrite) {
            this.easyflashFlushImage();
        }
        this.core.flash040CoreShutdown(this.easyflashStateLow);
        this.core.flash040CoreShutdown(this.easyflashStateHigh);
        this.easyflashStateLow = null;
        this.easyflashStateHigh = null;
        this.easyflashFilename = null;
    }

    public void easyflashFlushImage() throws IOException {
        if (this.easyflashFilename != null) {
            if (this.easyflashFiletype == CARTRIDGE_FILETYPE_BIN) {
                this.easyflashBINSave(this.easyflashFilename);
            } else if (this.easyflashFiletype == CARTRIDGE_FILETYPE_CRT) {
                this.easyflashCRTSave(this.easyflashFilename);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void easyflashBINSave(String filename) throws IOException {
        assert (filename != null);
        RandomAccessFile fd = null;
        try {
            fd = new RandomAccessFile(filename, "r");
            for (int i = 0; i < 64; ++i) {
                fd.write(this.easyflashStateLow.flashData, i << 13, 8192);
                fd.write(this.easyflashStateHigh.flashData, i << 13, 8192);
            }
        }
        finally {
            if (fd != null) {
                try {
                    fd.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void easyflashCRTSave(String filename) throws IOException {
        assert (filename != null);
        RandomAccessFile fd = null;
        try {
            fd = new RandomAccessFile(filename, "rw");
            byte[] header = new byte[64];
            byte[] chipheader = new byte[16];
            System.arraycopy(CRT_HEADER.getBytes(US_ASCII), 0, header, 0, CRT_HEADER.getBytes(US_ASCII).length);
            header[19] = 64;
            header[20] = 1;
            header[23] = CARTRIDGE_EASYFLASH;
            header[24] = 1;
            System.arraycopy(this.STRING_EASYFLASH.getBytes(US_ASCII), 0, header, 32, this.STRING_EASYFLASH.getBytes(US_ASCII).length);
            fd.write(header);
            System.arraycopy(CHIP_HEADER.getBytes(US_ASCII), 0, chipheader, 0, CHIP_HEADER.getBytes(US_ASCII).length);
            chipheader[6] = 32;
            chipheader[7] = 16;
            chipheader[9] = 2;
            chipheader[14] = 32;
            for (int i = 0; i < 64; ++i) {
                chipheader[11] = (byte)i;
                chipheader[12] = -128;
                this.easyflashWriteChipIfNotEmpty(fd, chipheader, this.easyflashStateLow.flashData, i << 13);
                chipheader[12] = -96;
                this.easyflashWriteChipIfNotEmpty(fd, chipheader, this.easyflashStateHigh.flashData, i << 13);
            }
        }
        finally {
            if (fd != null) {
                try {
                    fd.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    void cartRomhBankSetSlotmain(int bank) {
        this.romhBankNum = bank;
    }

    void cartRomlBankSetSlotmain(int bank) {
        this.romlBankNum = bank;
    }

    void cartPortConfigChangedSlotmain() {
    }

    public EasyFlash(DataInputStream dis, PLA pla) throws IOException {
        super(pla);
        byte[] rawcart = new byte[0x100000];
        this.easyflashCRTAttach(dis, rawcart, "d:/easyflash.crt");
        this.easyflashConfigSetup(rawcart);
    }

    @Override
    public void reset() {
        super.reset();
        this.easyflashConfigInit();
    }

    @Override
    public Bank getIO1() {
        return this.io1Bank;
    }

    @Override
    public Bank getIO2() {
        return this.io2Bank;
    }

    @Override
    public Bank getRoml() {
        return this.romlBank;
    }

    @Override
    public Bank getRomh() {
        return this.romhBank;
    }
}

